/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "html.h"

/***************************************************************************/
/*                                                                         */
/*  Tag structure                                                          */
/*                                                                         */
/***************************************************************************/

void initStructure( struct structuredef_t *structure )
{
  structure->anchored = 0;
  structure->titled = 0;
  structure->headered = 0;
}

void copyStructure( struct structuredef_t *to, struct structuredef_t *from)
{
  to->anchored = from->anchored;
  to->titled = from->titled;
  to->headered = from->headered;
}

void applyStructure( int c, struct structuredef_t *structure)
{
  switch( c )
  {
    case SPECIAL_TITLE_START_CHAR:
      structure->titled++;
      break;
    case SPECIAL_TITLE_END_CHAR:
      if( structure->titled > 0 ) structure->titled--;
      break;
    case SPECIAL_HEADING_START_CHAR:
      structure->headered++;
      break;
    case SPECIAL_HEADING_END_CHAR:
      if( structure->headered > 0 ) structure->headered--;
      break;
    case SPECIAL_ANCHOR_START_CHAR:
      structure->anchored++;
      break;
    case SPECIAL_ANCHOR_END_CHAR:
      if( structure->anchored > 0 ) structure->anchored--;
      break;
  }
}

void minimizeStructure( struct structuredef_t *what, struct structuredef_t *with)
{
  if( what->titled > with->titled ) what->titled = with->titled;
  if( what->headered > with->headered ) what->headered = with->headered;
  if( what->anchored > with->anchored ) what->anchored = with->anchored;
}
