/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "html.h"

static const char * const styleTagTable[] =
{
  "b",
  "big",
  "blink",
  "blockquote",
  "cite",
  "code",
  "div",
  "dfn",
  "em",
  "font",
  "i",
  "kbd",
  "pre",
  "s",
  "samp",
  "small",
  "strike",
  "strong",
  "tt",
  "u",
  "var",
  NULL
};

#define STYLE_TAG_COUNT (sizeof( styleTagTable ) / sizeof( char * ) - 1)

Boolean isStyleTag( const char *tag )
{
  int lower, upper;

  if( *tag == '/' ) tag++;

  for( lower=0, upper=STYLE_TAG_COUNT-1; lower <= upper; )
  {
    int midpoint = (lower + upper) >> 1;
    register int cmp = strcasecmp( tag, styleTagTable[midpoint]);

    if( cmp == 0 )
      return True;
    if( cmp > 0 )
      lower = midpoint + 1;
    else
      upper = midpoint - 1;
  }

  return False;
}
