/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zchars.h"

#include "defs.h"
#include "html.h"

/***************************************************************************/
/*                                                                         */
/*  Tag chars                                                              */
/*                                                                         */
/***************************************************************************/

struct tagchar_t
{
  const char *tagName;
  char tagLength;
  char tagStartChar;
  char tagEndChar;
};

static struct tagchar_t tagcharTable[] =
{
  { "title",  5, SPECIAL_TITLE_START_CHAR,    SPECIAL_TITLE_END_CHAR    },
  { "h1",     2, SPECIAL_HEADING_START_CHAR,  SPECIAL_HEADING_END_CHAR  },
  { "h2",     2, SPECIAL_HEADING_START_CHAR,  SPECIAL_HEADING_END_CHAR  },
  { "h3",     2, SPECIAL_HEADING_START_CHAR,  SPECIAL_HEADING_END_CHAR  },
  { "h4",     2, SPECIAL_HEADING_START_CHAR,  SPECIAL_HEADING_END_CHAR  },
  { "a",      1, SPECIAL_ANCHOR_START_CHAR,   SPECIAL_ANCHOR_END_CHAR   },
  { NULL,     0, '\0',                        '\0'                      }
};

int getTagChar( const char *tag )
{
  Boolean start = True;
  struct tagchar_t *cur;

  while( isSpace( *tag ) ) tag++;

  if( *tag == '/' )
  {
    start = False;
    tag++;
  }

  if( !isAlpha( *tag ) ) return '\0';

  for( cur = tagcharTable; cur->tagName != NULL; cur++)
    if( strncasecmp( cur->tagName, tag, cur->tagLength) == 0 )
      if( !isAlnum( tag[cur->tagLength] ) )
        return start ? cur->tagStartChar : cur->tagEndChar;

  return '\0';
}

void markupTagChars()
{
  setCharbit( SPECIAL_TITLE_START_CHAR, CHAR_SPECIAL);
  setCharbit( SPECIAL_TITLE_END_CHAR, CHAR_SPECIAL);
  setCharbit( SPECIAL_HEADING_START_CHAR, CHAR_SPECIAL);
  setCharbit( SPECIAL_HEADING_END_CHAR, CHAR_SPECIAL);
  setCharbit( SPECIAL_ANCHOR_START_CHAR, CHAR_SPECIAL);
  setCharbit( SPECIAL_ANCHOR_END_CHAR, CHAR_SPECIAL);
}
