/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __HTML_A
#define __HTML_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define SPECIAL_TITLE_START_CHAR          1
#define SPECIAL_TITLE_END_CHAR            2
#define SPECIAL_HEADING_START_CHAR        3
#define SPECIAL_HEADING_END_CHAR          4
#define SPECIAL_ANCHOR_START_CHAR         5
#define SPECIAL_ANCHOR_END_CHAR           6

struct structuredef_t
{
  int titled;
  int headered;
  int anchored;
};

void markupTagChars( void );
int getTagChar( const char *tag );

Boolean isStyleTag( const char *tag );

void initStructure( struct structuredef_t *structure );
void copyStructure( struct structuredef_t *to, struct structuredef_t *from);
void applyStructure( int c, struct structuredef_t *structure);
void minimizeStructure( struct structuredef_t *what, struct structuredef_t *with);

char *convertEntities( char *string );

#ifdef __cplusplus
}
#endif

#endif
