/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __FLUDATA_A
#define __FLUDATA_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct errword_t;

struct fludata_t
{
  const char * const *errorFormats;
  int queryError;
  const char *queryErrorStart;
  const char *queryErrorPointer;
  struct errword_t *errwordHead;
  struct zparamcoll_t stopWordCollection;
  struct zparamcoll_t validWordCollection;
  struct zstrcoll_t *stopWords;
  struct zstrcoll_t *validWords;
};

#define _FLU(cnt) ((cnt)->info1)
#define FLU(cnt)  ((struct fludata_t *) _FLU(cnt))

#define FLU_QUERY_ERROR_COPY(dst,src) \
    do                                \
    {                                 \
      (dst)->queryError = (src)->queryError; \
      (dst)->queryErrorStart = (src)->queryErrorStart; \
      (dst)->queryErrorPointer = (src)->queryErrorPointer; \
    } while( 0 )

void initFludata( struct zcontext_t *cnt, struct fludata_t *flu);

#ifdef __cplusplus
}
#endif

#endif
