/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcoll.h"

#include "cfg.h"
#include "error.h"
#include "fludata.h"

void initFludata( struct zcontext_t *cnt, struct fludata_t *flu)
{
  ZEROFILL( flu, sizeof( struct fludata_t ));
  _FLU(cnt) = flu;

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( UKRAINIAN_SUPPORT ) && defined( UKRAINIAN_INTERFACE )
  flu->errorFormats = fluErrorUkrainianFormats;
#elif defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( RUSSIAN_INTERFACE )
  flu->errorFormats = fluErrorRussianFormats;
#else
  flu->errorFormats = fluErrorEnglishFormats;
#endif

  (void) zParamCollectionInit( cnt, &flu->stopWordCollection, 0, 10, zcfSorted | zcfCheckDuplicate, 1, NULL, NULL);
  (void) zParamCollectionInit( cnt, &flu->validWordCollection, 0, 10, zcfSorted | zcfCheckDuplicate, 1, NULL, NULL);
  flu->stopWords = (struct zstrcoll_t *) &flu->stopWordCollection;
  flu->validWords = (struct zstrcoll_t *) &flu->validWordCollection;
}
