/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ERROR_A
#define __ERROR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

enum
{
  errNoError = 0,
  errProgParams,
  errDifferentCharset,

/* Index File errors */
  errIndexFileFormat,
  errIndexFileOpen,
  errIndexFileSeek,
  errIndexFileTell,
  errIndexFileVersion,
  errIndexFileSize,
  errIndexFileId,
  errIndexChecksum,
  errIndexFileCount,
  errIndexFileOffsetsCount,
  errIndexFileStructuresCount,
  errIndexFileOffsets,
  errIndexWordTrackSize,
  errIndexWordTrackOffsets,
#ifdef CHECK
  errIndexOffsets,
#endif
  errIndexFileRead,
#ifdef CHECK
  errIndexFileReadInfo,
  errIndexFileReadStopWords,
  errIndexFileReadValidWords,
  errIndexFileReadFileInfo,
#else
  errIndexFileReadInfo = errIndexFileRead,
  errIndexFileReadStopWords = errIndexFileRead,
  errIndexFileReadValidWords = errIndexFileRead,
  errIndexFileReadFileInfo = errIndexFileRead,
#endif
  errIndexFileWrite,
#ifdef CHECK
  errIndexFileWriteHeader,
  errIndexFileWriteInfo,
  errIndexFileWriteStopWords,
  errIndexFileWriteValidWords,
  errIndexFileWriteFileOffsets,
  errIndexFileWriteFileStructures,
  errIndexFileWriteFileInfo,
#else
  errIndexFileWriteHeader = errIndexFileWrite,
  errIndexFileWriteInfo = errIndexFileWrite,
  errIndexFileWriteStopWords = errIndexFileWrite,
  errIndexFileWriteValidWords = errIndexFileWrite,
  errIndexFileWriteFileOffsets = errIndexFileWrite,
  errIndexFileWriteFileStructures = errIndexFileWrite,
  errIndexFileWriteFileInfo = errIndexFileWrite,
#endif
  errIndexFileOverlappingNames,
  errInvalidFilenoValue,
  errNoSuchDocument,

/* Query errors */
  errNoQuery,
  errQuote,
  errBlankQuotedString,
  errClosingParanthis,
  errNoReasonableQuery,
  errStopWord,
  errShortWord,
  errLongWord,
  errBeginChar,
  errEndChar
};

ZEXT(const char * const) fluErrorEnglishFormats[];
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( RUSSIAN_INTERFACE )
ZEXT(const char * const) fluErrorRussianFormats[];
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( UKRAINIAN_SUPPORT ) && defined( UKRAINIAN_INTERFACE )
ZEXT(const char * const) fluErrorUkrainianFormats[];
#endif

ZAPI(char *) fluGetErrorString( struct zcontext_t *cnt, char *buffer, int size,
    unsigned zint_t errorCode, const char *name);

#ifdef __cplusplus
}
#endif

#endif
