/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zalloc.h"

#include "defs.h"
#include "docmap.h"

/***************************************************************************/
/*                                                                         */
/*  Document map                                                           */
/*                                                                         */
/***************************************************************************/

void dmapInit( struct zcontext_t *cnt, struct flu_docmap_t *map, _fn_t size)
{
  map->length = 0;
  if( (map->size = size) == 0 )
    map->map = NULL;
  else
  {
    map->map = zMalloc( cnt, size * sizeof(_fn_t));
    ZEROFILL( map->map, size * sizeof(_fn_t));
  }
}

void dmapFree( struct zcontext_t *cnt, struct flu_docmap_t *map)
{
  ZFREE( cnt, map->map);
  map->size = map->length = 0;
}
