/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __RESULTS_A
#define __RESULTS_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct searchdata_t;
struct indexfile_t;
struct expression_t;

/* Result icons */
unsigned int getResultIconSize( void );
void freeResultIcon( struct zcontext_t *cnt, void *data);
void addResultIcon( struct searchdata_t *sd,
    const char *location, const char *altText, struct zstrcoll_t *patterns);

/* Replaces */
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
Boolean initReplaceConfig( struct zcontext_t *cnt, struct zconfsec_t *ccb,
    unsigned int flags, const char *fileName, void *data);
Boolean processReplaceConfig( struct zcontext_t *cnt, char *line, void *data);
void finishReplaceConfig( struct zcontext_t *cnt, Boolean success,
    Boolean hasValue, void *data);
#endif

/* Result items */
struct flu_searcher_t;

struct queryvalues_t
{
  struct flu_searcher_t *searcher;
  const char *query;
  Boolean formed;
  int foundCount;
  int totalPages;
  int count;
  int startPage;
  int pageSize;
  int skipCount;
  int currentBlock;
  int totalBlocks;
  int beginPage;
  int endPage;
  int currentPage;
};

void writeResultList( struct zcgidata_t *cd, struct queryvalues_t *queryValues);

void writeResultHeader( struct zcgidata_t *cd );

#ifdef __cplusplus
}
#endif

#endif
