/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __QUERYPRM_A
#define __QUERYPRM_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Task */
struct task_t
{
  const char *name;
  int task;
  unsigned int area;
};

#define WHAT_ACTION           "w"
#define ACTION_QUERY_FORM     "frm"
#define ACTION_SEARCH         "sch"

#define PARAM_CONFFILE        "cfg"
#define PARAM_QUERYSTRING     "q"
#define PARAM_INDEXNAME       "ind"
#define PARAM_QUERYTYPE       "qt"
#define PARAM_TERSETYPE       "trs"
#define PARAM_PAGESIZE        "page"
#define PARAM_AREA            "ar"
#define PARAM_START           "start"
#define PARAM_SEARCH_FLAGS    "fl"

#define TERSE_SHORT           "srt"
#define TERSE_STANDARD        "std"
#define TERSE_DETAILED        "dtl"

#define SFLAG_CASE_DEPEND     "cd"

enum
{
  taskQueryForm,
  taskSearch
};

#define areaQueryForm         0x01
#define areaSearch            0x02

const struct task_t *getTask( struct zcgidata_t *cd );

/* Conf file */
const char *getCurrentConfFile( struct zcgidata_t *cd );

/* User query */
const char *getUserQuery( struct zcgidata_t *cd );

/* Query type */
enum
{
  qtpExternalForm = 0,
  qtpInternalForm,
  qtpLastType
};

int getQueryType( const char *name );
const char *getQueryName( int type );

int getCurrentQueryType( struct zcgidata_t *cd );

/* Index list */
int selectIndexes( struct zcgidata_t *cd, Boolean usedMode);

/* Terse Type */
enum
{
  trsShort = 0,
  trsStandard,
  trsDetailed,
  trsLastType
};

int getTerseType( const char *name );
const char *getTerseName( int type );
int getCurrentTerseType( struct zcgidata_t *cd );

/* Page size */
int getCurrentPageSize( struct zcgidata_t *cd );

/*  Search area */
_st_t getCurrentArea( struct zcgidata_t *cd );
const char *getCurrentAreaString( struct zcgidata_t *cd );

/* Search flags */
unsigned int getSearchFlags( struct zcgidata_t *cd );

/* Page start */
int getPageStart( struct zcgidata_t *cd );

/* Default reference */
#define mdrNoCharset          0x0001u
#define mdrNoIndexes          0x0002u

char *makeDefaultReference( struct zcgidata_t *cd, const char *action, int flags);

#ifdef __cplusplus
}
#endif

#endif
