/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __PAGE_A
#define __PAGE_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __CFG_H
#include "cfg.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

Boolean writeFluidsHead( struct zcgidata_t *cd );

/* Templates */
void writeTplQuery( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplEscapedQuery( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplConfFile( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplCharset( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplPageSize( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplTerseType( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplQueryType( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplProgramEnvironment( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplConfigColor( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplArea( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplWhatAction( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplUsedIndexes( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
zint_t getTplPageSize( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplSelfReference( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
zint_t getTplTerseNumber( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplTerseNumber( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplSearchFlags( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
zint_t getTplSearchFlag( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplSearchFlag( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
zint_t getTplMsie4( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
void writeTplMsie4( struct zcgidata_t *cd, const char *param, const char *modif, void *info);

/* Files */
char *expandPath( struct zcgidata_t *cd, char *buf, int size, const char *name);
Boolean writeTemplateFile( struct zcgidata_t *cd, const char *file);
Boolean writeFile( struct zcgidata_t *cd, const char *file);

#ifdef __cplusplus
}
#endif

#endif
