/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __MESSAGES_A
#define __MESSAGES_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#ifndef __ZERROR_A
#include "zerror.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

enum
{
  _ercUnknownCharset,
  _ercIndexIdUndefined,
  _ercIndexFileUndefined,
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
  _ercInvalidReplaceBlock,
#endif
  _ercDuplicateIndex,
  _ercNoIndexes,
  _ercNoSelectedIndexes,
  _ercEmptyQuery,
  _ercUnknownOption
};

#define ercUnknownCharset              (zefUser1 | _ercUnknownCharset)
#define ercIndexIdUndefined            (zefUser1 | _ercIndexIdUndefined)
#define ercIndexFileUndefined          (zefUser1 | _ercIndexFileUndefined)
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
#define ercInvalidReplaceBlock         (zefUser1 | _ercInvalidReplaceBlock)
#endif
#define ercDuplicateIndex              (zefUser1 | _ercDuplicateIndex)
#define ercNoIndexes                   (zefUser1 | _ercNoIndexes)
#define ercNoSelectedIndexes           (zefUser1 | _ercNoSelectedIndexes)
#define ercEmptyQuery                  (zefUser1 | _ercEmptyQuery)
#define ercUnknownOption               (zefUser1 | _ercUnknownOption)

void writeErr( struct zcontext_t *cnt, unsigned zint_t errorCode, const char *errstring);
void writeError( struct zcontext_t *cnt, unsigned zint_t errorCode, const char *name);

#ifdef __cplusplus
}
#endif

#endif
