/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"
#include "zcgi.h"

#include "cfg.h"
#include "error.h"

#include "messages.h"

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( RUSSIAN_INTERFACE )
#define ERR_UNKNOWN_CHARSET     " ⭠ ஢ '%.100s'  ப  %d 䨣樮 䠩 \"%.1000s\"."
#define ERR_INDEXID_UNDEFINED   " ।  id    ࠧ [index], 稭饣  ப  %d  䨣樮 䠩 \"%.1000s\"."
#define ERR_INDEXFILE_UNDEFINED " ।  file    ࠧ [index], 稭饣  ப  %d  䨣樮 䠩 \"%.1000s\"."
#define ERR_INVALID_REPLBLOCK   " ।  'default'  ࠧ [replace], 稭饣  ப  %d  䨣樮 䠩 \"%.1000s\"."
#define ERR_DUPLICATE_INDEX     "  䨪஬ '%.100s' யᠭ   䨣樮 䠩."
#define ERR_NO_INDEXES          "  䠩  ᪠!"
#define ERR_EMPTY_QUERY         "ப ᪠ . ,  !"
#define ERR_NO_SELINDEXES       " ⬥祭 ᮢ. , ⬥     ᮡࠥ ᪠."
#define ERR_UNKNOWN_OPTION      "⭠  \"%.100s\"  䨣樮 䠩 %.1000s, ப %d."
#else
#define ERR_UNKNOWN_CHARSET     "Unknown charset '%.100s' in line %d of the configuration file \"%.1000s\"."
#define ERR_INDEXID_UNDEFINED   "Undefined ID field in [index] section starting at line %d in the configuration file \"%.1000s\"."
#define ERR_INDEXFILE_UNDEFINED "Undefined FILE field in [index] section starting at line %d in the configuration file \"%.1000s\"."
#define ERR_INVALID_REPLBLOCK   "Undefined DEFAULT field in [replace] section starting at line %d in the configuration file \"%.1000s\"."
#define ERR_DUPLICATE_INDEX     "Duplicate index with '%.100s' ID in the configuration file."
#define ERR_NO_INDEXES          "No index files defined to search!"
#define ERR_EMPTY_QUERY         "Query string is empty. Please, enter keywords to find."
#define ERR_NO_SELINDEXES       "No selected indexes. Please, select indexes to search."
#define ERR_UNKNOWN_OPTION      "Unknown option \"%.100s\" in the configuration file %.1000s, line %d."
#endif

void writeError( struct zcontext_t *cnt, unsigned zint_t errorCode, const char *name)
{
  int errc = _zErrorCode( errorCode );
  char line[1000+1000+100];

  if( errc == zecNone ) return;

  if( zCheckFlags( errorCode, zefUser1) )
    switch( errc )
    {
      case _ercUnknownCharset:
        zsprintf( line, sizeof( line ), ERR_UNKNOWN_CHARSET, cnt->errorIntParam, cnt->errorStrParam, name);
	break;

      case _ercIndexIdUndefined:
        zsprintf( line, sizeof( line ), ERR_INDEXID_UNDEFINED, cnt->errorIntParam, name);
	break;

      case _ercIndexFileUndefined:
        zsprintf( line, sizeof( line ), ERR_INDEXFILE_UNDEFINED, cnt->errorIntParam, name);
        break;

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
      case _ercInvalidReplaceBlock:
        zsprintf( line, sizeof( line ), ERR_INVALID_REPLBLOCK, name);
        break;
#endif

      case _ercDuplicateIndex:
        zsprintf( line, sizeof( line ), ERR_DUPLICATE_INDEX, name);
        break;

      case _ercNoIndexes:
        zsprintf( line, sizeof( line ), ERR_NO_INDEXES);
        break;

      case _ercNoSelectedIndexes:
        zsprintf( line, sizeof( line ), ERR_NO_SELINDEXES);
        break;

      case _ercEmptyQuery:
        zsprintf( line, sizeof( line ), ERR_EMPTY_QUERY);
        break;

      case _ercUnknownOption:
        zsprintf( line, sizeof( line ), ERR_UNKNOWN_OPTION,
	  name, cnt->errorStrParam, cnt->errorIntParam);
        break;

      default:
        zsprintf( line, sizeof( line ), "Unknown error code %d", errc);
        break;
    }
  else
    (void) fluGetErrorString( cnt, line, sizeof( line ), errorCode, name);

  zcgiStartDocument( cnt->cgiData, "Error");

  zcgiWritef( cnt->cgiData, "\n<p><b>%t #%d</b>: %t<p>\n",
    zCheckFlags( errorCode, zefGeneral) ? "General error" : "Error",
    errc, line);
}
