/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#include "zcontext.h"
#include "zchars.h"
#include "zcharset.h"
#include "zcoll.h"
#include "zerror.h"
#include "zfile.h"
#include "zstdio.h"
#include "zstdlib.h"
#include "zcgi.h"
#include "zurl.h"

#include "cfg.h"
#include "error.h"
#include "fludata.h"

#include "configur.h"
#include "form.h"
#include "messages.h"
#include "page.h"
#include "search.h"
#include "queryprm.h"

/* #define TEST */

#ifdef HAVE_SIGNAL
static RETSIGTYPE signalHandler( int signo )
{
  signal( signo, SIG_IGN);
  zfprintf( NULL, stdout, "\n<p><pre>\nInternal ERROR: Exiting on signal %d\n</pre>\n", signo);
  fflush( stdout );
  exit( -1 );
}
#endif

#ifdef TEST
static void setEnvironment( struct zcgidata_t *cd )
{
  cd->env[ZCGI_ENV_REQUEST_METHOD] = "GET";
  cd->env[ZCGI_ENV_QUERY_STRING] = "q=a&trs=dtl&cfg=user&w=sch";
/*  cd->env[ZCGI_ENV_QUERY_STRING] = "ind=t2&qf=iform&cs=alt"; */
/*  cd->env[ZCGI_ENV_SCRIPT_FILENAME] = __FILE__; */
  cd->env[ZCGI_ENV_HTTP_USER_AGENT] = "Mozilla/4.05 (compatible; MSIE 4.01; Windows; I)";
  cd->env[ZCGI_ENV_REMOTE_HOST] = "www.sbnet.ru";
  cd->env[ZCGI_ENV_REMOTE_ADDR] = "195.151.80.70";
}
#endif

static void memoryFail( struct zcontext_t *cnt, const char *prog)
{
  cnt->printError( cnt, zerNoMemory, prog);
  exit( -1 );
}

static void exitProgram( struct zcontext_t *cnt, int exitCode)
{
  zcgiEndDocument( cnt->cgiData );
  zcgiFreeData( cnt->cgiData );
  freeSearchData( SEARCH_DATA( cnt->cgiData ) );

  zContextFree( cnt );
  exit( exitCode );
}

static void writeHeadAddition( struct zcgidata_t *cd )
{
  struct searchdata_t *sd = SEARCH_DATA( cd );

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  if( zCheckFlags( sd->UserOptions, USEROPTION_META_CHARSET_TAG) )
  {
    const char *charset = zcgiRemoteStrictCharsetName( cd );
    if( charset != NULL )
      zcgiWritef( cd, "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=%~s\">\n", charset);
  }
#endif

  if( sd->HeadAdditionFile != NULL ) (void) writeFile( cd, sd->HeadAdditionFile);
}

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_CONVERT )
static void checkUserAgent( struct zcgidata_t *cd )
{
  struct zstrcoll_t *ua = &SEARCH_DATA( cd )->userAgents;
  const char *userAgent;
  int i;

  if( !zCheckFlags( cd->flags, ZCGI_FLAG_RUSSIAN_APACHE) &&
      zCheckFlags( cd->flags, ZCGI_FLAG_DEFAULT_CHARSET) &&
      (userAgent = cd->env[ZCGI_ENV_HTTP_USER_AGENT]) != NULL )
    for( i = 0; i < ua->count; i++)
      if( zStringMatch( userAgent, &ua->list[i][1], smfCaseIndep) )
      {
	(void) zSetRemoteCharset( cd->context, ZCHARSET_UNKNOWN, ua->list[i][0]);
        zUnsetFlags( cd->flags, ZCGI_FLAG_DEFAULT_CHARSET);
        break;
      }
}
#endif

void main( int argc, char **argv)
{
  struct zcontext_t cgiContext;
  struct zcgidata_t cgiData;
  struct fludata_t fluData;
  struct searchdata_t searchData;
  const struct task_t *task;

#ifdef HAVE_SIGNAL
  signal( SIGSEGV, signalHandler);
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  zInitRussians();
#endif

/* 樠㥬 ࠧ த  */
  zContextInit( &cgiContext, writeError, NULL, memoryFail, 0);
  zcgiInitData( &cgiContext, &cgiData);
#ifdef FULL_FILE_NAMES
  zSetFlags( cgiContext.runFlags, ZCONTEXT_RUNFLAG_FULL_FILE_NAMES);
#endif
  initFludata( &cgiContext, &fluData);
  initSearchData( &cgiContext, &searchData);
  cgiData.userData = &searchData;

/* 砥 CGI  & 㥬 ஢  */
#ifdef TEST
  setEnvironment( &cgiData );
#endif
  if( !zcgiGetInput( &cgiData ) )
  {
    zcgiWriteError( &cgiData );
    exit( -1 );
  }
  zcgiGetUserAgent( &cgiData );
  if( cgiData.env[ZCGI_ENV_SCRIPT_NAME] == NULL )
    cgiData.env[ZCGI_ENV_SCRIPT_NAME] = zFileName( argv[0] );
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
  if( cgiData.env[ZCGI_ENV_SCRIPT_FILENAME] == NULL )
    cgiData.env[ZCGI_ENV_SCRIPT_FILENAME] = argv[0];
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  zcgiCharsetSetup( &cgiData,
#if defined( FLUIDS_CYR_CONVERT )
                              True);
#else
                              False);
#endif
#endif

/* ।塞 , 뢠 䨣樮 䠩 
   ࠢ塞 ஢, ᫨ 㦭 */
  task = getTask( &cgiData );
  if( !configure( &cgiContext, getCurrentConfFile( &cgiData ), task->area) )
    exitProgram( &cgiContext, 1);
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_CONVERT )
  checkUserAgent( &cgiData );
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  if( zCheckFlags( cgiContext.ioFlags, ZCONTEXT_IOFLAG_CHARSET_CONV) )
    zRecode8( getUserQuery( &cgiData ), cgiContext.convTable);
#endif
  cgiData.bodyTagAddition = searchData.BodyTagAddition;
  cgiData.headAddition = writeHeadAddition;
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( UKRAINIAN_SUPPORT ) && defined( UKRAINIAN_INTERFACE )
  cgiContext.errorFormats = zErrorUkrainianFormats;
#elif defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( RUSSIAN_INTERFACE )
  cgiContext.errorFormats = zErrorRussianFormats;
#endif

/* ᫨ 㦭, ⨬ ࠭஢  ᪨ 㪢  URL' */
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  if( !zCheckFlags( searchData.UserOptions, USEROPTION_ESCAPED_URLS) )
    zcgiUnsetStrictRecoding( &cgiData );
#endif

  switch( task->task )
  {
    case taskSearch:
      search( &cgiData );
      break;

    case taskQueryForm:
      form( &cgiData );
      break;
  }

  exitProgram( &cgiContext, 0);
}
