/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h"

#include "zcontext.h"
#include "zcharset.h"
#include "zfile.h"
#include "zcgi.h"
#include "zurl.h"

#include "cfg.h"
#include "query.h"

#include "configur.h"
#include "messages.h"
#include "page.h"
#include "queryprm.h"
#include "form.h"

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( RUSSIAN_INTERFACE )
#define STRING_QUERY_FORM             " "
#define STRING_IN_SHORT_FORM          "⪮ ଥ"
#define STRING_IN_STANDARD_FORM       "⠭⭮ ଥ"
#define STRING_IN_DETAILED_FORM       "⠫쭮 ଥ"
#define STRING_ANY_AREA               "᪠ "
#define STRING_CONTENT_AREA           "⥪ 㬥⮢"
#define STRING_TITLE_AREA             " 㬥⮢"
#define STRING_CONTENT_AND_TITLE_AREA "⥪  "
#define STRING_FILENAME_AREA          " 䠩"
#define STRING_KEYWORDS_AREA          "祢 ᫮"
#define STRING_CHOOSE_INDEXES         "⬥ ,    ᮡࠥ ᪠"
#define STRING_CASE_DEPEND            "뢠 ॣ 㪢"
#define STRING_SEARCH_AREA            " ᪠"
#define STRING_YOUR_QUERY             " "
#define STRING_TO_SEARCH              ""
#define STRING_GO                     "᪠"
#define STRING_RESET                  " "
#define STRING_RESULTS_ON_PAGE        "⮢  ࠭:"
#define STRING_DISPLAY_RESULTS        "।⠢ १ "
#elif defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_UKRAINIAN_INTERFACE )
#define STRING_QUERY_FORM             "Query form"
#define STRING_IN_SHORT_FORM          "compact form"
#define STRING_IN_STANDARD_FORM       "standard form"
#define STRING_IN_DETAILED_FORM       "detailed form"
#define STRING_ANY_AREA               "any"
#define STRING_CONTENT_AREA           "content"
#define STRING_TITLE_AREA             "title"
#define STRING_CONTENT_AND_TITLE_AREA "content and title"
#define STRING_FILENAME_AREA          "file name"
#define STRING_KEYWORDS_AREA          "keywords"
#define STRING_CHOOSE_INDEXES         "Please, choose indexes to search"
#define STRING_CASE_DEPEND            "㪠 客 ॣ"
#define STRING_SEARCH_AREA            "Search area"
#define STRING_YOUR_QUERY             " "
#define STRING_TO_SEARCH              ""
#define STRING_GO                     ""
#define STRING_RESET                  "Reset"
#define STRING_RESULTS_ON_PAGE        "ࠦ  :"
#define STRING_DISPLAY_RESULTS        "Display the results in"
#else
#define STRING_QUERY_FORM             "Query form"
#define STRING_IN_SHORT_FORM          "compact form"
#define STRING_IN_STANDARD_FORM       "standard form"
#define STRING_IN_DETAILED_FORM       "detailed form"
#define STRING_ANY_AREA               "any"
#define STRING_CONTENT_AREA           "content"
#define STRING_TITLE_AREA             "title"
#define STRING_CONTENT_AND_TITLE_AREA "content and title"
#define STRING_FILENAME_AREA          "file name"
#define STRING_KEYWORDS_AREA          "keywords"
#define STRING_CHOOSE_INDEXES         "Please, choose indexes to search"
#define STRING_CASE_DEPEND            "Case sensitive search"
#define STRING_SEARCH_AREA            "Search area"
#define STRING_YOUR_QUERY             "Your query"
#define STRING_TO_SEARCH              "Search"
#define STRING_GO                     "Go"
#define STRING_RESET                  "Reset"
#define STRING_RESULTS_ON_PAGE        "Results per page:"
#define STRING_DISPLAY_RESULTS        "Display the results in"
#endif

/***************************************************************************/
/*                                                                         */
/*  Form selections                                                        */
/*                                                                         */
/***************************************************************************/

const struct tersetype_t terseTable[] =
{
  {
    TERSE_SHORT,
    trsShort,
    STRING_IN_SHORT_FORM,
    CONF_STRING_SHORT_MODEL
  },
  {
    TERSE_STANDARD,
    trsStandard,
    STRING_IN_STANDARD_FORM,
    CONF_STRING_STANDART_MODEL
  },
  {
    TERSE_DETAILED,
    trsDetailed,
    STRING_IN_DETAILED_FORM,
    CONF_STRING_DETAILED_MODEL
  },
  {
    NULL
  }
};

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

static void writeFormModelSelection( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  int terseType = getCurrentTerseType( cd );
  int i;

  zcgiWritef( cd, "%~s", "<select name=\"" PARAM_TERSETYPE "\">\n");

  for( i = 0; i < trsLastType; i++)
    zcgiWritef( cd, "%{"
        "<option value=\"%~s\"%~s>%t</option>\n",
      terseTable[i].name,
      (terseTable[i].type == terseType) ? " selected" : "",
      SEARCH_STRING( sd, terseTable[i].confText, terseTable[i].text));

  zcgiWritef( cd, "%~s", "</select>");
}

static void writeFormPsizeSelection( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  int pageSize = getCurrentPageSize( cd );
  int i;

  zcgiWritef( cd, "%~s", "<select name=\"" PARAM_PAGESIZE "\">\n");

  for( i = 10; i <= 50; i += 10)
    zcgiWritef( cd, "%{"
        "<option value=\"%d\"%~s>%d</option>\n",
      i, (i == pageSize) ? " selected" : "", i);

  zcgiWritef( cd, "%~s", "</select>");
}

static void writeFormAreaSelection( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  unsigned int area = getCurrentArea( cd );

  zcgiWritef( cd, "%{"
      "<select name=\"" PARAM_AREA "\">\n"
      "<option value=\"-\"%~s>%t</option>\n"
      "<option value=\"" AREA_STRING_CONTENT "\"%~s>%t</option>\n"
      "<option value=\"" AREA_STRING_TITLE "\"%~s>%t</option>\n"
      "<option value=\"" AREA_STRING_CONTENT AREA_STRING_TITLE "\"%~s>%t</option>\n"
      "<option value=\"" AREA_STRING_FILENAME "\"%~s>%t</option>\n"
   /* "<option value=\"" AREA_STRING_KEYWORDS ""%~s>%t</option>\n" */
      "</select>",
    zCheckFlags( area, AREA_FLAG_ANY) ? "" : " selected",
    SEARCH_STRING( sd, CONF_STRING_ANY_AREA, STRING_ANY_AREA),
    (zCheckFlags( area, AREA_FLAG_TITLE | AREA_FLAG_CONTENT) == AREA_FLAG_CONTENT) ? " selected" : "",
    SEARCH_STRING( sd, CONF_STRING_CONTENT_AREA, STRING_CONTENT_AREA),
    (zCheckFlags( area, AREA_FLAG_TITLE | AREA_FLAG_CONTENT) == AREA_FLAG_TITLE) ? " selected" : "",
    SEARCH_STRING( sd, CONF_STRING_TITLE_AREA, STRING_TITLE_AREA),
    (zCheckFlags( area, AREA_FLAG_TITLE | AREA_FLAG_CONTENT) == (AREA_FLAG_TITLE | AREA_FLAG_CONTENT)) ? " selected" : "",
    SEARCH_STRING( sd, CONF_STRING_TITLE_CONTENT_AREA, STRING_CONTENT_AND_TITLE_AREA),
    (zCheckFlags( area, AREA_FLAG_FILENAME | AREA_FLAG_TITLE | AREA_FLAG_CONTENT) == AREA_FLAG_FILENAME) ? " selected" : "",
    SEARCH_STRING( sd, CONF_STRING_DOCNAME_AREA, STRING_FILENAME_AREA)
    /*,
    (zCheckFlags( area, AREA_FLAG_KEYWORD | AREA_FLAG_FILENAME | AREA_FLAG_TITLE | AREA_FLAG_CONTENT) == AREA_FLAG_KEYWORD) ? " selected" : "",
    STRING_KEYWORDS_AREA
    */ );
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif

/***************************************************************************/
/*                                                                         */
/*  Param template values                                                  */
/*                                                                         */
/***************************************************************************/

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

static zint_t getFormItemAttribute( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  Boolean choosed = False;

  if( *param == '\0' || *modif == '\0' ) return 0;

  if( strcasecmp( param, "model") == 0 || strcasecmp( param, "modeltype") == 0 ||
      strcasecmp( param, "terse") == 0 || strcasecmp( param, "tersetype") == 0 )
  {
    switch( getCurrentTerseType( cd ) )
    {
      case trsDetailed:
        if( strcasecmp( modif, TERSE_DETAILED) == 0 || strcasecmp( modif, "detailed") == 0 )
	  choosed = True;
        break;
      case trsStandard:
        if( strcasecmp( modif, TERSE_STANDARD) == 0 || strcasecmp( modif, "standard") == 0 )
          choosed = True;
        break;
      case trsShort:
        if( strcasecmp( modif, TERSE_SHORT) == 0 || strcasecmp( modif, "short") == 0 )
          choosed = True;
        break;
    }
  }
  else if( strcasecmp( param, "page") == 0 || strcasecmp( param, "size") == 0 ||
           strcasecmp( param, "psize") == 0 || strcasecmp( param, "pagesize") == 0 )
  {
    choosed = (Boolean) ((int) strtol( modif, NULL, 10) == getCurrentPageSize( cd ));
  }
  else if( strcasecmp( param, "index") == 0 )
  {
    struct confindex_t *ci = findConfIndex( SEARCH_DATA( cd ), modif);
    if( ci != NULL && ci->selected ) choosed = True;
  }
  else if( strcasecmp( param, PARAM_AREA) == 0 || strcasecmp( param, "area") == 0 )
  {
    unsigned int area = getCurrentArea( cd );
    if( strcasecmp( modif, "none") == 0 )
      choosed = (Boolean) (area == 0);
    else if( strcasecmp( modif, AREA_STRING_CONTENT) == 0 || strcasecmp( modif, "file") == 0 ||
	strcasecmp( modif, "content") == 0 || strcasecmp( modif, "text") == 0 )
      choosed = (Boolean) (zCheckFlags( area, AREA_FLAG_CONTENT | AREA_FLAG_TITLE) == AREA_FLAG_CONTENT);
    else if( strcasecmp( modif, AREA_STRING_TITLE) == 0 || strcasecmp( modif, "title") == 0 )
      choosed = (Boolean) (zCheckFlags( area, AREA_FLAG_CONTENT | AREA_FLAG_TITLE) == AREA_FLAG_TITLE);
    else if( strcasecmp( modif, AREA_STRING_TITLE AREA_STRING_CONTENT) == 0 ||
             strcasecmp( modif, "content,title") == 0 )
      choosed = (Boolean) (zCheckFlags( area, AREA_FLAG_CONTENT | AREA_FLAG_TITLE) == (AREA_FLAG_CONTENT | AREA_FLAG_TITLE));
    else if( strcasecmp( modif, AREA_STRING_FILENAME) == 0 || strcasecmp( modif, "filename") == 0 )
      choosed = (Boolean) zCheckFlags( area, AREA_FLAG_FILENAME);
    else if( strcasecmp( modif, AREA_STRING_KEYWORD) == 0 || strcasecmp( modif, "keywords") == 0 ||
	     strcasecmp( modif, "keyword") == 0 )
      choosed = (Boolean) zCheckFlags( area, AREA_FLAG_KEYWORD);
  }
  else if( strcasecmp( param, PARAM_SEARCH_FLAGS) == 0 || strcasecmp( param, "sflag") == 0 )
  {
    unsigned int searchFlags = getSearchFlags( cd );
    if( strcasecmp( modif, "CaseDepend") == 0 )
      choosed = (Boolean) zCheckFlags( searchFlags, msfCaseDepend);
  }

  return choosed ? 1 : 0;
}

static void writeFormChecked( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  if( getFormItemAttribute( cd, param, modif, NULL) )
    zcgiWritef( cd, "%~s", "checked");
}

static void writeFormSelected( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  if( getFormItemAttribute( cd, param, modif, NULL) )
    zcgiWritef( cd, "%~s", "selected");
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif

/***************************************************************************/
/*                                                                         */
/*  Form template values                                                   */
/*                                                                         */
/***************************************************************************/

struct formvalues_t
{
  const char *query;
  int used;
  Boolean primary;
  int queryType;
  Boolean msie4;
};

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

static void writeFormHeader( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  int headerLevel = ((struct formvalues_t *) info)->primary ? 2 : 3;

  if( sd->QueryFormHeaderColor != ZCGI_COLOR_NONE )
    zcgiWritef( cd, "%{"
        "<h%d align=\"center\"><b><font color=\"" ZCGI_COLOR_PRINT_FORMAT "\">%t</font></b></h%d>\n"
        "<p>\n",
      headerLevel,
      sd->QueryFormHeaderColor,
      SEARCH_STRING( sd, CONF_STRING_QUERY_FORM, STRING_QUERY_FORM),
      headerLevel);
  else
    zcgiWritef( cd, "%{"
        "<h%d align=\"center\"><b>%t</b></h%d>\n"
        "<p>\n",
      headerLevel,
      SEARCH_STRING( sd, CONF_STRING_QUERY_FORM, STRING_QUERY_FORM),
      headerLevel);
}

static void writeFormIndexList( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  struct formvalues_t *formValues = (struct formvalues_t *) info;
  int i;

  if( formValues->queryType == qtpExternalForm && formValues->used > 1 )
    zcgiWriteCheckboxHeader( cd,
      SEARCH_STRING( sd, CONF_STRING_CHOOSE_INDEXES, STRING_CHOOSE_INDEXES),
      sd->IndexListHeaderColor, formValues->msie4);

  for( i = 0; i < sd->indexes.count; i++)
  {
    struct confindex_t *ind = (struct confindex_t *) zDataCollectionElem( &sd->indexes, i);
    if( !ind->used ) continue;

    switch( formValues->queryType )
    {
      case qtpExternalForm:
        if( formValues->used > 1 )
	{
          zcgiWritef( cd, "%{"
	      "%~s&nbsp;<input type=\"checkbox\" name=\"" PARAM_INDEXNAME "\" value=\"%v\"%~s>&nbsp;%t%~s",
            formValues->msie4 ? "&nbsp;&nbsp;" : "<dd>",
            ind->id, ind->selected ? " checked" : "",
            (ind->text == NULL) ? ind->id : ind->text,
            formValues->msie4? "<br>\n" : "</dd>\n");
	  break;
	}
	/* Falling through ... */

      default:
        zcgiWritef( cd, "%{"
            "<input type=\"hidden\" name=\"" PARAM_INDEXNAME "\" value=\"%v\">\n",
          ind->id);
	break;
    }
  }

  if( formValues->queryType == qtpExternalForm && formValues->used > 1 )
    zcgiWriteCheckboxEnd( cd, formValues->msie4);
}

static void writeFormQueryHelp( struct zcgidata_t *cd,
    const char *param, const char *modif, void *info)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );

  if( sd->QueryHelpFile != NULL ) writeFile( cd, sd->QueryHelpFile);
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif

static struct zcgi_tplvalue_t formTable[] =
{
  { "MODEL_SELECTION", 15,  False,  writeFormModelSelection, NULL, NULL },
  { "PSIZE_SELECTION", 15,  False,  writeFormPsizeSelection, NULL, NULL },
  { "AREA_SELECTION",  14,  False,  writeFormAreaSelection,  NULL, NULL },
  { "ESCAPED_QUERY",   13,  False,  writeTplEscapedQuery,    NULL, NULL },
  { "QUERY_ESCAPED",   13,  False,  writeTplEscapedQuery,    NULL, NULL },
  { "MODEL_NUMBER",    12,  False,  writeTplTerseNumber,     getTplTerseNumber, NULL },
  { "SEARCH_FLAGS",    12,  False,  writeTplSearchFlags,     NULL, NULL },
  { "TERSE_NUMBER",    12,  False,  writeTplTerseNumber,     getTplTerseNumber, NULL },
  { "USED_INDEXES",    12,  False,  writeTplUsedIndexes,     NULL, NULL },
  { "FORM_HEADER",     11,  False,  writeFormHeader,         NULL, NULL },
  { "WHAT_ACTION",     11,  False,  writeTplWhatAction,      NULL, NULL },
  { "INDEX_LIST",      10,  False,  writeFormIndexList,      NULL, NULL },
  { "MODEL_TYPE",      10,  False,  writeTplTerseType,       NULL, NULL },
  { "QUERY_HELP",      10,  False,  writeFormQueryHelp,      NULL, NULL },
  { "QUERY_TYPE",      10,  False,  writeTplQueryType,       NULL, NULL },
  { "TERSE_TYPE",      10,  False,  writeTplTerseType,       NULL, NULL },
  { "CONF_FILE",        9,  False,  writeTplConfFile,        NULL, NULL },
  { "PAGE_SIZE",        9,  False,  writeTplPageSize,        getTplPageSize, NULL },
  { "SELF_REF",         8,  False,  writeTplSelfReference,   NULL, NULL },
  { "CHARSET",          7,  False,  writeTplCharset,         NULL, NULL },
  { "MSIE4",            5,  False,  writeTplMsie4,           getTplMsie4, NULL },
  { "QUERY",            5,  False,  writeTplQuery,           NULL, NULL },
  { "AREA",             4,  False,  writeTplArea,            NULL, NULL },
  { "selected",         8,   True,  writeFormSelected,       getFormItemAttribute, NULL },
  { "checked",          7,   True,  writeFormChecked,        getFormItemAttribute, NULL },
  { "color",            5,   True,  writeTplConfigColor,     NULL, NULL },
  { "sflag",            5,   True,  writeTplSearchFlag,      getTplSearchFlag, NULL },
  { "env",              3,   True,  writeTplProgramEnvironment, NULL, NULL },
  { NULL }
};

/***************************************************************************/
/*                                                                         */
/*  Query form                                                             */
/*                                                                         */
/***************************************************************************/

static void writeQueryForm( struct zcgidata_t *cd, struct formvalues_t *formValues)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  const char *s;

  zcgiWritef( cd, "%{"
      "<form method=\"get\" action=\"%v\">\n"
      "<center>\n"
      "<table border=1 bgcolor=\"" ZCGI_COLOR_PRINT_FORMAT "\" width=\"99%%\">\n"
      "<tr><td>\n"
      "<table width=\"100%%\" border=0>\n"
      "<tr align=\"left\" valign=\"top\">\n"
      "<td align=\"center\">\n"
      "%t:&nbsp;&nbsp;<input type=\"text\" name=\"" PARAM_QUERYSTRING "\" maxlength=\"255\" size=\"30\" value=\"%\"t\"><br>\n"
      "<input type=\"submit\" value=\"%\"t\"> <input type=\"reset\" value=\"%\"t\"><br>\n"
      "<input type=\"checkbox\" name=\"" PARAM_SEARCH_FLAGS "\" value=\"" SFLAG_CASE_DEPEND "\"%~s> %t",
    cd->env[ZCGI_ENV_SCRIPT_NAME],
    (sd->QueryFormBackgroundColor == ZCGI_COLOR_NONE) ? __ZINT(0xEEEEEE) : sd->QueryFormBackgroundColor,
    SEARCH_STRING( sd, CONF_STRING_SEARCH_QUERY,
      formValues->primary ? STRING_YOUR_QUERY : STRING_TO_SEARCH),
    getUserQuery( cd ),
    SEARCH_STRING( sd, CONF_STRING_SUBMIT_FORM, STRING_GO),
    SEARCH_STRING( sd, CONF_STRING_RESET_FORM, STRING_RESET),
    zCheckFlags( sd->searchFlags, msfCaseDepend) ? " checked" : "",
    SEARCH_STRING( sd, CONF_STRING_CASE_DEPEND, STRING_CASE_DEPEND));

  zcgiWritef( cd, "%{\n</td>\n<td>%t&nbsp;",
    SEARCH_STRING( sd, CONF_STRING_RESULTS_ON_PAGE, STRING_RESULTS_ON_PAGE));
  writeFormPsizeSelection( cd, NULL, NULL, formValues);

  zcgiWritef( cd, "%{<br>\n%t&nbsp;",
    SEARCH_STRING( sd, CONF_STRING_SEARCH_MODEL, STRING_DISPLAY_RESULTS));
  writeFormModelSelection( cd, NULL, NULL, formValues);

  zcgiWritef( cd, "%{<br>\n%t&nbsp;",
    SEARCH_STRING( sd, CONF_STRING_SEARCH_AREA, STRING_SEARCH_AREA));
  writeFormAreaSelection( cd, NULL, NULL, formValues);

  zcgiWritef( cd, "%~s", "\n</td></tr>\n");

  if( formValues->queryType == qtpExternalForm && formValues->used > 1 )
  {
    zcgiWritef( cd, "%~s%~s",
      formValues->msie4 ? "<tr></tr>\n" : "",
      "<tr align=\"left\" valign=\"top\"><td colspan=\"2\">\n");
    writeFormIndexList( cd, NULL, NULL, formValues);
    zcgiWritef( cd, "%~s", "</td></tr>\n");
  }

  zcgiWritef( cd, "%~s", "</table>\n</td></tr></table>\n</center>\n");

  if( !(formValues->queryType == qtpExternalForm && formValues->used > 1) )
    writeFormIndexList( cd, NULL, NULL, formValues);

  zcgiWritef( cd, "%~s", "<input type=\"hidden\" name=\"" WHAT_ACTION "\" value=\"" ACTION_SEARCH "\">\n");

  if( (s = getCurrentConfFile( cd )) != NULL )
    zcgiWritef( cd, "%{"
        "<input type=\"hidden\" name=\"" PARAM_CONFFILE "\" value=\"%v\">\n",
      s);

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_CONVERT )
  if( !zCheckFlags( cd->flags, ZCGI_FLAG_RUSSIAN_APACHE) &&
      (s = zcgiRemoteStrictCharsetName( cd )) != NULL )
    zcgiWritef( cd, "%{"
        "<input type=\"hidden\" name=\"" ZCGI_PARAM_CHARSET "\" value=\"%v\">\n",
      s);
#endif

  if( zCheckFlags( sd->paramFlags, PARAMFLAG_HAS_QUERY_TYPE) )
    zcgiWritef( cd, "%{"
        "<input type=\"hidden\" name=\"" PARAM_QUERYTYPE "\" value=\"%v\">\n",
      getQueryName( getCurrentQueryType( cd ) ));

  zcgiWritef( cd, "%~s", "</form>\n");
}

Boolean writeFormPage( struct zcgidata_t *cd, const char *query, Boolean primary)
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  struct zcontext_t *cnt = cd->context;
  struct formvalues_t formValues;
  char buf[MAX_FILENAME_LENGTH], formtpl[MAX_TEMPLATE_STRING_SIZE];
  const char *formTemplateString, *fileName;
  int used;

  if( (used = selectIndexes( cd, True)) <= 0 )
  {
    cnt->printError( cnt, ercNoIndexes, NULL);
    return False;
  }

  if( sd->QueryFormFile != NULL ) fileName = expandPath( cd, buf, sizeof( buf ), sd->QueryFormFile);
  formTemplateString = (sd->QueryFormFile == NULL) ? NULL : zReadFileString(
    cd->context, fileName, zCheckFlags( cd->context->runFlags, ZCONTEXT_RUNFLAG_FULL_FILE_NAMES) ?
    fileName : sd->QueryFormFile, formtpl, sizeof( formtpl ));

  formValues.query = query;
  formValues.primary = primary;
  formValues.used = used;
  formValues.queryType = getCurrentQueryType( cd );
  formValues.msie4 = (Boolean) (cd->userAgentType == agtExplorer && cd->userAgentVersion >= 400);

  if( formTemplateString != NULL )
    zcgiWriteTemplateString( cd, formTable, formTemplateString, &formValues);
  else
  {
    writeFormHeader( cd, NULL, NULL, &formValues);
    writeQueryForm( cd, &formValues);
    writeFormQueryHelp( cd, NULL, NULL, &formValues);
  }

  return True;
}

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && \
    defined( FLUIDS_CYR_CONVERT ) && defined( FLUIDS_CHARSET_LIST )
static Boolean writeCharsetList( struct zcgidata_t *cd )
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  int maxCharset = zCharsetCount();
  char line[ sizeof( sd->ref ) ], *ref;
  int i;

  if( zCheckFlags( cd->flags, ZCGI_FLAG_RUSSIAN_APACHE) ||
      !zCheckFlags( sd->UserOptions, USEROPTION_CHARSET_LIST) ||
      maxCharset <= 1 )
    return False;

  ref = makeDefaultReference( cd, NULL, mdrNoCharset);

  zcgiWritef( cd, "%~s", "<p align=\"center\"><center><hr noshade width=\"90%\">\n");

  if( sd->CharsetIcon != NULL )
    zcgiWritef( cd, "%{"
        "<table border=0><tr align=\"center\" valign=\"middle\">\n"
        "<td><img src=\"%s\" alt=\"%\"t\">\n",
      sd->CharsetIcon, (sd->CharsetAlt == NULL) ? "" : sd->CharsetAlt);

  for( i = 0; i < maxCharset; i++)
  {
    strncpy( line, ref, sizeof( line ));
    line[ sizeof( line ) - 1 ] = '\0';
    (void) zurlAddReference( line, sizeof( line ), ZCGI_PARAM_CHARSET,
      zCharsetName( i, ZCHARSET_NAME_SHORT), zRecodeStrictTable( cd->context ), cd->urlFlags);

    if( sd->CharsetIcon != NULL )
      zcgiWritef( cd, "%~s", "<td align=\"center\" valign=\"middle\">");
    else if( sd->CharsetBullet != NULL && i > 0 )
      zcgiWritef( cd, "%{<img src=\"%s\" alt=\"*\"> ", sd->CharsetBullet);
    zcgiWritef( cd, "%{<b><a href=\"%~s\">%s</a></b>\n", line, zCharsetName( i, ZCHARSET_NAME_SHORTUP));
  }

  if( sd->CharsetIcon != NULL ) zcgiWritef( cd, "%~s", "</tr></table>\n");
  zcgiWritef( cd, "%~s", "<hr noshade width=\"90%\"></center></p>\n<p>\n");

  return True;
}
#endif

Boolean form( struct zcgidata_t *cd )
{
  struct searchdata_t *sd = SEARCH_DATA( cd );
  Boolean success;

  cd->pageBackgroundImage = sd->FormBackground;
  zcgiStartDocument( cd, "Query Form");
  if( sd->TopContentFile != NULL ) writeTemplateFile( cd, sd->TopContentFile);

  success = writeFluidsHead( cd );
  if(
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && \
    defined( FLUIDS_CYR_CONVERT ) && defined( FLUIDS_CHARSET_LIST )
      !writeCharsetList( cd ) &&
#endif
                             success )
    zcgiWritef( cd, "%~s", "<hr noshade size=4><p>\n");
  if( sd->FormHeaderFile != NULL ) writeTemplateFile( cd, sd->FormHeaderFile);

  success = writeFormPage( cd,  NULL, True);

  if( sd->FormFooterFile != NULL ) writeTemplateFile( cd, sd->FormFooterFile );
  if( sd->BottomContentFile != NULL ) writeTemplateFile( cd, sd->BottomContentFile );

  return success;
}
