/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __CONFIGUR_A
#define __CONFIGUR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
#ifndef __ZCHARSET_A
#include "zcharset.h"
#endif
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifndef __STRUCTUR_A
#include "structur.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct resultitem_t;
struct task_t;

struct confindex_t
{
  const char *id;
  const char *fileName;
  const char *text;
  int face;
  Boolean hidden;
  Boolean used;
  Boolean selected;
  struct zstrcoll_t allowList;
  struct zreplace_t replaces;
};

enum
{
  CONF_STRING_QUERY_FORM = 0,
  CONF_STRING_SEARCH_QUERY,
  CONF_STRING_SEARCH_MODEL,
  CONF_STRING_SHORT_MODEL,
  CONF_STRING_STANDART_MODEL,
  CONF_STRING_DETAILED_MODEL,
  CONF_STRING_SEARCH_AREA,
  CONF_STRING_ANY_AREA,
  CONF_STRING_CONTENT_AREA,
  CONF_STRING_TITLE_AREA,
  CONF_STRING_TITLE_CONTENT_AREA,
  CONF_STRING_DOCNAME_AREA,
  CONF_STRING_RESULTS_ON_PAGE,
  CONF_STRING_CASE_DEPEND,
  CONF_STRING_CHOOSE_INDEXES,
  CONF_STRING_SUBMIT_FORM,
  CONF_STRING_RESET_FORM,
  CONF_STRING_SEARCH_RESULTS,
  CONF_STRING_SEARCH_TIME,
  CONF_STRING_OTHER_RESULT_PAGES,
  CONF_STRING_NEXT_RESULT_BLOCK,
  CONF_STRING_PREV_RESULT_BLOCK,
  CONF_STRING_RESULT_SIZE,
  CONF_STRING_RESULT_BYTES,
  CONF_STRING_RESULT_URL,
  CONF_STRING_RESULT_RANK,
  CONF_STRING_RESULT_LAST_MODIFIED,
  CONF_STRING_MAX
};

struct searchdata_t
{
  struct zcontext_t *context;

/* Config: main */
  char *RootDir;
  char *FormBackground;
  char *SearchBackground;
  char *ErrorGuideFile;
  char *AdminEmail;
  unsigned zint_t UserOptions;
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CHARSET_LIST )
  char *CharsetIcon;
  char *CharsetBullet;
  char *CharsetAlt;
#endif
  char *FluidsLogo;
  char *FluidsHref;
  char *HeadAdditionFile;
  char *BodyTagAddition;
  char *QueryHelpFile;

/* Config: colors */
  zint_t FluidsHeaderColor;
  zint_t FluidsHeaderBrightColor;
  zint_t UserQueryHeaderColor;
  zint_t UserQueryColor;
  zint_t OtherPagesHeaderColor;
  zint_t QueryFormHeaderColor;
  zint_t SearchResultsHeaderColor;
  zint_t QueryFormBackgroundColor;
  zint_t IndexListHeaderColor;
  zint_t KeywordColor;
  zint_t ErrorWordColor;
  zint_t QueryErrorBackgroundColor;
  zint_t QueryErrorPointerColor;
  zint_t QueryErrorStringColor;
  zint_t QueryErrorHeaderColor;

/* Config: templates */
  char *FormHeaderFile;
  char *FormFooterFile;
  char *SearchHeaderFile;
  char *SearchFooterFile;
  char *TopContentFile;
  char *BottomContentFile;
  char *BeginResultFile;
  char *MatchResultFile;
  char *EndResultFile;
  char *QueryFormFile;
  struct zdatacoll_t icons;

/* Config: index */
  struct zdatacoll_t indexes;
  struct confindex_t curIndex;
  struct zstrbuf_t strBuf;

/* Config: user-agent */
  struct zstrcoll_t userAgents;

/* Config: replace */
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) && defined( FLUIDS_CYR_REPLACE )
  struct zreplace_t cyrReplaces;
  char *currentReplace[ZCHARSET_CYR_LAST+1];
#endif

/* Config: strings */
  const char *strings[CONF_STRING_MAX];

/* Query params */
  const struct task_t *task;
  unsigned int paramFlags;
  char *userQuery;
  char *confFile;
  int queryType;
  int terseType;
  int pageSize;
  _st_t area;
  char areaString[MAX_STRUCTURE_STRING_SIZE];
  unsigned int searchFlags;
  int used;
  int selected;
  char ref[MAX_REF_SIZE];
};

#define USEROPTION_FLUIDS_LOGO                __ZINT(0x0001u)
#define USEROPTION_META_CHARSET_TAG           __ZINT(0x0002u)
#define USEROPTION_CHARSET_LIST               __ZINT(0x0004u)
#define USEROPTION_SEARCH_TIME                __ZINT(0x0008u)
#define USEROPTION_EXECUTED_QUERY             __ZINT(0x0010u)
#define USEROPTION_PROBLEM_WORDS              __ZINT(0x0020u)
#define USEROPTION_LOGO_SPECIAL_EFFECTS       __ZINT(0x0040u)
#define USEROPTION_ESCAPED_URLS               __ZINT(0x0080u)

#define PARAMFLAG_USER_QUERY                  0x0001u
#define PARAMFLAG_CONF_FILE                   0x0002u
#define PARAMFLAG_INDEXES                     0x0004u
#define PARAMFLAG_QUERY_TYPE                  0x0008u
#define PARAMFLAG_TERSE_TYPE                  0x0010u
#define PARAMFLAG_PAGE_SIZE                   0x0020u
#define PARAMFLAG_AREA                        0x0040u
#define PARAMFLAG_AREA_STRING                 0x0080u
#define PARAMFLAG_SEARCH_FLAGS                0x0100u
#define PARAMFLAG_HAS_SELECTED                0x1000u
#define PARAMFLAG_HAS_QUERY_TYPE              0x2000u

#define SEARCH_DATA(x) ((struct searchdata_t *) ((x)->userData))
#define SEARCH_STRING(sd,x,y) (((sd)->strings[(x)] == NULL) ? (y) : (sd)->strings[(x)])

/* Search data */
void initSearchData( struct zcontext_t *cnt, struct searchdata_t *sd);
void freeSearchData( struct searchdata_t *sd );

/* Conf index */
struct confindex_t *findConfIndex( struct searchdata_t *sd, const char *id);

/* Conf color */
zint_t getConfigColor( struct searchdata_t *sd, const char *name);

/* Configuration */
Boolean configure( struct zcontext_t *cnt, const char *fileName, unsigned int flags);

#ifdef __cplusplus
}
#endif

#endif
