/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDEXJOB_A
#define __INDEXJOB_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define CTYPE_UNKNOWN            0
#define CTYPE_HTML               1
#define CTYPE_TEXT               2
#define CTYPE_NONTEXT            3

#define CMETHOD_NONE             0
#define CMETHOD_BY_ACCESS_FILE   1
#define CMETHOD_BY_META_TAG      2
#define CMETHOD_BY_DIRECTIVE     3
#define CMETHOD_LAST             4

struct indexjob_t
{
  struct zcontext_t *context;
  struct indexjob_t *next;
  struct indexjob_t *defaults;
  struct zstrbuf_t *sb;
  struct zstrcoll_t objects;
  struct zparamcoll_t ctypes;
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  struct zparamcoll_t charsets;
  struct zparamcoll_t accessCharsets;
  const char *accessFile;
  int charsetMethods[CMETHOD_LAST];
  const char *torTable;
  char _torTable[128];
#endif
  struct zreplace_t replaces;
  struct zstrcoll_t ignoreFileNames;
  struct zstrcoll_t ignoreDirNames;
  struct zstrcoll_t ignoreFullPathFiles;
  struct zstrcoll_t ignoreDirWithFile;
  struct zstrcoll_t ignoreFileURLs;
  unsigned int flags;
};

#define INDEXJOB_FLAG_HAVE_CTYPES                0x0001u
#define INDEXJOB_FLAG_HAVE_CHARSETS              0x0002u
#define INDEXJOB_FLAG_HAVE_REPLACES              0x0004u
#define INDEXJOB_FLAG_HAVE_SELECTS               0x0008u
#define INDEXJOB_FLAG_HAVE_OBJECTS               0x0010u
#define INDEXJOB_FLAG_HAVE_ACCESS_FILE           0x0020u
#define INDEXJOB_FLAG_HAVE_CHARSET_METHODS       0x0040u
#define INDEXJOB_FLAG_HAVE_DEFAULT_HTML_CONTENT  0x0100u
#define INDEXJOB_FLAG_HAVE_DEFAULT_TEXT_CONTENT  0x0200u
#define INDEXJOB_FLAG_HAVE_DEFAULT_WOUT_CONTENT  0x0400u
#define INDEXJOB_FLAG_HAVE_CONVERT_TO_RUSSIAN    0x0800u

extern struct indexjob_t *indexJobs;

Boolean createDefaultIndexJob( struct zcontext_t *cnt, struct zstrbuf_t *sb);

Boolean initDefaultIndexJobConfig( struct zcontext_t *cnt, struct zconfsec_t *cur,
    unsigned int flags, const char *fileName, void *data);
Boolean initIndexJobConfig( struct zcontext_t *cnt, struct zconfsec_t *cur,
    unsigned int flags, const char *fileName, void *data);
void finishIndexJobConfig( struct zcontext_t *cnt, Boolean success,
    Boolean hasValue, void *data);
void freeIndexJobConfig( struct zcontext_t *cnt, void *data);

int getIndexJobObjectValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobIgnoreFileNamesValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobIgnoreDirNamesValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobIgnoreFullPathFilesValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobIgnoreDirWithFileValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobIgnoreFileURLsValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobReplaceValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobCtypesValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
int getIndexJobCharsetsValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobCharsetMethodsValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexAccessFileValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int getIndexJobConvertToRussianValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
#endif

Boolean defaultIndexJobConfig( struct zcontext_t *cnt, struct zstrbuf_t *sb);

void printIndexJobs( struct zcontext_t *cnt );

#ifdef __cplusplus
}
#endif

#endif
