/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __CONFIGUR_A
#define __CONFIGUR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern zint_t E_MaxMemoryVolum;
extern char *E_TempDir;
extern int E_MaxSwapFiles;
extern Boolean E_FollowLinks;
extern int E_MaxContentLength;

extern char *E_IndexFile;
extern char *E_IndexName;
extern char *E_IndexDescription;
extern char *E_IndexPointer;
extern char *E_IndexAdmin;

extern struct zstrcoll_t E_ValidWords;
extern struct zstrcoll_t E_StopWords;
extern struct zstrcoll_t E_BadWords;
extern struct zstrcoll_t E_RejectWords;
extern int E_IgnoreFilesLimit;
extern int E_IgnorePercentLimit;
extern int E_MinWordLength;
extern int E_MaxWordLength;

#define FLUIDS_DEFAULT_STRING    "^^FLUIdSDefault^^"

Boolean configure( struct zcontext_t *cnt, const char *fileName, struct zstrbuf_t *sb);
void freeConfMemory( struct zcontext_t *cnt );

void printConfigure( struct zcontext_t *cnt );

#define PRINT_COLLECTION_A(cn,nm,cl,n) \
    do                                 \
    {                                  \
      zprintf( cn, "%s", (nm));        \
      for( i = 0; i < (cl)->count; i++) zprintf( cn, " \"%a\"", &(cl)->list[i][n]); \
      zprintf( cn, "\n");              \
    } while( 0 )

#define PRINT_COLLECTION_S(cn,nm,cl,n) \
    do                                 \
    {                                  \
      zprintf( cn, "%s", (nm));        \
      for( i = 0; i < (cl)->count; i++) zprintf( cn, " \"%s\"", &(cl)->list[i][n]); \
      zprintf( cn, "\n");              \
    } while( 0 )

#ifdef __cplusplus
}
#endif

#endif
