/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include <stdio.h>
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcharset.h"
#include "zcoll.h"
#include "zstdio.h"

#include "cfg.h"
#include "defs.h"
#include "indio.h"
#include "indxfile.h"
#include "words.h"

#include "fileinfo.h"
#include "wordinfo.h"
#include "dump.h"

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( UKRAINIAN_SUPPORT ) && defined( UKRAINIAN_INTERFACE )
#define TIME_STRINGS zTimeUkrainianStrings
#elif defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE ) &&\
    defined( RUSSIAN_INTERFACE )
#define TIME_STRINGS zTimeRussianStrings
#else
#define TIME_STRINGS NULL
#endif

/***************************************************************************/
/*                                                                         */
/*  Header                                                                 */
/*                                                                         */
/***************************************************************************/

#define STRING_LOCAL_STUFF       " 䨣"
#define STRING_LOCAL_CHARSET     " ஢:"
#define STRING_INDEX_INFO        "  "
#define STRING_FILE_NAME         " 䠩:"
#define STRING_INDEX_NAME        " :"
#define STRING_INDEX_DESCRIPTION "ᠭ :"
#define STRING_INDEX_POINTER     "⥫ :"
#define STRING_INDEX_ADMIN       " :"
#define STRING_HEADER_INFO       "  "
#define STRING_INDEX_VERSION     " ଠ:"
#define STRING_INDEX_CHARSET     "஢:"
#define STRING_WORD_COUNT        "᫮ ந஢ ᫮:"
#define STRING_FILE_COUNT        "᫮ ந஢ 䠩:"
#define STRING_INDEX_DATE        " 樨:"
#define STRING_FILE_SIZE         " ( ):"
#define STRING_STOP_WORDS        "Stop words:"
#define STRING_VALID_WORDS       "Valid words:"

static void printWords( struct zstrcoll_t *words )
{
  int i;

  for( i = 0; i < words->count; i++)
  {
    if( i > 0 ) zprintf( words->context, " ");
    zprintf( words->context, &words->list[i][1]);
  }

  zprintf( words->context, "\n");
}

static Boolean dumpHeader( struct indexfile_t *pif )
{
  struct zcontext_t *cnt = pif->context;
  struct tm tm;
  char buf[40];

/* Local stuff */
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  zprintf( cnt, "%s\n" SHIFT_STRING "%-33s %s\n\n",
    STRING_LOCAL_STUFF, STRING_LOCAL_CHARSET,
    zCharsetName( cnt->localCharset, ZCHARSET_NAME_OFFICIAL));
#endif

/* Index info */
  zprintf( cnt, "%s\n" SHIFT_STRING "%-33s %s\n" SHIFT_STRING "%-33s %s\n"
    SHIFT_STRING "%-33s %s\n" SHIFT_STRING "%-33s %s\n" SHIFT_STRING "%-33s %s\n\n",
    STRING_INDEX_INFO, STRING_FILE_NAME, pif->alias,
    STRING_INDEX_NAME, (pif->indexName == NULL) ? "" : pif->indexName,
    STRING_INDEX_DESCRIPTION, (pif->indexDescription == NULL) ? "" : pif->indexDescription,
    STRING_INDEX_POINTER, (pif->indexPointer == NULL) ? "" : pif->indexPointer,
    STRING_INDEX_ADMIN, (pif->indexAdmin == NULL) ? "" : pif->indexAdmin);

/* Header info */
  zprintf( cnt, "%s\n" SHIFT_STRING "%-33s %d.%d\n" SHIFT_STRING "%-33s ",
    STRING_HEADER_INFO, STRING_INDEX_VERSION, pif->header.version,
    pif->header.subversion, STRING_INDEX_CHARSET);

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  if( pif->header.charset == ZGCS_NONE )
    zprintf( cnt, "undefined (%d)\n", pif->header.charset);
  else if( !zIsKnownCharset( pif->header.charset ) )
    zprintf( cnt, "unknown (%d)\n", pif->header.charset);
  else
  {
    const char *s = zCharsetName( pif->charset, ZCHARSET_NAME_OFFICIAL);
    if( s == NULL )
      zprintf( cnt, "#%d\n", pif->header.charset);
    else
      zprintf( cnt, "%s\n", s);
  }
#else
  zprintf( cnt, "#%d\n", pif->header.charset);
#endif

  if( pif->header.timeStamp != 0 )
    zTimeString( buf, sizeof( buf ), NULL, zMakeTime( pif->header.timeStamp, &tm, 0), TIME_STRINGS);
  zprintf( cnt, SHIFT_STRING "%-33s %" _ZINT_FORMAT "u\n"
    SHIFT_STRING "%-33s %" _ZINT_FORMAT "u\n"
    SHIFT_STRING "%-33s %s\n"
    SHIFT_STRING "%-33s %" _ZINT_FORMAT "u\n",
    STRING_WORD_COUNT, pif->header.wordCount,
    STRING_FILE_COUNT, pif->header.fileCount,
    STRING_INDEX_DATE, (pif->header.timeStamp == 0) ? "unknown date" : buf,
    STRING_FILE_SIZE, pif->header.fileSize);

  zprintf( cnt, SHIFT_STRING "%-33s ", STRING_STOP_WORDS);
  printWords( FLU(cnt)->stopWords );

  zprintf( cnt, SHIFT_STRING "%-33s ", STRING_VALID_WORDS);
  printWords( FLU(cnt)->validWords );

  zprintf( cnt, "\n");
  return True;
}

/***************************************************************************/
/*                                                                         */
/*  Main dump subroutine                                                   */
/*                                                                         */
/***************************************************************************/

Boolean dump( struct zcontext_t *cnt, const char *fileName,
    unsigned int options, struct zstrcoll_t *words, const char *docName)
{
  struct indexfile_t indexFile;
  Boolean success = True;

  if( !ifReadOpen( cnt, &indexFile, fileName, NULL, 0) ) return False;

  if( !zCheckFlags( options, optSuppressHeader) )
    success = dumpHeader( &indexFile );

  if( success && words->count > 0 )
    success = dumpWordInfo( &indexFile, words);

  if( success && zCheckFlags( options, optWordIndex | optWordList) )
    success = dumpWordIndex( &indexFile, (Boolean) zCheckFlags( options, optWordIndex));

  if( success && docName != NULL )
    success = dumpDocumentWords( &indexFile, docName);

#if defined( FLUIDS43 )
  if( success && zCheckFlags( options, optDirIndex) )
    success = dumpDirIndex( &indexFile );
#endif

  if( success && zCheckFlags( options, optFileIndex | optFileList) )
    success = dumpFileIndex( &indexFile, (Boolean) zCheckFlags( options, optFileIndex));

  if( success && zCheckFlags( options, optWordTrack) )
    success = dumpWordTrack( &indexFile );

  ifClose( &indexFile, False);

  freeStopWords( cnt );
  freeValidWords( cnt );

  return success;
}
