/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __DEFS_A
#define __DEFS_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

/* #define FLUIDS43 */

#if SIZEOF_INT < 4
typedef unsigned int _fn_t;
#else
typedef unsigned zint_t _fn_t;
#endif
typedef unsigned zint_t _rn_t;
typedef unsigned zshort_t _st_t;

#if SIZEOF_INT < 4
#define MAX_FILENUM                    (10*1024-1)
#else
#define MAX_FILENUM                    __ZINT(0x1fffffu)
#endif
#define MAX_RANK                       __ZINT(4294967295u)

#if SIZEOF_INT < 4
#define PRINTFORMAT_FILENUM            "%u"
#else
#define PRINTFORMAT_FILENUM            "%" _ZINT_FORMAT "u"
#endif
#define PRINTFORMAT_RANK               "%" _ZINT_FORMAT "u"

#if defined( FLUIDS43 )
#define VERSION                        "4.3a"
#define INDEX_VERSION                  0
#define INDEX_SUBVERSION               40
#else
#define VERSION                        "4.2.4"
#define INDEX_VERSION                  4
#define INDEX_SUBVERSION               3
#endif

#define MAX_STRING_LENGTH              1024
#define MAX_FILENAME_LENGTH            1024

#define MAX_WORD_SIZE                  64
#define ITEM_LIST_SIZE                 1001

#define MAX_TEMPLATE_STRING_SIZE       (4*1024)

#define INDEX_FILE_ENDIAN              True

#define MAX_REF_SIZE                   (4*1024)

#endif
