/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __CFG_A
#define __CFG_A

#ifndef __ZCFG_A
#include "zcfg.h"
#endif

/***************************************************************************/
/*                                                                         */
/*  Global options                                                         */
/*                                                                         */
/***************************************************************************/

/* Whether to support Russian or not */
#define RUSSIAN_RELEASE

/* The minimum length of a word in the index. */
#define MIN_WORD_LENGTH                1

/* The maximum length of a word in the index. */
#define MAX_WORD_LENGTH                32

/* The default name of the index file in case it is not specified
   in the command line (for flindex, flsearch and fldump). */
#define DEFAULT_INDEX_FILE_NAME        "index.flu"

/* This value may be 0, 1, 2 or 3. */
#define DEFAULT_VERBOSE_LEVEL          2

/* Access permisions for the index file.
   If you don't want to set the permisions comment it out. */
/* #define INDEX_PERMISIONS               0444 */

#define MAX_NAME_LENGTH                1024
#define MAX_TITLE_LENGTH               160
#define MAX_CONTENT_LENGTH             512

/***************************************************************************/
/*                                                                         */
/*  Indexing options                                                       */
/*                                                                         */
/***************************************************************************/

#define MAX_SWAP_FILES                 10

#define MAX_MEMORY_VOLUM               __ZINT(5000000)

#define IGNORE_FILES_LIMIT             512
#define IGNORE_PERCENT_LIMIT           101

/* This is how many bytes deep FLUIdS will look into an HTML file to
   attempt to find a ContentType <META> tag. */
#define CHARSET_META_TAG_BYTES         (2*1024)

/* Default content type for a file.
   Should be one of CTYPE_NONTEXT, CTYPE_TEXT, CTYPE_HTML or CTYPE_UNKNOWN. */
#define DEFAULT_CONTENT_TYPE           CTYPE_UNKNOWN

/* Whether index or not the name of a file whose content type is text/plain
   or text/html. */
#define INDEX_CONTENT_FILE_NAMES

/* Bits of the characters which are permited to be in the indexed words */
#define WORD_CHAR_BITS                 (CHAR_ENGLISH | CHAR_RUSSIAN | CHAR_DIGIT)
/* #define BEGIN_WORD_CHAR_BITS           WORD_CHAR_BITS */
/* #define END_WORD_CHAR_BITS             WORD_CHAR_BITS */

/* The maximum times a letter can repeat in a word. */
/* #define MAX_EQUAL_SEQUENCE_SIZE        3 */

/* The maximum number of consecutive vowels a word can have. */
/* #define MAX_VOWEL_SEQUENCE_SIZE        5 */

/* The maximum number of consecutive consonants a word can have. */
/* #define MAX_CONSONANT_SEQUENCE_SIZE    6 */

/* The maximum number of consecutive digits a word can have. */
/* #define MAX_DIGIT_SEQUENCE_SIZE        20 */

/* Don't index words containing english and russian letters in one. */
#define SINGLE_LANGUAGE_WORDS

/* Don't index words containing only digits (such as '123'). */
/* #define IGNORE_ALL_DIGITS_WORD */

/* Don't index words containing only consonants (such as 'pts'). */
/* #define IGNORE_ALL_CONSONANTS_WORD */

/* Don't index words containing only vowels (such as 'aeu'). */
/* #define IGNORE_ALL_VOWELS_WORD */

/***************************************************************************/
/*                                                                         */
/*  Searching options                                                      */
/*                                                                         */
/***************************************************************************/

/* MAX_HITS is the maximum number of results to return from a search.
   You could define it as -1 for all results. Used in flsearch only. */
#define MAX_HITS                       -1

/* If a list of search words is specified without booleans,
   FLUIdS will assume they are tied by a default operation.
   This should be optAnd or optOr. */
#define DEFAULT_OPERATION              optAnd

#define SUBWORD_SEARCH

/***************************************************************************/
/*                                                                         */
/*  FLUIdS CGI options                                                     */
/*                                                                         */
/***************************************************************************/

#define FLUIDS_CONF_FILE               "fluids.cfg"
#define FLUIDS_ROOT_DIR                "~"

#define FLUIDS_CYR_CONVERT
#define FLUIDS_CYR_REPLACE
#define FLUIDS_CHARSET_LIST

#define DEFAULT_TERSE_LEVEL            trsDetailed

#define DEFAULT_PAGE_SIZE              20

#define MAX_PAGES_PER_BLOCK            15

#define DEFAULT_QUERY_TYPE             qtpExternalForm

#define DEFAULT_USER_OPTIONS \
    (USEROPTION_FLUIDS_LOGO | USEROPTION_META_CHARSET_TAG |\
     USEROPTION_CHARSET_LIST | USEROPTION_SEARCH_TIME |\
     USEROPTION_EXECUTED_QUERY | USEROPTION_PROBLEM_WORDS |\
     USEROPTION_LOGO_SPECIAL_EFFECTS | USEROPTION_ESCAPED_URLS)

/* #define FULL_FILE_NAMES */

#endif
