/*  showstar.c  */
/*  part of the fitsblink program  */
/*  Jure Skvarc                    */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
 
#include <forms.h>
#include <string.h>
#include <fitsio.h>

#include "formblink.h"
#include "functs.h"

extern STATE state;
extern BLINK_FRAME *frame;
extern CATALOG catalog[];


void
objstarC(FL_OBJECT *obj, long val)

{
  fl_trigger_object(state.showstar->acceptstarW);
  fl_trigger_object(state.showstar->okstarW);
}

/*  Show an object */
int
showstar(BLINK_FRAME *frame, int n, STAR *z, int ok, char *name)

{
  double ac, dc;
  char a[25];
  int out, err = 0;
  XEvent event;
  FL_OBJECT *o;
  double xc, yc, xinc, yinc;

  int xmin, xmax, ymin, ymax;
  int w, h;
  int xq, yq, xt, yt, x, y;
  int zoom;
  int i, j;
  PIXEL v;
  FITS_IMAGE *im;
  Display *disp;
  GC gc = fl_state[fl_get_form_vclass(state.blinker->blinker)].gc[0];
  Window win;

  xinc = frame[n].map.width / frame[n].map.w;
  yinc = frame[n].map.height / frame[n].map.h;
  xc = 0.5 * frame[n].map.w;
  yc = 0.5 * frame[n].map.h;
  /*  The window in not created yet, do it now  */
  if (state.showstar == NULL) {
    state.showstar = create_form_Star();
    fl_set_object_shortcut(state.showstar->acceptstarW, "^m", 1);
    fl_set_object_shortcut(state.showstar->okstarW, "^m", 1);
  }
  if (ok) {
    fl_hide_object(state.showstar->acceptstarW);
    fl_hide_object(state.showstar->rejectstarW);
    fl_show_object(state.showstar->okstarW);
    fl_deactivate_object(state.showstar->objstarW);
  }
  else {
    fl_show_object(state.showstar->acceptstarW);
    fl_show_object(state.showstar->rejectstarW);
    fl_hide_object(state.showstar->okstarW);
    fl_activate_object(state.showstar->objstarW);
  }
  fl_show_form(state.showstar->Star,  FL_FIX_SIZE, FL_FULLBORDER | FL_PLACE_FREE_CENTER, "Clicked object");
  /*  Write object coordinates in the window  */
  sprintf(a, "x = %.2f", z->x);
  fl_set_object_label(state.showstar->xstarW, a);
  sprintf(a, "y = %.2f", z->y);
  fl_set_object_label(state.showstar->ystarW, a);
  if (frame[n].matched) {
    sprintf(a, "RA = %s", format_ra(z->ra));
    fl_set_object_label(state.showstar->rastarW, a);
    sprintf(a, "DEC = %s", format_dec(z->dec));
    fl_set_object_label(state.showstar->decstarW, a);
  }
  else if (frame[n].fitsfile.wcs) {
    fits_pix_to_world(z->x + 1, z->y + 1, 
		      frame[n].fitsfile.crval1, frame[n].fitsfile.crval2, 
		      frame[n].fitsfile.crpix1, frame[n].fitsfile.crpix2, 
		      frame[n].fitsfile.cdelt1, frame[n].fitsfile.cdelt2, 
		      frame[n].fitsfile.crot,
		      frame[n].fitsfile.ctype,
		      &ac, &dc, &err);
    sprintf(a, "RA = %s", format_ra(ac));
    fl_set_object_label(state.showstar->rastarW, a);
    sprintf(a, "DEC = %s", format_dec(dc));
    fl_set_object_label(state.showstar->decstarW, a);
  }
  else {
    fl_set_object_label(state.showstar->rastarW, " ");
    fl_set_object_label(state.showstar->decstarW, " ");
  }
  if (name != NULL) {
    fl_set_input(state.showstar->objstarW, name);
  }
  /*  Draw a small subimage centered around the chosen object  */
  /*=====================================================*/
  o = state.showstar->windstarW;
  win = FL_ObjWin(o);
  disp = state.disp;
  x = z->x;
  y = z->y;
  im = &(frame[n].fits);
  /*  Determine number of pixels in x and y direction  */
  zoom = 5;
  w = o->w / zoom;
  h = o->h / zoom;
  /*  Limiting coordinates of the area shown  */
  xmin = max(0, x - w);
  xmax = min(x + w, im->width - 1);
  ymin = max(0, y - h);
  ymax = min(y + h, im->height - 1);
  /*  Do the drawing  */
  yq = o->y;
  yt = y - h / 2;
  for (j = 0; j < h; j++) {
    xq = o->x;
    xt = x - w / 2; 
    for (i = 0; i < w; i++) {
      v = video_point(im, xt++, yt);
      XSetForeground(disp, gc, state.pixel[correct(frame, n, v)]);
      XFillRectangle(disp, win, gc, xq, yq, zoom, zoom);
      xq += zoom;
    }
    yq += zoom;
    yt++;
  }
  /*  Draw a cross  */
  xt = o->x + (z->x - (x - w / 2)) * zoom + 2;
  yt = o->y + (z->y - (y - h / 2)) * zoom + 2;
  w = o->w / 4;
  h = o->h / 4;
  fl_line(xt, o->y, xt, o->y + o->h - 1, FL_RED);
  fl_line(o->x, yt, o->x + o->w - 1, yt, FL_RED);

  out = 0;
  fl_deactivate_all_forms();
  fl_activate_form(state.showstar->Star);
  do {
    o = fl_check_forms();
    if (o == FL_EVENT) {
      fl_XNextEvent(&event);
    }
    else if (o == state.showstar->acceptstarW) {
      out = 2;
      strncpy(name, fl_get_input(state.showstar->objstarW), 80);
    }
    else if (o == state.showstar->rejectstarW) {
      out = 1;
    }
    else if (o == state.showstar->okstarW) {
      out = 3;
    }
  } while(!out);
  fl_hide_form(state.showstar->Star);
  fl_activate_all_forms();
  return out - 1;
}

