/*  settings.c  */
/*  part of the fitsblink program  */
/*  routines for loading and saving of some settings  */
/*  Jure Skvarc, May 1998                   */
#define __USE_SVID 1
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <forms.h>

#include "functs.h"

extern STATE state;
extern BLINK_FRAME *frame;
extern CATALOG catalog[NUMBER_OF_CATALOGS];
extern OBSERVATORY observatory;
extern TELESCOPE telescope;
extern MAIL mail;

/*  Save some default values used by Fitsblink  */
int
save_settings(void)

{
  char *home;
  char *rcpath;
  char *rcname = "/.fitsblinkrc";
  FILE *fp;

  /*  Get home directory  */
  home = getenv("HOME");
  /*  Reserve space for full name  */
  rcpath = (char *) myalloc(sizeof(char) * (strlen(home) + strlen(rcname) + 1),
			    "save_settings", "rcpath");
  strcpy(rcpath, home);
  strcat(rcpath, rcname);
  if ((fp = fopen(rcpath, "w")) == NULL) {
    fl_show_alert("Can't open parameter file", "", "", 1);
    return 1;
  }
  fprintf(fp, "USNO_PATH %s\n", catalog[CAT_USNO].path);
  /*  fprintf(fp, "PPM_PATH %s\n", catalog[CAT_PPM].path); */
  fprintf(fp, "GUIDE_NORTH_PATH %s\n", catalog[CAT_GUIDE].path);
  fprintf(fp, "GUIDE_SOUTH_PATH %s\n", catalog[CAT_GUIDE_SOUTH].path);
  fprintf(fp, "OBSERVATORY %d\n", observatory.code);
  fprintf(fp, "OBSERVER %s\n", observatory.observer);
  fprintf(fp, "TELESCOPE %s\n", observatory.telescope);
  fprintf(fp, "INSTRUMENT %s\n", observatory.instrument);
  fprintf(fp, "LONGITUDE %.6f\n", observatory.longitude);
  fprintf(fp, "LATITUDE %.6f\n", observatory.latitude);
  fprintf(fp, "LOGFILE %s\n", state.logfile);
  fprintf(fp, "TO_ADDRESS %s\n", mail.to);
  fprintf(fp, "CC_ADDRESS %s\n", mail.cc);
  fprintf(fp, "MAIL_TITLE %s\n", mail.title);
  fprintf(fp, "FILE_TO_MAIL %s\n", mail.file);
  fprintf(fp, "COLOR %d\n", (fl_get_button(state.set_display->color_setW)) ? 1 : 0);
  fprintf(fp, "INVERSE %d\n", (fl_get_button(state.set_display->inverse_setW)) ? 1 : 0);
  fprintf(fp, "DELAY %.1f\n", fl_get_counter_value(state.set_display->set_deltatW));
  fprintf(fp, "TEL_START %s\n", telescope.start);
  fprintf(fp, "TEL_POINT %s\n", telescope.point);
  fprintf(fp, "TEL_PARK %s\n", telescope.park);
  fprintf(fp, "TEL_WHERE %s\n", telescope.where);
  fprintf(fp, "TEL_ZERO %s\n", telescope.zero);
  fprintf(fp, "TEL_CENTER %s\n", telescope.center);
  fprintf(fp, "CCD_SETTEMP %s\n", telescope.settemp);
  fprintf(fp, "CCD_GETTEMP %s\n", telescope.gettemp);
  fprintf(fp, "CCD_EXPOSE %s\n", telescope.expose);
  if (state.wwwbrowser) fprintf(fp, "BROWSER %s\n", state.wwwbrowser);
  if (state.helpfile) fprintf(fp, "HELPFILE %s\n", state.helpfile);
  if (fclose(fp) != 0) {
    fl_show_alert("Error in closing parameter file", "", "", 1);
  }
  free(rcpath);
  return 0;
}


/*  Load some default values used by Fitsblink  */
int
load_settings(void)

{
  char *home;
  char t[256], *p, *r;
  char *rcpath;
  char *rcname = "/.fitsblinkrc";
  FILE *fp;

  /*  Get home directory  */
  home = getenv("HOME");
  /*  Reserve space for full name  */
  rcpath = (char *) myalloc(sizeof(char) * (strlen(home) + strlen(rcname) + 1),
			    "save_settings", "rcpath");
  strcpy(rcpath, home);
  strcat(rcpath, rcname);
  if ((fp = fopen(rcpath, "r")) == NULL) {
    fl_show_alert("Can't open parameter file", "", "", 1);
    return 1;
  }
  while (!feof(fp)) {
    /*  Read one line */
    if (!fgets(t, 256, fp)) break;
    p = t;
    p = strtok(p, " \t\n");
    if (!p) continue;
    if (!strcmp("USNO_PATH", p)) {
      r = strtok(NULL, " \t");
      if (r) {
	trim_spaces(r);
	strncpy(catalog[CAT_USNO].path, r, PATHLENGTH);
      }
    }
    else if (!strcmp("PPM_PATH", p)) {
      r = strtok(NULL, " \t");
      if (r) {
	trim_spaces(r);
	strcpy(catalog[CAT_PPM].path, r);
      }
    }
    else if (!strcmp("GUIDE_NORTH_PATH", p)) {
      r = strtok(NULL, " \t");
      if (r) {
	trim_spaces(r);
	strcpy(catalog[CAT_GUIDE].path, r);
      }
    }
    else if (!strcmp("GUIDE_SOUTH_PATH", p)) {
      r = strtok(NULL, " \t");
      if (r) {
	trim_spaces(r);
	strcpy(catalog[CAT_GUIDE_SOUTH].path, r);
      }
    }
    else if (!strcmp("OBSERVATORY", p)) {
      r = strtok(NULL, " \t");
      if (r) {
	sscanf(r, "%d", &observatory.code);
      }
    }
    else if (!strcmp("OBSERVER", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(observatory.observer, r, CARDLENGTH);
      }
    }
    else if (!strcmp("TELESCOPE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(observatory.telescope, r, CARDLENGTH);
      }
    }
    else if (!strcmp("INSTRUMENT", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(observatory.instrument, r, CARDLENGTH);
      }
    }
    else if (!strcmp("LONGITUDE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	observatory.longitude = strtod(r, NULL);
      }
    }
    else if (!strcmp("LATITUDE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	observatory.latitude = strtod(r, NULL);
      }
    }
    else if (!strcmp("LOGFILE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.logfile = strdup(r);
      }
    }
    else if (!strcmp("TO_ADDRESS", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	mail.to = strdup(r);
      }
    }
    else if (!strcmp("CC_ADDRESS", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	mail.cc = strdup(r);
      }
    }
    else if (!strcmp("MAIL_TITLE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	mail.title = strdup(r);
      }
    }
    else if (!strcmp("FILE_TO_MAIL", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	mail.file = strdup(r);
      }
    }
    else if (!strcmp("COLOR", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.color = strtol(r, NULL, 10);
      }
    }
    else if (!strcmp("INVERSE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.inverse = strtol(r, NULL, 10);
      }
    }
    else if (!strcmp("DELAY", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.delay = strtod(r, NULL);
      }
    }
    else if (!strcmp("TEL_START", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.start, r, 255);
      }
    }
    else if (!strcmp("TEL_POINT", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.point, r, 255);
      }
    }
    else if (!strcmp("TEL_WHERE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.where, r, 255);
      }
    }
    else if (!strcmp("TEL_ZERO", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.zero, r, 255);
      }
    }
    else if (!strcmp("TEL_CENTER", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.center, r, 255);
      }
    }
    else if (!strcmp("TEL_PARK", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.park, r, 255);
      }
    }
    else if (!strcmp("CCD_GETTEMP", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.gettemp, r, 255);
      }
    }
    else if (!strcmp("CCD_SETTEMP", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.settemp, r, 255);
      }
    }
    else if (!strcmp("CCD_EXPOSE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	strncpy(telescope.expose, r, 255);
      }
    }
    else if (!strcmp("BROWSER", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.wwwbrowser = strdup(r);
      }
    }
    else if (!strcmp("HELPFILE", p)) {
      r = strtok(NULL, "\n");
      if (r) {
	trim_spaces(r);
	state.helpfile = strdup(r);
      }
    }
    else {
      trim_spaces(p);
      if (strlen(p) > 0) fprintf(stderr, "Unknown parameter %s ignored.\n", p);
    }
  }
  return 0;   
}             
              

/*  Catalog paths  */
/*******************/
void 
usno_path_setC(FL_OBJECT *obj, long val)

{
  usnodirC(obj, val);
}

void 
ppm_path_setC(FL_OBJECT *obj, long val)

{
  ppmdirC(obj, val);
}

void 
gsc_north_path_setC(FL_OBJECT *obj, long val)

{
  guidedirC(obj, val);
}

void 
gsc_south_path_setC(FL_OBJECT *obj, long val)

{
  guidedirsouthC(obj, val);
}


/*  Observatory data  */
/**********************/
void 
telescope_setC(FL_OBJECT *obj, long val)

{
  strncpy(observatory.telescope, fl_get_input(obj), CARDLENGTH - 1);
}

void 
observatory_setC(FL_OBJECT *obj, long val)

{
  int c;
  char a[10];

  c = strtol(fl_get_input(obj), NULL, 10);
  sprintf(a, "%d", c);
  fl_set_input(obj, a);
  observatory.code = c;
}

void 
observer_setC(FL_OBJECT *obj, long val)

{
  strncpy(observatory.observer, fl_get_input(obj), CARDLENGTH - 1);
}

void 
instrument_setC(FL_OBJECT *obj, long val)

{
  strncpy(observatory.instrument, fl_get_input(obj), CARDLENGTH - 1);
}

void 
observatory_longitudeC(FL_OBJECT *obj, long val)

{
  char a[15];

  observatory.longitude = strtod(fl_get_input(obj), NULL);
  sprintf(a, "%.6f", observatory.longitude);
  fl_set_input(obj, a);
}

void 
observatory_latitudeC(FL_OBJECT *obj, long val)

{
  char a[15];

  observatory.latitude = strtod(fl_get_input(obj), NULL);
  sprintf(a, "%.6f", observatory.latitude);
  fl_set_input(obj, a);
}


/*  Mail defaults  */
/*******************/
void 
to_setC(FL_OBJECT *obj, long val)

{
  toaddressC(obj, val);
}

void 
cc_setC(FL_OBJECT *obj, long val)

{
  ccaddressC(obj, val);
}

void 
subject_setC(FL_OBJECT *obj, long val)

{
  mailtitleC(obj, val);
}

void 
file_setC(FL_OBJECT *obj, long val)

{
  mailfileC(obj, val);
}

/*  Display settings  */
/**********************/
void 
color_setC(FL_OBJECT *obj, long val)

{
}

void 
inverse_setC(FL_OBJECT *obj, long val)

{
}

/*==============================================*/
/*  Commands for camera and telescope control   */
/*==============================================*/

void
comstartC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.start, fl_get_input(obj));
}

void
compointC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.point, fl_get_input(obj));
}

void
comparkC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.park, fl_get_input(obj));
}

void
comwhereC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.where, fl_get_input(obj));
}

void
comzeroC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.zero, fl_get_input(obj));
}

void
comcenterC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.center, fl_get_input(obj));
}

void
comgettempC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.gettemp, fl_get_input(obj));
}

void
comsettempC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.settemp, fl_get_input(obj));
}

void
comexposeC(FL_OBJECT *obj, long val)

{
  strcpy(telescope.expose, fl_get_input(obj));
}

/***************************/
/*  WWW browser path       */
/***************************/
void
setbrowserC(FL_OBJECT *obj, long val)

{
  if (state.wwwbrowser) free(state.wwwbrowser);
  state.wwwbrowser = strdup((char *)fl_get_input(obj));
}

void
sethelpfileC(FL_OBJECT *obj, long val)

{
  if (state.helpfile) free(state.helpfile);
  state.helpfile = strdup((char *)fl_get_input(obj));
}



void
show_settings(FL_OBJECT *obj, int m)

{
  char a[10];
  int out;
  XEvent event;
  FL_OBJECT *o;

  /*  The window in not created yet, do it now  */
  if (state.settings == NULL) {
    state.settings = create_form_Settings();
    state.set_catalogs = create_form_Set_catalogs();
    state.set_observatory = create_form_Set_observatory();
    state.set_display = create_form_Set_display();
    state.set_mail = create_form_Set_mail();
    state.set_help = create_form_Set_help();
    state.set_commands = create_form_Commands();
    state.set_ccd = create_form_Set_ccd();
    fl_addto_tabfolder(state.settings->setfolderW, "Catalogs", 
		       state.set_catalogs->Set_catalogs);
    fl_addto_tabfolder(state.settings->setfolderW, "Observatory", 
		       state.set_observatory->Set_observatory);
    fl_addto_tabfolder(state.settings->setfolderW, "Display", 
		       state.set_display->Set_display);
    fl_addto_tabfolder(state.settings->setfolderW, "Mail", 
		       state.set_mail->Set_mail);
    fl_addto_tabfolder(state.settings->setfolderW, "Telescope", 
		       state.set_commands->Commands);
    fl_addto_tabfolder(state.settings->setfolderW, "Camera", 
		       state.set_ccd->Set_ccd);
    fl_addto_tabfolder(state.settings->setfolderW, "Help", 
		       state.set_help->Set_help);
    fl_set_counter_bounds(state.set_display->set_deltatW, 0.0, 5.0);
    fl_set_counter_value(state.set_display->set_deltatW,  
			 fl_get_counter_value(state.blinker->deltatW));
    fl_set_counter_step(state.set_display->set_deltatW, 0.1, 0.1);
  }
  fl_show_form(state.settings->Settings,  FL_FIX_SIZE, FL_FULLBORDER | FL_PLACE_FREE_CENTER, "Image options");
  fl_set_input(state.set_catalogs->usno_pathW, catalog[CAT_USNO].path);
  fl_set_input(state.set_catalogs->ppm_pathW, catalog[CAT_PPM].path);
  fl_hide_object(state.set_catalogs->ppm_pathW);
  fl_set_input(state.set_catalogs->gsc_north_pathW, catalog[CAT_GUIDE].path);
  fl_set_input(state.set_catalogs->gsc_south_pathW, catalog[CAT_GUIDE_SOUTH].path);
  fl_set_input(state.set_observatory->telescopeW, observatory.telescope);
  sprintf(a, "%d", observatory.code);
  fl_set_input(state.set_observatory->observatoryW, a);
  fl_set_input(state.set_observatory->observerW, observatory.observer);
  fl_set_input(state.set_observatory->instrumentW, observatory.instrument);
  sprintf(a, "%.6f", observatory.longitude);
  fl_set_input(state.set_observatory->observatory_longitudeW, a);
  sprintf(a, "%.6f", observatory.latitude);
  fl_set_input(state.set_observatory->observatory_latitudeW, a);
  fl_set_input(state.set_mail->toW, mail.to);
  fl_set_input(state.set_mail->ccW, mail.cc);
  fl_set_input(state.set_mail->subjectW, mail.title);
  fl_set_input(state.set_mail->fileW, mail.file);
  fl_set_button(state.set_display->color_setW, state.color);
  fl_set_button(state.set_display->inverse_setW, state.inverse);
  fl_set_button(state.set_display->set_deltatW, state.inverse);

  fl_set_input(state.set_commands->comstartW, telescope.start);
  fl_set_input(state.set_commands->comparkW, telescope.park);
  fl_set_input(state.set_commands->compointW, telescope.point);
  fl_set_input(state.set_commands->comwhereW, telescope.where);
  fl_set_input(state.set_commands->comzeroW, telescope.zero);
  fl_set_input(state.set_commands->comcenterW, telescope.center);
  fl_set_input(state.set_ccd->comgettempW, telescope.gettemp);
  fl_set_input(state.set_ccd->comsettempW, telescope.settemp);
  fl_set_input(state.set_ccd->comexposeW, telescope.expose);

  if (state.wwwbrowser) fl_set_input(state.set_help->setbrowserW, state.wwwbrowser);
  if (state.helpfile) fl_set_input(state.set_help->sethelpfileW, state.helpfile);

  out = 0;
  do {
    o = fl_check_forms();
    if (o == FL_EVENT) {
      fl_XNextEvent(&event);
    }
    else if (o == state.settings->savesettingsW) {
      save_settings();
      out = 1;
    }
    else if (o == state.settings->closesettingsW) {
      out = 1;
    }
  } while(!out);
  fl_hide_form(state.settings->Settings);
}
