/**********************************************************************/
/*         REXX program to simulate PKZip's ZIP2EXE program           */
/*                                                                    */
/* 10/19/94 - Initial REXX program released to public domain.         */
/*            Original program written by Jaime A. Cruz, Jr.          */
/*            (72267.1372@compuserve.com)                             */
/*                                                                    */
/**********************************************************************/
'@ECHO OFF'

/**********************************************************************/
/*      Set variable with pathname to UNZIPSFX.EXE                    */
/**********************************************************************/
stub = 'C:\PK\UNZIPSFX.EXE'

/**********************************************************************/
/*      Extract the name of the .ZIP archive file                     */
/**********************************************************************/
Parse Upper Arg zipfile .
If zipfile = '' Then
   Do
      Say 'Usage:  ZIP2EXE ZipFile'
      Say ''
      Say 'Where ZipFile is the filename of the ZIP file you want to create a'
      Say 'Self-Extracting file from.  Default extension is .ZIP if none is given.'
      Exit 0
   End

/**********************************************************************/
/*            Initialize REXXUtil environment (if not present)        */
/**********************************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/**********************************************************************/
/*      Validate all of the passed file names                         */
/**********************************************************************/
zipdrv = Filespec('D',zipfile)
zippth = Filespec('P',zipfile)
zipnam = Filespec('N',zipfile)
period = Pos('.', zipnam)
If period <> 0 Then
   Do
      zipfn = Substr(zipnam, '1', (period - 1))
      zipft = Substr(zipnam, (period + 1))
   End
Else
   Do
      zipfn = zipnam
      zipft = 'ZIP'
   End
zipfull = zipdrv||zippth||zipfn||'.'||zipft
sfxfull = zipfn||'.EXE'

rc = SysFileTree(stub,    stexist, 'F')
rc = SysFileTree(zipfull, zfexist, 'F')
rc = SysFileTree(sfxfull, sfexist, 'F')
Select
   When (\ stexist.0) Then
      Do
         Say stub 'not found -- verify location of UNZIPSFX.EXE and'
         Say 'modify ZIP2EXE.CMD accordingly.'
         result = 4
      End
   When (\ zfexist.0) Then
      Do
         Say zipfull 'does not exist -- CMD file ending.'
         result = 4
      End
   When (sfexist.0) Then
      Do
         Say sfxfull 'exists -- Overwrite?  (Y/N)'
         ans = SysGetKey('ECHO')
         If ans = 'Y' | ans = 'y' Then
            Do
               'DEL' sfxfull '>NUL'
               result = 0
            End
         Else
            result = 4
         Say ''
      End
   Otherwise
      result = 0
End

/**********************************************************************/
/*      All names parsed.  Create the self-extractor                  */
/**********************************************************************/
If result = 0 Then
   Do
      'COPY /B' stub||'+'||zipfull sfxfull '>NUL'
      result = rc
      If result = 0 Then
         Say sfxfull 'successfully created.'
   End

/**********************************************************************/
/*      If we loaded REXXUtil, unload it, then exit.                  */
/**********************************************************************/
If rxload Then
   Call SysDropFuncs
Exit result
