// save this file as testeditor6.java
import wingsoft.editor.Main;
import wingsoft.editor.Global;
import wingsoft.editor.UserButton;
import wingsoft.editor.Browser;
import wingsoft.editor.EditorConst;

import java.awt.*;

public class testeditor6 {
	public static void main(String argv[]) {
		String[] keywords= {
			"What",
			"Which",
			"Where",
			"How",
			"Who",
			"Why"
		};
		
		String[] extensions= {
			".ask"
		};
		
		Global.addLanguage("Question",extensions,keywords,true);
		
		myMain myeditor= new myMain("testeditor.java");

		Global.setTextFont(new Font("Courier",Font.PLAIN,14));
		myeditor.show();
	}
}

// this is an example showing how to subclass the editor window.
//
// this is a subclass to WingEditor's editor window.
// in the subclass, new Menu named ActionMenu is appended,
// a MenuItem showAction is appended to the View Menu.
// Goto and Project Menu are turned off.
//
class myMain extends Main {

	MenuItem sayItem, singItem, showActionItem;
	static int offMenus[]= {GOTO_MENU,PROJECT_MENU};

	public myMain(String filename) {
		super(filename,offMenus);
		Menu newMenu= new Menu("ActionMenu");

		newMenu.add(sayItem= new MenuItem("Say"));
		newMenu.add(singItem= new MenuItem("Cry"));

		appendMenu(newMenu);

		showActionItem= new MenuItem("Show Action");
		appendMenuItem(showActionItem, VIEW_MENU);
		
		myButton[] buttons= new myButton[3];

		buttons[0]= new myButton("testeditor");
		buttons[1]= new myButton("testeditor2");
		buttons[2]= new myButton("testeditor3");
			
		setUserButtonBar(buttons,true);
		layoutMain();
        // replace the exising buttonBar

		resize(500,600);
	}

	protected Main getEditor(String filename,boolean must) {
		myMain m= new myMain(filename);
		return (Main)m;
	}
	
	public boolean handleEvent(Event evt) {
		if (evt.target==sayItem)
			postFooter("Say something");
		else if (evt.target==singItem)
			postFooter("Cry for something");
		else if (evt.target==showActionItem)
			postFooter("Actions: say and sing");
		else
			return super.handleEvent(evt);
		return true;
	}
}

// this class implements UserButton interface
class myButton extends Button implements UserButton {
	private String title;
	public myButton(String title) {
		super(title);
		this.title= title;
	}

	Main get_parent() {
		Container c= getParent();
		while ((c instanceof Main)==false) {
			c= c.getParent();
		}
		return (Main)c;
	}		

	public void userAction(Event event) {
		
		get_parent().loadFile(title+".java");
	}
}
