/* REXX Whois Client
   (C) 1993 by Steve Luzynski

   Revision history:
   V.1 - Initial Release

   This program requires the rxSock dll function library, available
   anywhere IBM EWS is found.
*/

trace on

parse arg info .

if (info = "") then
do
  say "Please enter a name to look up on the command line."
  say "as in:  WHOIS Steve"
  exit 1
end

/* setup socket package */
if RxFuncQuery("SockLoadFuncs") then
do
  rc = RxFuncAdd("SockLoadFuncs", "RxSock", "SockLoadFuncs")
  rc = SockLoadFuncs()
end

/* get whois server address */
rc = SockGetHostByName("whois", "host.!")
if (rc = 0) then
do
  say "Unable to resolve name of whois server."
  exit
end

server = host.!addr

say "Looking up" info "on" server "..."

/* open a socket to the server */
sock = SockSocket("AF_INET", "SOCK_STREAM", "IPPROTO_TCP")
if (sock = -1) then
do
  say "Error opening socket: " errno
  exit
end

/* connect to whois server */
server.!family = "AF_INET"
server.!port   = 43
server.!addr   = server

rc = SockConnect(sock, "server.!")
if (sock = -1) then
do
  say "Error connecting socket: " errno
  exit
end

data = info || d2c(13) || d2c(10)
i = SockSend(sock, data)
if (errno <> 0) then
do
  SockSoClose(sock)
  exit 1
end
if (i <= 0) then
do
 SockSoClose(sock)
 say "Connection closed by server."
 exit 1
end

do until rc <= 0
   rc = SockRecv(sock, "data", 8000)
   say data
end

rc = SockSend(sock, "quit")
rc = SockSoClose(sock)
exit




