/* WebSlice.cmd v0.70                                                  */
/* Copyright (c) Martin R. Hadam 2001                                  */
/* REXX Program to slice larg images into tiles for web presentation   */
/*    'slices' (tiles) are sized 200x150 pixels by default             */
/*                                                                     */
/* requires Impos/2 REXX; uses undocumented functions:                 */
/*  ImgSelectAll(numImage)                                             */
/*  ImgSelectCircle(numImage,num?,numXPos,numYPos,numXRad,numYRad)     */
/*  ImgSelectRectangle(numImage,num?,numXPos,numYPos,numXSize,numYSize)*/
/*  ImgClosePgm()                                                      */
/* WARNING: use of such functions REQUIRES Impos/2 v2.10               */
/* place CMD file code into impos directory (other locations untested) */
/* logfile will be created in the webslice.cmd (Impos) directory       */
/* image files may be anywhere; image slices (.gif) and html will be   */
/*   created in in the same (image) directory                          */
/* HIGH color images will be converted to 256 colors and saved as GIF  */
/*       version history                                     */
/* v0.10 first code sample                                   */
/* v0.20 now tackling converted file                         */
/* v0.30 add looping through image                           */
/* v0.40 generate html table (in basic page) with same name  */
/* v0.50 first fully working version                         */
/* v0.51 fixed bug in loop termination; now use 'until'      */
/* v0.52 change coding for loop end points                   */
/* v0.53 make relative path for logfile                      */
/* v0.55 added Impos/2 version checking                      */
/* v0.56 load RexxUtil if not already loaded                 */
/* v0.60 allow tile dimensions as optional parameter         */
/*       uncomment ImgShowImage() & add ImgUndo()            */
/*       added colored error messages                        */
/*       add width / height checking controls                */
/* v0.70 fixed bug in calculating y coordinates              */
/*       announce number oftiles being generated             */
SIGNAL ON syntax
SIGNAL ON novalue
CALL ON halt
CALL ON error
PARSE ARG incoming width height
if strip(incoming,,)="" then call errfile
if stream(incoming,"C","Query exists")="" then call errfile
baseimg=strip(incoming,,)
if width||height\="" & (datatype(width,"W")\=1 | datatype(height,"W")\=1) then call errfile

if width>0 | height>0 then do
    /* custom size for tiles                                 */
    if width=0 | height=0 then call errfile
    slice_width=strip(width,,)
    slice_height=strip(height,,)
    end /* do */
else do 
    /* standard size for tiles                               */
    slice_width=200
    slice_height=150
    end /* do */

/* load REXXUTIL if needed                                   */
if RxFuncQuery('sysloadfuncs')=1 then do
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs
    end

/* find path of incoming file                                */
drive=filespec('D',baseimg)
path=filespec('P',baseimg)
filename=filespec('N',baseimg)
basename=substr(filename,1,lastpos(".",filename)-1)
newbase=drive||path||basename
if drive="" then call errfile

logfile=".\WEB_SLICE.LOG"
rc=lineout(logfile)
rc=lineout(logfile,"==================================================")
rc=lineout(logfile,"Start Logging WebSlice")
rc=lineout(logfile,date("L")||"   "||time())

/* check for correct version of Impos/2                      */
impos=SysSearchPath('PATH','IMPOS.EXE')
if impos="" then do
    say; say "Impos/2 not found. Aborting CMD file"
    call lineout logfile,"Impos/2 not found. Aborting CMD file"
    call final
    end /* do */
if stream(impos,"C","Query size")\="824990" then do
    say; say '1B'x||'[33;40m'||'1B'x||'[1;m'||'This CMD file requires Impos/2 v2.10'||'1B'x||'[37;40m'||'1B'x||'[1;m'
    say '1B'x||'[33;40m'||'1B'x||'[1;m'||'Please update your software before using it'||'1B'x||'[37;40m'||'1B'x||'[1;m'
    call lineout logfile,"This CMD file requires Impos/2 v2.10"
    call lineout logfile,"Execution aborted due to wrong Impos/2 version"
    call lineout logfile,"Please update your software"
    call final
    end /* do */

/* load Impos REXX functions & Impos/2                       */
call RxFuncAdd 'ImgInit', 'ImpRexx', 'ImgInitiate'
call ImgInit

/* say DlgImageInfo(curr_image)  */
call lineout logfile,"processing" baseimg

curr_image=ImgLoadImage(baseimg,TRUE)
if curr_image == 0 then do
    say "Image could not be read"
    say "you need to enter the full path"
    call final
    end
else do
    say; say "Image Info"
    say
    say "Width:           " ImgQueryImageInfo(curr_image, 1);
    say "Height:          " ImgQueryImageInfo(curr_image, 2);
    say "Horz. Resolution:" ImgDpiFromDpm(ImgQueryImageInfo(curr_image, 3));
    say "Vert. Resolution:" ImgDpiFromDpm(ImgQueryImageInfo(curr_image, 4));
    say "Colors:          " ImgQueryImageInfo(curr_image, 5);
    say "Image Type:      " ImgQueryImageInfo(curr_image, 6);
    say "Bits per Pixel:  " ImgQueryImageInfo(curr_image, 7);
    say
    end

/* reduce colors to 256 before slicing; save as GIF          */
if ImgQueryImageInfo(curr_image, 5)>256 then do
    parms=DlgConvert8BitColor(0,1,2,256)
    call lineout logfile,"color conversion required: parms = "parms
    if parms\="" then interpret "rc=ImgConvert8BitColor("parms")"
    /* rc=ImgShowImage(curr_image) */
    newimage=newbase||"."
    /* call lineout logfile,"new file name" newimage */
    parms=DlgSaveImage(0,newimage,"GIF","LZW",TRUE)
    call lineout logfile,"save converted file: "parms
    if parms\="" then interpret "rc=ImgSaveImage("parms")"
    end /* do */
else say "no color conversion required"

/* generate slices from top left to down right               */
/* recalc image coordinates from os/2 style:                 */
/* lower left to upper right                                 */
/* impos pixel numbering starts at 0                         */
img_width=ImgQueryImageInfo(curr_image, 1)
img_height=ImgQueryImageInfo(curr_image, 2)
/* calculate resulting number of slices                      */
if img_width // slice_width=0 then xrounds=img_width % slice_width
    else xrounds=img_width % slice_width +1
if img_height // slice_height=0 then yrounds=img_height % slice_height
    else yrounds=img_height % slice_height +1
/* announce number of slices being generated                 */
say; say "slicing will produce" xrounds*yrounds "tiles sized" slice_width "x" slice_height "pixels"
rc=lineout(logfile,"slicing will produce" xrounds*yrounds "tiles sized" slice_width "x" slice_height "pixels")

/* create basic html page with table containg slices         */
if stream(newbase||"_table.htm","C","Query exists")\="" then call SysFileDelete(newbase||"_table.htm")
html=newbase||"_table.htm"
rc=lineout(html,"<HTML><HEAD><TITLE>Sliced Image" filename "in a Table</TITLE></HEAD><BODY BGCOLOR=WHITE>")
rc=lineout(html,"<CENTER><TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH="img_width">")

/* coordinates of top left image corner                      */
xstart=0
ystart=img_height-1

/* i is horizontal move   j is vertical move                 */
/* slice numbering is appended as "_ij.gif"                  */
do j=1 to yrounds
    call lineout html,"<TR>"    
    /* calculate y coordinates                               */    
    ystart=img_height-(j*slice_height)

    do i=1 to xrounds
        /* calculate x coordinates                           */
        xstart=(i-1)*slice_width
        call lineout logfile,"coordinates for slice" j||i "are" xstart ystart

        /* show image for control only; leaves open windows  */
        /* rc=ImgShowImage(curr_image) */
        rc=ImgSelectNone()
        rc=ImgSelectRectangle(curr_image,2,xstart,ystart,slice_width,slice_height)
        if rc\=0  then call lineout logfile,"select rectangle error code" rc

        rc=ImgCopyImage()
        pasted=ImgImageFromClipboard()
        if pasted==0 then do 
            say "image could not be generated"
            call lineout logfile,"image tile" j i "could not be generated"
            end 

        /*
        /* interactive save for slices                       */
        parms=DlgSaveImage(pasted,newbase||"_"||ij,"GIF","LZW",TRUE)
        call lineout logfile,"save slice #"j||i parms
        if parms\="" then interpret "rc=ImgSaveImage("parms")"
        */

        /* automated save for slices                         */    
        rc=ImgSaveImage(pasted,newbase||"_"||j||i||".GIF","GIF","LZW",TRUE)
        if rc\=0  then call lineout logfile,"autosave slice #"j||i rc

        /* write image-containing html tablecell             */
        call lineout html,'<TD><IMG SRC="./'||basename||"_"||j||i||'.GIF" WIDTH='ImgQueryImageInfo(pasted,1) 'HEIGHT='ImgQueryImageInfo(pasted,2)'></TD>'
    
        /* close used image slices & undo                    */
        rc=ImgCloseImage(pasted)
        if rc\=0  then call lineout logfile,"image close rc" rc
        rc=ImgUndo()
        if rc\=0  then call lineout logfile,"image undo rc" rc

    end /* do */
    call lineout html,"</TR>"    
end /* do */

rc=lineout(html,"</TABLE></CENTER>")
rc=lineout(html,"</BODY></HTML>")
rc=stream(html,"C","Close")

rc=ImgCloseAllImages()
/* call lineout logfile,"close all images" rc                */
/* ClosePgm doesn't seem to have any effect ?                */
rc=ImgClosePgm()


FINAL:
/* Schlussroutinen                                   */
rc=lineout(logfile,"WebSlice ended")
rc=stream(logfile,"C","close")
say " "
say "WebSlice ended"
exit



ERRFILE:
/* Error Routine                                         */
say " "
say "Please enter image file name including FULL path:"
say '1B'x||'[33;40m'||'1B'x||'[1;m'||'WebSlice X:\path\imagefile.typ'||'1B'x||'[37;40m'||'1B'x||'[1;m'
say ""
say "Optionally add tile dimensions in pixels:"
say '1B'x||'[33;40m'||'1B'x||'[1;m'||'WebSlice X:\path\imagefile.typ' '1B'x||'[36;40m'||'1B'x||'[1;m'||'slice_width slice_height'||'1B'x||'[37;40m'||'1B'x||'[1;m'
say ""
say "Default tile size is 200 x 150 pixel"
say ""
say; say "Program ended with error"
exit

/* Error Routinen nach Wolek p114                        */
SYNTAX:
say "Syntax- oder Laufzeitfehler in Zeile " sigl
say "Fehlercode: " rc
say "Fehlertext: " errortext(rc)
say ""
say "Text der Quellzeile :  >>> " sourceline(sigl) "<<<"
exit

NOVALUE:
say "Die Variable " condition("D") " in Zeile " sigl " ist nicht initialisiert"
say "Text der Quellzeile :  >>> " sourceline(sigl) "<<<"
exit

HALT:
say "soll die Prozedur beendet werden (j/n)? "
pull antw
if antw="j" then
    exit
else
    return

ERROR:
say "Unbekannter Befehl oder Argumentfehler in Zeile "sigl||":"
say "Komponente:" condition("D")
say ""
say "Text der Quellzeile :  >>> " sourceline(sigl) "<<<"
exit
/* Ende Error-Routinen nach Wolek                        */

