/*
 * llist.h -- External definitions for llist.c
 *
 */

#ifndef LLIST_H_INCLUDED
#define LLIST_H_INCLUDED

/* Generic list link field */

typedef struct llist_link   *   llist_link_p;
typedef struct llist_header *   llist_header_p;

typedef struct llist_link
  {
    llist_link_p prev, next;
  }
    llist_link;

typedef struct llist_header
  {
    llist_link_p first;
    llist_link_p last;
  }
    llist_header;

#define LLNext( x )           (void *)(((llist_link_p)(x))->next)
#define LLPrev( x )           (void *)(((llist_link_p)(x))->prev)
#define LLFirst( x )          (void *)(((llist_header_p)(x))->first)
#define LLLast( x )           (void *)(((llist_header_p)(x))->last)

#define LListRemoveFirst(x)   (void *)LListDelete(x,LLFirst(x))

extern void      LListNew( llist_header_p top );
extern void      LListPrefix( llist_header_p top, void * entry );
extern void      LListSuffix( llist_header_p top, void * entry );
extern void *    LListDelete( llist_header_p top, void * entry );
extern void      LListInsert( llist_header_p top, void * prev,
                              void * entry );
extern void      LListKill( llist_header_p top, void (*free)( void * ) );

#endif /* LLIST_H_INCLUDED */
