/*
 * stub.c -- Basically like stub.c in the pmexe\c directory, but
 *           registers a couple of external functions before
 *           starting the program.
 */

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define INCL_DOS
#define INCL_REXXSAA

#include <os2.h>
#include <rexxsaa.h>

#include "pmexe.h"

#define MAX_PATH 300

extern void UnscatWindows();

static BOOL ShowMessage( char *msg, BOOL askyesno );

extern ULONG APIENTRY RXScat();

/*
 * main -- The C runtime entry point, as usual...
 */

int main( int argc, char *argv[] )
  {
    HMODULE module;
    ULONG   version;

    /* Load the DLL... */

    module = PMExeLoadDLL();
    if( !module ){
        ShowMessage( "Could not find VROBJ.DLL.  Please ensure it is in the LIBPATH.",
                     FALSE );
        goto done;
    }

    /* Check the version... */

    version = PMExeVersion();
    if( version < 200 ){
        if( !ShowMessage( "This program requires VX-REXX version 2.0 or "
                          "higher to run.  Do you want to try running it "
                          "anyhow?", TRUE ) ){
            goto done;
        }
    }

    /* Run it... */

    RexxRegisterFunctionExe( "DoScat", (PFN) RXScat );

    PMExeRun( argc, argv );

    /* Deregister... */

    RexxDeregisterFunction( "DoScat" );
    UnscatWindows();

  done:
    return( 0 );
  }

/*
 * ShowMessage -- Create a message queue and put up a message
 *                box....
 */

static BOOL ShowMessage( char *str, BOOL askyesno )
  {
    HAB     hab;
    HMQ     hmq;
    PPIB    pib;
    PTIB    tib;
    PSZ     title;
    USHORT  retcode;
    char    path[ MAX_PATH + 1 ];

    hab = WinInitialize( 0 );
    hmq = WinCreateMsgQueue( hab, 0 );

    WinCancelShutdown( hmq, TRUE );

    DosGetInfoBlocks( &tib, &pib );
    DosQueryModuleName( pib->pib_hmte, MAX_PATH, path );

    if( strlen( path ) > 0 ){
        title = path + strlen( path );
        while( *(title-1) != '\\' ){
            --title;
        }
    } else {
        title = "VX-REXX Application";
    }

    retcode =  WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, str, title, 0,
                    askyesno ? (MB_QUERY|MB_YESNO) : (MB_ERROR|MB_OK) );

    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );

    return( retcode );
  }
