/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         digit_Click
*/
digit_Click:
    number = VRGet( VRInfo( "Object" ), "Caption" )
    call number_click number
return
/*:VRX         do_previous_operation
*/
do_previous_operation:

    /* Check for an error state */
    if( error_is_on = 1 ) then return

    /* Check if any numbers have been pressed */
    if( new_number = 0 )then do
        operand = arg( 1 )
        return
      end

    /* Get the current number on the screen */
    display_current = VRGet( 'dt_display', 'Caption' )

    /* Do the previous operation with the previous number */
    if( operand = '+' ) then
        display = display_previous + display_current
    else if( operand = '-' ) then
        display = display_previous - display_current
    else if( operand = '*' ) then
        display = display_previous * display_current
    else if( operand = '/' ) then do
        if( display_current = 0 ) then do           /* Divide by zero error */
            error_is_on = 1
            call update_memory_display 'e'
            display = 0
          end
        else
            display = display_previous / display_current
      end
    else
        display = display_current

    /* Update the operand */
    operand = arg( 1 )
    new_number = 0

    /* Update the display */
    display_previous = display
    start_new_display = 1
    call update_display

return
/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, 'Visible', '0'
    drop window
return 0
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    memory_total = 0
    call pb_c_Click

    window = VRWindow()
    call VRMethod window, 'CenterWindow'
    call VRSet window, 'Visible', '1'
    call VRMethod window, 'Activate'
    drop window
return


/*:VRX         number_click
*/
number_click:
    /* Check for an error state */
    if( error_is_on = 1 ) then
        return

    num = arg( 1 )
    new_number = 1

    if( start_new_display = 1 ) then do
        start_new_display = 0
        display = num

        if( num = '.' ) then  do    /* Check if the first character is a decimal */
            display ='0.'
            decimal_flag = 1
          end
        else
            decimal_flag = 0

        if( num = '0' ) then        /* Check if the first character is a zero */
            start_new_display = 1

        call update_display
        return
      end

    if( num = '.' ) then do
        decimal_flag = 1
        return
      end

    if( decimal_flag = 1) then
        display = display || num
    else do
        parse var display display'.'
        display = display || num || '.'
      end

    call update_display
return
/*:VRX         operator_Click
*/
operator_Click:
    handle = VRInfo( "Object" )
    if handle \= "" then do
        operator = VRGet( handle, "Caption" )
        call do_previous_operation operator
    end
return
/*:VRX         pb_c_Click
*/
pb_c_Click:
    display_previous = 0
    display_current = 0
    start_new_display = 1
    operand = ''
    display = 0
    decimal_flag = 0
    new_number = 1
    error_is_on = 0
    call update_display
    call update_memory_display memory_total
return
/*:VRX         pb_ce_Click
*/
pb_ce_Click:
    if( error_is_on = 1 ) then return
    display = 0
    start_new_display = 1
    call update_display
    new_number = 1
return
/*:VRX         pb_mc_Click
*/
pb_mc_Click:
    if( error_is_on = 1 ) then return
    memory_total = 0
    call update_memory_display memory_total
return
/*:VRX         pb_mminus_Click
*/
pb_mminus_Click:
    if( error_is_on = 1 ) then return
    memory_temp = VRGet( 'dt_display', 'Caption' )
    memory_total = memory_total - memory_temp
    call update_memory_display memory_total
    start_new_display = 1
return
/*:VRX         pb_mplus_Click
*/
pb_mplus_Click:
    if( error_is_on = 1 ) then return
    memory_temp = VRGet( 'dt_display', 'Caption' )
    memory_total = memory_total + memory_temp
    call update_memory_display memory_total
    start_new_display = 1
return
/*:VRX         pb_mr_Click
*/
pb_mr_Click:
    if( error_is_on = 1 ) then return
    display = memory_total
    call update_display
    start_new_display = 1
    new_number = 1
return
/*:VRX         pb_percent_Click
*/
pb_percent_Click:
    display = display / 100
    call update_display
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, 'Shutdown', '1'
    drop window
return
/*:VRX         update_display
*/
update_display:
    /* Update the display area */
    tmp = POS( 'E', display )
    parse var display whole'.'fraction             /* Split into whole and fraction */

    if( new_number = 0 ) then
        if( tmp = 0 ) then
            fraction = strip( fraction, 'T', 0 )   /* Strip the trailing zeros from the fraction */

    display = whole || '.' || fraction             /* Concatenate the whole and fraction */
    call VRSet 'dt_display', 'Caption', display
return
/*:VRX         update_memory_display
*/
update_memory_display:
    if( arg( 1 ) = 'e' ) then
        call VRSet 'dt_memory', 'caption', 'E'
    else if( arg( 1 ) = 0 ) then
        call VRSet 'dt_memory', 'caption', ''
    else
        call VRSet 'dt_memory', 'caption', 'M'
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return
