/*:VRX         Main
*/
Main:
    signal on halt

    parse arg SysType getFile getFileSize remoteFile

    if ( remoteFile = "" ) then do
        BaseText = 'call VRSet "MainWindow", "StatusText", "Getting ""' || getFile || '""'
        TextToSend = BaseText || '"'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
     end
    else do
        BaseText = 'call VRSet "MainWindow", "StatusText", "Getting ""' || remoteFile || '"" as ""' || getFile'""'
        TextToSend = BaseText || '"'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
    end

    /* Try for 20 seconds for the Remote thread to start the download.
     * So 20 seconds is the timeout. If a stream isn't established by then,
     * assume that some error occurred.
     */
    do i = 1 to 20
        if ( stream( getFile, 'c', 'query exist' ) = "" ) then
            call SysSleep 1
        else
            leave
    end

    if ( i < 20 ) then do
        NewSize = 0
        if ( SysType = 'VMS' ) | (SysType = 'VM' ) then 
            /* For VMS and VM systems, we don't get file size info in Bytes, just blocks */
            do forever
                NewSize = stream( getFile, 'c', 'query size' )
                rc = VRMethod( "Application", "PostQueue", 0, 1, BaseText  NewSize'"')
                call SysSleep 1
            end /* do */

        else
            do forever
                NewSize = stream( getFile, 'c', 'query size' )
                Percentage = NewSize / getFileSize * 100
                Percentage = format( Percentage, 3, 0 )
                if ( Percentage < 100 ) then do
                    TextToSend = BaseText  NewSize'/'getFileSize  '['Percentage '%]"'
                    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
                end
                call SysSleep 1
            end /* do */
 
exit

/*:VRX         Halt
*/
Halt:

exit

