/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then  do i = 1 to argCount
        InitArgs.i = arg( i + ArgOff )
    end
    drop calledAs argCount argOff 

/*  Load the windows
*/
    hEventQ = VRInit()
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Aliases_Close
*/
Aliases_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Aliases_Create
*/
Aliases_Create:
    Aliases = VRGetIni( "VxFTP", "Aliases", IniFile, "NoClose" )

    if ( Aliases = "" ) then 
        GAliases.0 = 0
    else do
       /* Create the GAliases. stem variable from the "Aliases" 
        * string for holding the Aliases.
        */
        i = 0
        do until Aliases = ""
            i = i + 1
            parse value Aliases with GAliases.i "}{" Aliases
        end
        GAliases.0 = i

       /* Build the Alias list in AliasName. for displaying the 
        * Aliases' names in the list box.
        */
        do i = 1 to GAliases.0
            parse value GAliases.i with AliasName.i "|" .
        end
        AliasName.0 = i

        rc = VRMethod( "LB_Aliases", "AddStringList", "AliasName."  )

        drop Aliases AliasName.
    end
    
    if ( GAliases.0 = 1 ) then
        rc = VRSet( "DT_AliasNumber", "Caption", "1 Alias" )
    else
        rc = VRSet( "DT_AliasNumber", "Caption", GAliases.0 "Aliases" )
return

/*:VRX         BasicErrMsg
*/
BasicErrMsg:
/* Easy way of showing simple error messages, thanks to VX-REXX's
 * ability to expand the dialog box to fit the message.
 */
    ErrMessage = arg(1)

    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), ErrMessage, "Error", ,
                     "Error", "Buttons.", OK, Cancel )
    drop ErrMessage
return

/*:VRX         Cache_Close
*/
Cache_Close: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window

return

/*:VRX         Cache_Create
*/
Cache_Create: 
    value = VRGetIni("VxFTP", "CacheSize", IniFile, "NoClose" )
    rc = VRSet( "SPIN_CacheSize", "Value", value )
    value = VRGetIni("VxFTP", "RefreshInterval", IniFile, "NoClose" )
    rc = VRSet( "SPIN_RefreshInterval", "Value", value )

    set = VRGetIni( "VxFTP", "UseCache", IniFile, "NoClose" )
    if (set = 1) then do
        rc = VRSet( "CB_Cache", "Set", 1 )
        rc = VRSet( "SPIN_CacheSize", "Enabled", 1 )
        rc = VRSet( "SPIN_RefreshInterval", "Enabled", 1 )
      end
    else do
        rc = VRSet( "CB_Cache", "Set", 0 )    
        rc = VRSet( "SPIN_CacheSize", "Enabled", 0 )
        rc = VRSet( "SPIN_RefreshInterval", "Enabled", 0 )
    end

    drop value
    call Cache_Init
return

/*:VRX         Cache_Init
*/
Cache_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         CachedDirs_Close
*/
CachedDirs_Close: 
    call CachedDirs_Fini
return

/*:VRX         CachedDirs_Create
*/
CachedDirs_Create: 
/* The Cache table is built by the remote thread (better response
 * to user if local thread doesn't have to manage it).
 */
    rc = VRMethod( "Application", "GetVar", "Table.Dir_Name." )
    rc = VRMethod( "DDCB_CachedDirs", "Reset" )
    rc = VRMethod( "DDCB_CachedDirs", "AddStringList", "Table.Dir_Name."  )
return

/*:VRX         CachedDirs_Fini
*/
CachedDirs_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         CB_Cache_Click
*/
CB_Cache_Click: 
    set = VRGet( "CB_Cache", "Set" )
    if (set = 1) then do
        rc = VRSetIni( "VxFTP", "UseCache", 1, IniFile, "NoClose" )
        rc = VRSet( "SPIN_CacheSize", "Enabled", 1 )
        rc = VRSet( "SPIN_RefreshInterval", "Enabled", 1 )
      end
    else do
        rc = VRSetIni( "VxFTP", "UseCache", 0, IniFile, "NoClose" )
        rc = VRSet( "SPIN_CacheSize", "Enabled", 0 )
        rc = VRSet( "SPIN_RefreshInterval", "Enabled", 0 )
    end

    drop set
return

/*:VRX         CB_Hints_Click
*/
CB_Hints_Click: 
    set = VRGet( "CB_Hints", "Set" )
    if ( set = 1 ) then do
        rc = VRSetIni( "VxFTP", "Hints", "1", IniFile, "NoClose" )
        rc = VRSet( "MainWindow", "ShowHints", 1 )
      end
    else do
        rc = VRSetIni( "VxFTP", "Hints", "0", IniFile, "NoClose" )
        rc = VRSet( "MainWindow", "ShowHints", 0 )
      end
return

/*:VRX         CB_IncludeDate_Click
*/
CB_IncludeDate_Click: 
    /* Reset the remote directory cache and reset file list
     */
    if ( ConnectedToHost = 'TRUE' ) then do
        call RefreshRemote
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call ResetFileList" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call AddFileInfo" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call PostRemoteFiles" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call SetupDirCacheTable" )
    end

    set = VRGet( "CB_IncludeDate", "Set" )

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    if ( set = 1 ) then do
        RemFileList = overlay( '1', RemFileList, 3 )
        rc = VRSetIni( "VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
     end
    else do
        RemFileList = overlay( '0', RemFileList, 3 )
        rc = VRSetIni( "VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
    end

    select
        when substr( RemFileList, 2, 2 ) = '00' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files" )
        when substr( RemFileList, 2, 2 ) = '10' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size" )
        when substr( RemFileList, 2, 2 ) = '01' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Date" )
        when substr( RemFileList, 2, 2 ) = '11' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size | Date" )
    end

    call FlushCacheList

    drop set
return

/*:VRX         CB_IncludeSize_Click
*/
CB_IncludeSize_Click: 
    /* Reset the remote directory cache and reset file list
     */
    if ( ConnectedToHost = 'TRUE' ) then do
        call RefreshRemote
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call ResetFileList" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call AddFileInfo" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call PostRemoteFiles" )
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call SetupDirCacheTable" )
    end

    set = VRGet( "CB_IncludeSize", "Set" )

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    if ( set = 1 ) then do
        RemFileList = overlay( '1', RemFileList, 2 )
        rc = VRSetIni( "VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
     end
    else do
        RemFileList = overlay( '0', RemFileList, 2 )
        rc = VRSetIni( "VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
    end

    select
        when substr( RemFileList, 2, 2 ) = '00' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files" )
        when substr( RemFileList, 2, 2 ) = '10' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size" )
        when substr( RemFileList, 2, 2 ) = '01' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Date" )
        when substr( RemFileList, 2, 2 ) = '11' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size | Date" )
    end

    call FlushCacheList

    drop set
return

/*:VRX         CB_NoLocalUpdate_Click
*/
CB_NoLocalUpdate_Click:
    set = VRGet( "CB_NoLocalUpdate", "Set" )
    if ( set = 1 ) then 
        rc = VRSetIni( "VxFTP", "NoLocalUpdate", "1", IniFile, "NoClose" )
    else 
        rc = VRSetIni( "VxFTP", "NoLocalUpdate", "0", IniFile, "NoClose" )

return

/*:VRX         CB_NoRemoteUpdate_Click
*/
CB_NoRemoteUpdate_Click:
    set = VRGet( "CB_NoRemoteUpdate", "Set" )
    if ( set = 1 ) then
        rc = VRSetIni( "VxFTP", "NoRemoteUpdate", "1", IniFile, "NoClose" )
    else 
        rc = VRSetIni( "VxFTP", "NoRemoteUpdate", "0", IniFile, "NoClose" )

return

/*:VRX         CB_ProgInd_Click
*/
CB_ProgInd_Click: 
    set = VRGet( "CB_ProgInd", "Set" )
    if ( set = 1 ) then
        rc = VRSetIni( "VxFTP", "ProgInd", "1", IniFile, "NoClose" )
    else
        rc = VRSetIni( "VxFTP", "ProgInd", "0", IniFile, "NoClose" )

    drop set
return

/*:VRX         CB_ReattemptLogin_Click
*/
CB_ReattemptLogin_Click: 
    set = VRGet( "CB_ReattemptLogin", "Set" )
    
    if (set = 1) then do
        rc = VRSet( "SPIN_RelogonSecs", "Enabled", 1 )
        rc = VRSetIni( "VxFTP", "UseTimer", 1, IniFile, "NoClose" )
      end
    else do
        rc = VRSet( "SPIN_RelogonSecs", "Enabled", 0 )
        rc = VRSetIni( "VxFTP", "UseTimer", 0, IniFile, "NoClose" )
        rc = VRSet( "TM_Relogin", "Enabled", 0 )
    end

    drop set

return

/*:VRX         CB_Viewer_Click
*/
CB_Viewer_Click:
    set = VRGet( "CB_Viewer", "Set" )
    if ( set = 1 ) then 
        rc = VRSetIni( "VxFTP", "EEditor", "1", IniFile, "NoClose" )
    else 
        rc = VRSetIni( "VxFTP", "EEditor", "0", IniFile, "NoClose" )

return

/*:VRX         CB_ZipConsole_Click
*/
CB_ZipConsole_Click: 
    set = VRGet( "CB_ZipConsole", "Set" )
    if ( set = 1 ) then
        rc = VRSetIni( "VxFTP", "ZipConsole", "1", IniFile, "NoClose" )
    else
        rc = VRSetIni( "VxFTP", "ZipConsole", "0", IniFile, "NoClose" )

return

/*:VRX         Clear_Local
*/
Clear_Local:
    /* This function is called when a Directory Change has
       occurred.
     */
    rc = VRMethod( "DDCB_Local_CWD", "Reset" )
    call RefreshLocal
return

/*:VRX         Clear_Remote
*/
Clear_Remote:
    /* This function is called when a Directory Change has
       occurred on the remote host.
     */
    rc = VRMethod( "DDCB_Remote_CWD", "Reset" )
    call RefreshRemote
return
/*:VRX         DDCB_Local_CWD_Click
*/
DDCB_Local_CWD_Click:
    /* Get the new directory and figure out what part of
       the current CWD it is. Then make a string (newPath) 
       that contains the path up to and including newDir.
     */
    selected = VRGet( "DDCB_Local_CWD", "Selected" )
    if (selected = 1) then
        return -1

    /* The stem variable localDirs. is not dropped in Set_DDCB_Local_CWD,
     * so we know localDirs.'s values and number of elements.
     */
    if selected = localDirs.0 then
        newPath = "\"
    else do
        newPath = ""
        do i = localDirs.0-1 to selected by -1
            newPath = newPath || "\" || localDirs.i
        end
    end

   /* Change to the new local directory   */
    if ( \ VRChDir( newPath ) ) then
        call BasicErrMsg "Cannot change to the directory specified."

    call Clear_Local
    call Set_DDCB_Local_CWD

    /* Disable the local directory lists while the directory listing
       is being compiled in the LocalDir thread.
     */
    call DisableLocalLists
    call Spawn_LocalDir
    call SetDriveInfoDisplay

    drop newPath
return

/*:VRX         DDCB_Remote_CWD_Click
*/
DDCB_Remote_CWD_Click:
    selected = VRGet( "DDCB_Remote_CWD", "Selected" )
    if (selected = 1) then
        return -1

    else do
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
            "call Remote_CWD_Click", "selectedDir", selected )
        if (rc = 1) then
            call DisableRemoteLists

    end /* end else */

    drop newDir
return

/*:VRX         DelAliasBtn_Click
*/
DelAliasBtn_Click:
    selectedAlias = VRGet( "LB_Aliases", "SelectedString" )
    if ( selectedAlias = "" )
        then return

    Found = 'false'
    do i = 1 to GAliases.0
        if ( Found = 'true' ) then do
            j = j + 1
            GAliases.j = GAliases.i
            iterate
        end

        parse value GAliases.i with AliasName "|" junk
        if ( AliasName = selectedAlias ) then do
            Found = 'true'
            j = i - 1
        end
    end

    if ( Found = 'true' ) then 
        GAliases.0 = j

    call UpdateAliases

    drop selectedAlias Found junk AliasName
return

/*:VRX         Directories_Close
*/
Directories_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Directories_Create
*/
Directories_Create:
    downloadDirectory = VRGetIni( "VxFTP", "DownloadDir", IniFile, "NoClose" )
    rc = VRSet( "EF_DownDir", "Value", downloadDirectory )
    drop downloadDirectory
return

/*:VRX         DisableLocalLists
*/
DisableLocalLists:
    /* Disable all local directory/file lists so that user
     * can't mess with 'em.
     */
    call VRSet "DDCB_Local_CWD", "Enabled", 0
    call VRSet "Local_Dir_Combo", "Enabled", 0
    call VRSet "Local_Files_List", "Enabled", 0
return

/*:VRX         DisableRemoteLists
*/
DisableRemoteLists:
    /* Disable all remote directory/file lists so that
     * user can't mess with 'em.
     */
    rc = VRSet( "DDCB_Remote_CWD", "Enabled", 0 )
    rc = VRSet( "Remote_Dir_Combo", "Enabled", 0 )
    rc = VRSet( "Remote_Files_List", "Enabled", 0 )        
return

/*:VRX         EditAliasBtn_Click
*/
EditAliasBtn_Click:
    /* Get all the data associated with the Alias that the User selected
     * and pass it to the AliasDE file
     */
    aliasSelected = VRGet( "LB_Aliases", "SelectedString" )

    do i = 1 to GAliases.0 
        parse value GAliases.i with AliasName "|" Rest

        if (AliasName \= aliasSelected) then 
            iterate

        else do
            parse value Rest with AliasHost "|" AliasLogin "|" AliasPasswd "|" AliasCWD "|" AliasHostOS
            values = AliasDE( VRWindow(), 'EDIT', AliasName, AliasHost, AliasLogin, AliasPasswd, AliasCWD, AliasHostOS )
            if ( values \= "" ) then do
                GAliases.i = values
                call UpdateAliases
            end /* if */
            leave     /* leave the loop because we're finished */
        end /* else */
    end /* do */

    drop values aliasSelected Rest
return

/*:VRX         EF_DownDir_Change
*/
EF_DownDir_Change:
    /* As user types in the directory, update the setting
     * in the vxftp.ini file
     */
    DownloadDirectory = VRGet( "EF_DownDir", "Value" )
    rc = VRSetIni( "VxFTP", "DownloadDir", DownloadDirectory, IniFile, "NoClose" )

return

/*:VRX         EF_Email_Change
*/
EF_Email_Change:
    /* As user types in his/her Email address, update the setting
     * in the vxftp.ini file
     */
    EmailAddress = VRGet( "EF_Email", "Value" )
    rc = VRSetIni( "VxFTP", "Email", EmailAddress, IniFile, "NoClose" )

return

/*:VRX         Email_Close
*/
Email_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Email_Create
*/
Email_Create:
    EmailAddress = VRGetIni( "VxFTP", "Email", IniFile, "NoClose" )
    if ( EmailAddress = "" ) then
        EmailAddress = 'os2-user@vxftp.org'

    rc = VRSet( "EF_Email", "Value", EmailAddress )
    drop EmailAddress
return

/*:VRX         EnableLocalLists
*/
EnableLocalLists:
    rc = VRSet( "DDCB_Local_CWD", "Enabled", 1 )
    rc = VRSet( "Local_Dir_Combo", "Enabled", 1 )
    rc = VRSet( "Local_Files_List", "Enabled", 1 )
return

/*:VRX         EnableRemoteLists
*/
EnableRemoteLists:
    rc = VRSet( "DDCB_Remote_CWD", "Enabled", 1 )
    rc = VRSet( "Remote_Dir_Combo", "Enabled", 1 )
    rc = VRSet( "Remote_Files_List", "Enabled", 1 )
return

/*:VRX         Filelists_Close
*/
Filelists_Close: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return

/*:VRX         Filelists_Create
*/
Filelists_Create: 
    if ( VRGetIni( "VxFTP", "NoRemoteUpdate", IniFile, "NoClose") = 1 ) then
        rc = VRSet( "CB_NoRemoteUpdate", "Set", 1 )
    else
        rc = VRSet( "CB_NoRemoteUpdate", "Set", 0 )

    if ( VRGetIni( "VxFTP", "NoLocalUpdate", IniFile, "NoClose") = 1 ) then
        rc = VRSet( "CB_NoLocalUpdate", "Set", 1 )
    else
        rc = VRSet( "CB_NoLocalUpdate", "Set", 0 )

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose")
    if ( left( RemFileList, 1 ) = 'L' ) then do
        rc = VRSet( "RB_Ls", "Set", 1 )
        rc = VRSet( "CB_IncludeSize", "Enabled", 0 )
        rc = VRSet( "CB_IncludeDate", "Enabled", 0 )
      end
    else do
        rc = VRSet( "RB_Dir", "Set", 1 )
        rc = VRSet( "CB_IncludeSize", "Enabled", 1 )
        rc = VRSet( "CB_IncludeDate", "Enabled", 1 )
    end

    
    if ( substr( RemFileList, 2, 1 ) = 1 ) then
        rc = VRSet( "CB_IncludeSize", "Set", 1 )
    else
        rc = VRSet( "CB_IncludeSize", "Set", 0 )

    if ( substr( RemFileList, 3, 1 ) = 1 ) then
        rc = VRSet( "CB_IncludeDate", "Set", 1 )
    else
        rc = VRSet( "CB_IncludeDate", "Set", 0 )

    select
        when right( RemFileList, 1 ) = 'A' then
            rc = VRSet( "RB_SortAscending", "Set", 1 )
        when right( RemFileList, 1 ) = 'N' then
            rc = VRSet( "RB_SortNone", "Set", 1 )
        when right( RemFileList, 1 ) = 'D' then
            rc = VRSet( "RB_SortDescending", "Set", 1 )
        otherwise
            RemFileList = overlay( 'N', RemFileList, 1 )
            rc = VRSet( "VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
            rc = VRSet( "RB_SortNone", "Set", 1 )
    end
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         FlushCacheList
*/
FlushCacheList: 
    rc = VRIsValidObject( "DDCB_CachedDirs" )
    if ( rc = 1 ) then do
        rc = VRMethod( "DDCB_CachedDirs", "Reset" )
        rc = VRSet( "DDCB_CachedDirs", "Value", ""  )
    end

return

/*:VRX         FTPErrMsg
*/
FTPErrMsg:
    FTPERRNO = VRInfo( "FTP_Errno" )

    select 
        when FTPERRNO = "FTPSERVICE" then
            errMsg = "Unknown FTP Service"
        when FTPERRNO = "FTPHOST" then
            errMsg = "Host" Host "unknown"
        when FTPERRNO = "FTPSOCKET" then
            errMsg = "Cannot obtain a TCP socket"
        when FTPERRNO = "FTPCONNECT" then
            errMsg = "Unable to connect to" Host
        when FTPERRNO = "FTPLOGIN" then
            errMsg = "Login on" Host "failed"
        when FTPERRNO = "FTPABORT" then
            errMsg = "Filed transfer aborted"
        when FTPERRNO = "FTPLOCALFILE" then
            errMsg = "Cannot open local file"
        when FTPERRNO = "FTPDATACONN" then
            errMsg = "Can't initialize data connection"
        when FTPERRNO = "FTPCOMMAND" then
            errMsg = "Command failed"
        otherwise
            errMsg = "Unknown error code" FTPERRNO
    end /* select */

    butts.0 = 1
    default = 1
    butts.default = "OK"
    msg.0 = 3
    msg.1 = ""
    msg.2 = errMsg
    msg.3 = ""
    rc = VRMessageStem( VRWindow(), "msg.", "FTP Error", ,
                        "errMsg", "butts.", default)
return

/*:VRX         Get_Button_Click
*/
Get_Button_Click:
    call MI_GetWithoutRename_Click

return
/*:VRX         GetComplete
*/
GetComplete:
    call XferComplete "Show"

    if ( VRGetIni( "VxFTP", "NoLocalUpdate", IniFile, "NoClose") = 0 ) then do
        call RefreshLocal
        call Spawn_LocalDir
    end
return

/*:VRX         GetLoginInfo
*/
GetLoginInfo: 
    rc = VRSet( "MainWindow", "StatusText", "" )
    if ( InitArgs.0 = 1 ) then do
        /* If user passed command-line arguments, parse and place them
         *  into the appropriate variables.
         */
        select
            when words( InitArgs.1 ) = 1 then do
                call BasicErrMsg "Invalid number of arguments:" InitArgs.1
                signal NoLogon
              end

            when words( InitArgs.1 ) = 2 then
                if translate( left( word( InitArgs.1, 2 ), 4) ) = "ANON" then do
                    Host = word( InitArgs.1, 1 )
                    Anon = "TRUE"
                    Passwd = VRGetIni( "VxFTP", "Email", IniFile, "NoClose" )
                    if ( Passwd = "" ) then
                        Passwd = "os2-user@vxftp.org"
                    rCWD = ""
                    SysType = "auto detect"
                  end
                else
                    call BasicErrMsg "Need password for login" word( InitArgs.1, 2 )

            when  words( InitArgs.1 ) = 3 then 
                if translate( left( word( InitArgs.1, 2 ), 4) ) = "ANON" then do
                    Host =    word( InitArgs.1, 1 )
                    Anon =    "TRUE"
                    Login =   "Anonymous"
                    Passwd = word( InitArgs.1, 3 )
                    rCWD = ""
                    SysType = "auto detect"
                  end
                else do
                    Host =    word( InitArgs.1, 1 )
                    Anon =    "FALSE"
                    Login =   word( InitArgs.1, 2)
                    Passwd = word( InitArgs.1, 3 )
                    rCWD = ""
                    SysType = "auto detect"
                  end
                
            when  words( InitArgs.1 ) = 4 then 
                if translate( left( word( InitArgs.1, 2 ), 4) ) = "ANON" then do
                    Host =    word( InitArgs.1, 1 )
                    Anon =    "TRUE"
                    Login =   "Anonymous"
                    Passwd = word( InitArgs.1, 3 )
                    rCWD =   word( InitArgs.1, 4 )
                    SysType = "auto detect"
                  end
                else do
                    Host =    word( InitArgs.1, 1 )
                    Anon =    "FALSE"
                    Login =   word( InitArgs.1, 2 )
                    Passwd = word( InitArgs.1, 3 )
                    rCWD =   word( InitArgs.1, 4 )
                    SysType = "auto detect"
                  end

            when words( InitArgs.1 ) > 4 then do
                call BasicErrMsg "Too many command-line parameters"
                signal NoLogon
              end

            otherwise
                call BasicErrMsg "Invalid InitArgs.1 value"
                signal NoLogon

        end /* select */

        /* Zero-ize the InitArgs so that if user chooses "New Connection" from the
            menu, s/he won't automatically login to the host s/he indicated on the
            command line.
         */
        InitArgs.0 = 0
    end /* if */
    else do
        /* Call the Login() window, passing it this window's ID. 
            Parse out the desired data (Host, Login, and Passwd) in "values".
         */
        values = Login( VRWindow() )

        if (values <> "") then
            parse var values Host "|" Login "|" Passwd "|" rCWD "|" Anon "|" SysType
        else do
            call LogoffSuccessful
            signal NoLogon
          end /* else */
    end

    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call LogonToHost" ,,
                        "Host", Host, "Login", Login, "Passwd", Passwd,,
                        "rCWD", rCWD, "Anon", Anon, "SysType", SysType )
    if ( rc = 1 ) then do
        call VRSet "MainWindow", "Caption", VxFTPVersion "- Connecting to" Host, ,
            "StatusText", "Connecting to" Host 
        rc = VRSet( "MI_New",  "Enabled", 0 )
        rc = VRSet( "MI_Kill", "Enabled", 1 )
      end
    else
        call BasicErrMsg "Could not communicate login info to Remote thread."

NoLogon:

return

/*:VRX         Halt
*/
Halt:
    call VRMethod "Application", "PostQueue", RemoteTID, 0, ,
         "signal _VREHalt"

    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()

    /* Get the location of the VXFTP.INI file and put it in 
     * a variable accessible by both threads
     */
    IniFile = VRParseFileName("vxftp.ini", "")
    rc = VRMethod( "Application", "PutVar", "IniFile" )

    /* Start the thread that'll manage the remote side then
     * setup the local environment
     */
    call SetupRemote
    call InitializeLocalEnv


    /* Once we've setup the user interface, make the
     * window visible and respond to user commands
     */
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

return

/*:VRX         InitializeLocalEnv
*/
InitializeLocalEnv:
/* Set up the Local Environment.
 * This REXX code executes surprisingly fast, IMO.
 */
    if RxFuncQuery("SysLoadFuncs") then
        do
        rc = RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
        rc = SysLoadFuncs()
    end

    /* Initialize certain variables and conditions
     */
    VxFTPVersion = "VxFTP v1.00"
    rc = VRSet( "MainWindow", "Caption", VxFTPVersion "- Not Connected" )
    rc = VRRedirectStdIO("Off")
    ConnectedToHost = 'FALSE'
    LoginAttemptCount = 0

    DownloadDirectory = VRGetIni( "VxFTP", "DownloadDir", IniFile )
    if ( DownloadDirectory <> "" ) then do
        if ( substr( DownloadDirectory, 2, 1 ) = ":" ) then
            rc = VRChDrive( left( DownloadDirectory, 2 ))
        rc = VRChDir( DownloadDirectory )
        if ( rc = 0 ) then
            call BasicErrMsg "Couldn't change to" DownloadDirectory
    end

    /* Spawn thread to read in contents of local directory
     */
    call Spawn_LocalDir
    call SetDriveInfoDisplay
    call Set_DDCB_Local_CWD

    /* Find out the local drives, and put each one, (format C:)
     * in the stem Drives., which will then be used in each
     * local directory listing.
     */
    usedDrives = SysDriveMap("c:", 'used')
    i = 1
    do while ( wordlength( usedDrives,i ) > 0 )
        LocalDrives.i = "[Drive" word(usedDrives,i) || "]"
        i = i+1;
    end
    LocalDrives.0 = i-1

    /* Check whether VXFTP.INI entries are blank. If so, give them
     * default values.
     */
    if ( VRGetIni( "VxFTP", "NoRemoteUpdate", IniFile, "NoClose" ) = "" ) then 
        rc = VRSetIni( "VxFTP", "NoRemoteUpdate", "0", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "NoLocalUpdate", IniFile, "NoClose" ) = "" ) then 
        rc = VRSetIni( "VxFTP", "NoLocalUpdate", "0", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "EEditor", IniFile, "NoClose" ) = "" ) then
        rc = VRSetIni( "VxFTP", "EEditor", "0", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = "" ) then 
        rc = VRSetIni( "VxFTP", "UnzipPgm", "InfoZip", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "ZipConsole", IniFile, "NoClose" ) = "" ) then 
        rc = VRSetIni( "VxFTP", "ZipConsole", "0", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "SubDir", IniFile, "NoClose" ) = "" ) then 
        rc = VRSetIni( "VxFTP", "SubDir", "Prompt", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "Hints", IniFile, "NoClose" ) = "" ) then
        rc = VRSetIni( "VxFTP", "Hints", "1", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "Hints", IniFile, "NoClose" ) = "1" ) then
        rc = VRSet( "MainWindow", "ShowHints", 1 )
    else
        rc = VRSet( "MainWindow", "ShowHints", 0 )

    if ( VRGetIni( "VxFTP", "ProgInd", IniFile, "NoClose" ) = "" ) then
        rc = VRSetIni( "VxFTP", "ProgInd", "1", IniFile, "NoClose" )

    if ( VRGetIni( "VxFTP", "UseTimer", IniFile, "NoClose" ) = "" ) then
        rc = VRSetIni( "VxFTP", "UseTimer", "0", IniFile, "NoClose" )

    ReLoginDelay = VRGetIni( "VxFTP", "ReLoginDelay", IniFile, "NoClose" )
    if ( ReLoginDelay = "" ) then do
        rc = VRSetIni( "VxFTP", "ReLoginDelay", "15", IniFile, "NoClose" )
        rc = VRSet( "TM_Relogin", "Delay", 15000 )
      end
    else 
        rc = VRSet( "TM_Relogin", "Delay", ReLoginDelay * 1000 )


    if ( VRGetIni( "VxFTP", "UseCache", IniFile, "NoClose" ) = "" ) then do
        rc = VRSetIni( "VxFTP", "UseCache", "1", IniFile, "NoClose" )
        rc = VRSetIni( "VxFTP", "CacheSize", "10", IniFile, "NoClose" )
        rc = VRSetIni( "VxFTP", "RefreshInterval", "30", IniFile, "NoClose" )
    end 

    /* "RemFileList" contains the settings for the behavior and style of the
     * Remote_Files_List box. 
     *
     *  Position      Description
     *  --------      --------------------------------------------
     *     1          D - use 'DIR' style directory listings
     *                L - use 'LS' style
     *     2          0 - do not include file size information
     *                1 - include file size info
     *     3          0 - do not include file date information
     *                1 - include file date info
     *     4          N - No sorting on list
     *                A - Ascending sort on list
     *                D - Descending sort on list
     */
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    if ( RemFileList = "" ) then 
        rc = VRSetIni( "VxFTP", "RemFileList", "D00N", IniFile, "NoClose" )

    if ( left( RemFileList, 1 ) = 'L' ) then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files & Dirs" )
    else
        select
            when ( substr( RemFileList, 2, 2 ) = '10' ) then
                rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size" )

            when ( substr( RemFileList, 2, 2 ) = '01' ) then
                rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Date" )

            when ( substr( RemFileList, 2, 2 ) = '11' ) then
                rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size | Date" )
            otherwise
                nop
        end 

    select
        when ( right( RemFileList, 1 ) = 'A' ) then
            rc = VRSet( "Remote_Files_List", "Sort", "Ascending" )
        when ( right( RemFileList, 1 ) = 'D' ) then
            rc = VRSet( "Remote_Files_List", "Sort", "Descending" )
        otherwise
            rc = VRSet( "Remote_Files_List", "Sort", "None" )
    end

    select
        when ( VRGetIni( "VxFTP", "XferType", IniFile, "NoClose" ) = "" ) then do
            rc = VRSetIni( "VxFTP", "XferType", "Binary", IniFile, "NoClose" )
            call MI_Binary_Click
          end
        when ( VRGetIni( "VxFTP", "XferType", IniFile, "NoClose" ) = "Ascii" ) then 
            call MI_Ascii_Click
        otherwise
            call MI_Binary_Click
    end

    WinState = VRGetIni( "VxFTP", "WinState", IniFile, "NoClose" )
    select
        when ( WinState = "Normal" ) then do
            lastWidth = VRGetIni( "VxFTP", "Width", IniFile, "NoClose" )
            lastHeight = VRGetIni( "VxFTP", "Height", IniFile, "NoClose" )
            lastTop = VRGetIni( "VxFTP", "Top", IniFile, "NoClose" )
            lastLeft = VRGetIni( "VxFTP", "Left", IniFile, "NoClose" )
            call VRSet window, "Width", lastWidth
            call VRSet window, "Height", lastHeight
            call VRSet window, "Top", lastTop
            call VRSet window, "Left", lastLeft
         end

        when ( WinState = "Maximized" ) then
            call VRSet window, "WindowState", "Maximized"

        otherwise
            rc = VRSetIni( "VxFTP", "WinState", "Normal", IniFile, "NoClose" )
            lastwidth = VRGet( window, "InteriorWidth" )
            lastheight = VRGet( window, "InteriorHeight" )

    end /* select */

    /* Extract the Fonts saved from the last session, even though
     * only the file lists will actually return their font info.
     * Keep the code in case a future version of VXREXX will correctly
     * deal with font info.
     */
    SavedFonts = VRGetIni( "VxFTP", "ListFonts", IniFile, "NoClose" )
    parse value SavedFonts with font1 "|" font2 "|" font3 "|" font4 "|" font5 "|" font6
    rc = VRSet( "Local_Files_List",  "Font", font1 )
    rc = VRSet( "Local_Dir_Combo",   "Font", font2 )
    rc = VRSet( "DDCB_Local_CWD",    "Font", font3 )
    rc = VRSet( "Remote_Files_List", "Font", font4 )
    rc = VRSet( "Remote_Dir_Combo",  "Font", font5 )
    rc = VRSet( "DDCB_Remote_CWD",   "Font", font6 )
    
    
    /* The following variables are for determining the position and size
     * of the various GUI elements on the MainWindow
     */
    staticWidth = 1430
    gutter = 948
    leftMargin = 241
    bottomMargin = 211
    DirListMargin = 842
    btnMargin = 105
    GrpBox.outermgn = 120
    GrpBox.midmgn = 106

    /* Now that everything has been set, call the Resize function      */
    call MainWindow_Resize

    drop i RSortOrder SavedFonts
return

/*:VRX         LB_Aliases_DoubleClick
*/
LB_Aliases_DoubleClick:
    call EditAliasBtn_Click
return

/*:VRX         Local_Dir_Combo_ContextMenu
*/
Local_Dir_Combo_ContextMenu:
   rc = VRMethod("MI_PopupLDir", "Popup")

return

/*:VRX         Local_Dir_Combo_DoubleClick
*/
Local_Dir_Combo_DoubleClick:
    newDir= VRGet( "Local_Dir_Combo", "Value" )

    if ( newDir = "" ) then
        signal ENDLocal_Dir_Combo_DClick

    if ( left(newDir, 6) = "[Drive") then do
        rc = VRChDrive( substr(newDir, 8,1) ) 
        call SetDriveInfoDisplay
    end
    else do
        rc = VRChDir( newDir )
        if (rc = 0) then do
            call BasicErrMsg "Couldn't change to directory specified"
            signal ENDLocal_Dir_Combo_DClick
        end
    end

    call Clear_Local
    call Set_DDCB_Local_CWD    

    /* Disable the Local Directory fields while you're filling
       the local directory and file lists.
     */
    call DisableLocalLists
    call Spawn_LocalDir

ENDLocal_Dir_Combo_DClick:
    drop newDir
return

/*:VRX         Local_Files_List_ContextMenu
*/
Local_Files_List_ContextMenu:
    rc = VRMethod("MI_PopupLFiles", "Popup")
return

/*:VRX         Local_Files_List_DoubleClick
*/
Local_Files_List_DoubleClick:
    call Put_Button_Click
return

/*:VRX         LoginAttemptFailed
*/
LoginAttemptFailed: 
    call LogoffSuccessful

    UseTimer = VRGetIni( "VxFTP", "UseTimer", IniFile, "NoClose" )
    if ( UseTimer = 1 ) then do
        rc = VRSet( "TM_Relogin", "Enabled", 1 )
        LoginAttemptCount = LoginAttemptCount + 1
        TextToSend = 'Login attempt' LoginAttemptCount 'failed'
        rc = VRSet( "MainWindow", "StatusText", TextToSend )
    end

return

/*:VRX         LogoffSuccessful
*/
LogoffSuccessful:
    call Clear_Remote
    rc = VRSet( "DDCB_Remote_CWD", "Value", "" )
    call DisableRemoteLists

    rc = VRSet( "MI_New",              "Enabled", 1 )   
    rc = VRSet( "MI_Close",            "Enabled", 0 )
    rc = VRSet( "MI_Kill",             "Enabled", 0 )
    rc = VRSet( "MI_ASCII",            "Enabled", 0 )
    rc = VRSet( "MI_Xfer_Type",        "Enabled", 0 )
    rc = VRSet( "MI_Binary",           "Enabled", 0 )
    rc = VRSet( "Get_Button",          "Enabled", 0 )
    rc = VRSet( "Put_Button",          "Enabled", 0 )
    rc = VRSet( "MI_Remote",           "Enabled", 0 )
    rc = VRSet( "MI_LPut",             "Enabled", 0 )
    rc = VRSet( "MI_PopupPut",         "Enabled", 0 )

    rc = VRSet( "MainWindow", "Caption", VxFTPVersion "- Not Connected" )

    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )

    call FlushCacheList
    ConnectedToHost = 'FALSE'

    remote_dir.0 = 0
    remote_file.0 = 0

return

/*:VRX         LogonSuccessful
*/
LogonSuccessful:

    rc = VRSet( "MainWindow", "Caption", VxFTPVersion "-" Host )
    ConnectedToHost = 'TRUE'

    rc = VRSet( "Get_Button",          "Enabled", 1 )
    rc = VRSet( "Put_Button",          "Enabled", 1 )
    rc = VRSet( "MI_New",              "Enabled", 0 )
    rc = VRSet( "MI_Close",            "Enabled", 1 )
    rc = VRSet( "MI_Kill",             "Enabled", 1 )
    rc = VRSet( "MI_ASCII",            "Enabled", 1 )
    rc = VRSet( "MI_Xfer_Type",        "Enabled", 1 )
    rc = VRSet( "MI_Binary",           "Enabled", 1 )
    rc = VRSet( "MI_Remote",           "Enabled", 1 )
    rc = VRSet( "MI_LPut",             "Enabled", 1 )
    rc = VRSet( "MI_PopupPut",         "Enabled", 1 )

    /* Disable ReLogin timer               */
    rc = VRSet( "TM_Relogin", "Enabled", 0 )

return


/*:VRX         MainWindow_Close
*/
MainWindow_Close:
    call Quit
return

/*:VRX         MainWindow_Resize
*/
MainWindow_Resize:
    /* Don't resize if the MainWindow was minimized
     */
    WindowState = VRGet( "MainWindow", "WindowState" )
    if ( WindowState = 'Minimized' ) then 
       return -1

    /* Resize and reposition the elements on the MainWindow,
     * according to the size the user changed it to.
     */
    window = VRWindow()
    width = VRGet( window, "InteriorWidth" )
    height = VRGet( window, "InteriorHeight" )

    /* If the height and width are the same as last time this
     * stupid function was called, then don't resize
     */
    if ( lastHeight = height ) & ( lastWidth = width ) then 
        return -1
    else do
        lastHeight = height
        lastWidth = width
    end

    /* If user makes the MainWindow too small, calculate for
     * a window that's 3750x8000
     */
    if (height < 3750) then height = 3750
    if (width < 8000) then width = 8000

    /* Do all the size and position calculations
     */
    /* These variables are declared in InitializeLocalEnv
     *          staticWidth = 1430
     *          gutter = 948
     *          leftMargin = 241
     *          bottomMargin = 211
     *          DirListMargin = 842
     *          btnMargin = 105
     *          GrpBox.outermgn = 120
     *          GrpBox.midmgn = 106
     */
    GrpBoxWidth = trunc( ( width - staticWidth ) / 2)
    GrpBoxHeight = height - bottomMargin
    GB2_NewLeft = leftMargin + gutter + GrpBoxWidth
    Btn_NewLeft = leftMargin + GrpBoxWidth + btnMargin
    DirWidth = VRGet( "Local_Dir_Combo", "Width" )
    FileWidth = VRGet( "Local_Files_List", "Width" )
    GrpBox.change = GrpBoxWidth - 346 - DirWidth - FileWidth
    DirWidth = trunc( DirWidth + (0.25 * GrpBox.change))
    DirHeight = GrpBoxHeight - 1806
    FileWidth = trunc( FileWidth + (0.75 * GrpBox.change))
    LFileLeft = 226 + DirWidth
    FileHeight = GrpBoxHeight - 602
    RDirLeft = 226 + FileWidth

    /* Make everything Invisible        */
    rc = VRSet( "GB_1", "Visible", 0 )
    rc = VRSet( "Get_Button", "Visible", 0 )
    rc = VRSet( "Put_Button", "Visible", 0 )
    rc = VRSet( "DT_XferType", "Visible", 0 )
    rc = VRSet( "GB_2", "Visible", 0 )

    /* Move the Group Boxes                              */
    rc = VRSet( "GB_2", "Left", GB2_NewLeft )
    rc = VRSet( "GB_1", "Width", GrpBoxWidth )
    rc = VRSet( "GB_2", "Width", GrpBoxWidth )
    rc = VRSet( "GB_1", "Height", GrpBoxHeight )
    rc = VRSet( "GB_2", "Height", GrpBoxHeight )
    rc = VRSet( "DT_XferType", "Left", Btn_NewLeft )
    rc = VRSet( "Get_Button", "Left", Btn_NewLeft )
    rc = VRSet( "Put_Button", "Left", Btn_NewLeft )

    /* Move the Local stuff                              */
    rc = VRSet( "Local_Files_List", "Left", LFileLeft )
    rc = VRSet( "DT_LocalFiles", "Left", LFileLeft )
    rc = VRSet( "DDCB_Local_CWD", "Width", DirWidth )
    rc = VRSet( "Local_Dir_Combo", "Width", DirWidth )
    rc = VRSet( "Local_Files_List", "Width", FileWidth )
    rc = VRSet( "Local_Dir_Combo", "Height", DirHeight )
    rc = VRSet( "Local_Files_List", "Height", FileHeight )
    rc = VRSet( "DT_LocalDrive", "Top", DirHeight + 1189 )
    rc = VRSet( "DT_LocalDir", "Width", DirWidth )
    rc = VRSet( "DT_LocalFiles", "Width", FileWidth )

    /* Move the remote stuff                           */
    rc = VRSet( "DDCB_Remote_CWD", "Left", RDirLeft )
    rc = VRSet( "Remote_Dir_Combo", "Left", RDirLeft )
    rc = VRSet( "DT_RemoteDir", "Left", RDirLeft )
    rc = VRSet( "DT_RFileInfo", "Left", RDirLeft )
    rc = VRSet( "DDCB_Remote_CWD", "Width", DirWidth )
    rc = VRSet( "Remote_Dir_Combo", "Width", DirWidth )
    rc = VRSet( "Remote_Dir_Combo", "Height", DirHeight )
    rc = VRSet( "Remote_Files_List", "Width", FileWidth )
    rc = VRSet( "Remote_Files_List", "Height", FileHeight )
    rc = VRSet( "DT_RemoteFiles", "Width", FileWidth )
    rc = VRSet( "DT_RemoteDir", "Width", DirWidth )
    rc = VRSet( "DT_RFileInfo", "Top", DirHeight + 949 )
    rc = VRSet( "DT_RFileInfo", "Width", DirWidth )

    /* make the Elements visible                    */
    rc = VRSet( "GB_1", "Visible", 1 )
    rc = VRSet( "DT_XferType", "Visible", 1 )
    rc = VRSet( "Get_Button", "Visible", 1 )
    rc = VRSet( "Put_Button", "Visible", 1 )
    rc = VRSet( "GB_2", "Visible", 1 )

return

/*:VRX         MI_ASCII_Click
*/
MI_ASCII_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call SetAscii")
    rc = VRSet( "DT_XferType", "Caption", "ASCII" )
    rc = VRSet( "MI_Binary", "Checked", 0 )
    rc = VRSet( "MI_ASCII", "Checked", 1 )
    rc = VRSetIni( "VxFTP", "XferType", "Ascii", IniFile, "NoClose" )
return

/*:VRX         MI_Binary_Click
*/
MI_Binary_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call SetBinary")
    rc = VRSet( "DT_XferType", "Caption", "Binary" )
    rc = VRSet( "MI_Binary", "Checked", 1 )
    rc = VRSet( "MI_ASCII", "Checked", 0 )
    rc = VRSetIni( "VxFTP", "XferType", "Binary", IniFile, "NoClose" )
return

/*:VRX         MI_Close_Click
*/
MI_Close_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call FTP_Logoff")
    if (rc = 0) then
        call BasicErrMsg "Could not log off. Remote thread is hung."

return

/*:VRX         MI_GetWithoutRename_Click
*/
MI_GetWithoutRename_Click:
    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", ,
         "getFiles." )

    if (getFiles.0 = 0) then do
        getFiles.1  = PromptDlg( "Get File", "Enter the remote file name" )
        if ( getFiles.1 = "" ) then
            return -1
        else
            getFiles.0 = 1
    end

    do i = 1 to getFiles.0
        parse value getFiles.i with getFiles.i "|" .
        getFiles.i = strip( getFiles.i )
    end

    rc = VRMethod( "Application", "PutVar", "getFiles." )

    /* Get the file size of the file(s) selected and send that to
     * the remote thread too.
     */
    rc = VRMethod( "Application", "GetVar", "remote_size." )

    do i = 1 to getFiles.0
        do j = 1 to remote_file.0
            if ( getFiles.i == word(remote_file.j, 1) ) then do
                getFilesSize.i = remote_size.j
                leave
           end
        end
    end /* do */
    getFilesSize.0 = getFiles.0
    rc = VRMethod( "Application", "PutVar", "getFilesSize." )


    call XferInProgress                   /* Disable interface objects */

    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call GetFilesNoRename" )

return

/*:VRX         MI_GetWithRename_Click
*/
MI_GetWithRename_Click:
    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", ,
         "getFiles." )

    if (getFiles.0 = 0) then do
        getFiles.1  = PromptDlg( "Get File", "Enter the remote file name" )
        if ( getFiles.1 = "" ) then
            return -1
        else
            getFiles.0 = 1
    end

    do i = 1 to getFiles.0
        parse value getFiles.i with getFiles.i "|" .
        getFiles.i = strip( getFiles.i )
    end

    rc = VRMethod( "Application", "PutVar", "getFiles." )

    /* Get the file size of the file(s) selected and send that to
     * the remote thread too.
     */
    rc = VRMethod( "Application", "GetVar", "remote_size." )

    do i = 1 to getFiles.0
        do j = 1 to remote_file.0
            if ( getFiles.i == word(remote_file.j, 1) ) then do
                getFilesSize.i = remote_size.j
                leave
           end
        end
    end /* do */
    getFilesSize.0 = getFiles.0
    rc = VRMethod( "Application", "PutVar", "getFilesSize." )

    call XferInProgress               /* Disable interface objects */

    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call GetFilesRenamed" )    
return

/*:VRX         MI_Kill_Click
*/
MI_Kill_Click: 
    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), "Kill current connection?",, "Question", ,
                    "Buttons.", OK, Cancel )
    if id = 1 then do
        rc = VRMethod( "Application", "ListThreads", "T_IDs." )
        do j = T_IDs.0 to 2 by -1
            rc = VRMethod( "Application", "HaltThread", T_IDs.j )
        end /* do */

        call LogoffSuccessful
        call SetupRemote
    end

    drop Buttons. OK Cancel
return

/*:VRX         MI_LChDir_Click
*/
MI_LChDir_Click:
    if ( VRGet( "Local_Dir_Combo", "SelectedString" ) = "" ) then do

        value = PromptDlg( "Change Local Directory", "Enter new directory" )

        if ( value <> "" ) then do
            if (substr(value, 2, 1) = ":") then do
                rc = VRChDrive( left(value, 1) )
                length1 = length(value)
                value = right(value, length1 - 2)
            end /* if substr */

            rc = VRChDir(value)
            if (rc = 0) then
                call BasicErrMsg VRError()

            else do
                call Clear_Local
                call Set_DDCB_Local_CWD
                /* Disable the local directory lists while the directory listing
                 * is being compiled.
                 */
                call DisableLocalLists
                call Spawn_LocalDir
            end
        end
        drop value length1

    end /* if */
    else
        call Local_Dir_Combo_DoubleClick

return

/*:VRX         MI_LCopy_Click
*/
MI_LCopy_Click:
    /* Copy local file(s)
     */
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "copyFiles." )

    if (copyFiles.0 = 0) then do
        copyFiles.1 = PromptDlg( "Copy File", "Enter name of file to copy" )
        if ( copyFiles.1 = "" ) then
            signal ENDMI_LCopy_Click
        else
            copyFiles.0 = 1
    end

    do i = 1 to copyFiles.0
        NewFile = PromptDlg("Copy to", "Enter name and/or path to copy to:" )

        if ( NewFile = "" ) then
            iterate
        rc = VRCopyFile( copyFiles.i, NewFile )
        if ( rc = 0 ) then do
            call BasicErrMsg  VRError()
            iterate
        end /* if */
    end /* do */

    call RefreshLocal
    call Spawn_LocalDir

ENDMI_LCopy_Click:
    drop NewFile
return

/*:VRX         MI_LDel_Click
*/
MI_LDel_Click:
    /* Delete local file(s)
     */
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "deleteFiles." )

    if (deleteFiles.0 = 0) then do
        deleteFiles.1 = PromptDlg( "Delete File", "Enter name of file to delete" )
        if ( deleteFiles.1 = "" ) then
            return -1
        else
            deleteFiles.0 = 1
    end

    do i = 1 to deleteFiles.0
        rc = VRDeleteFile( deleteFiles.i )
        if ( rc = 0 ) then do
            call BasicErrMsg  VRError()
            iterate
        end /* if */
    end /* do */

    call RefreshLocal
    call Spawn_LocalDir
    
return

/*:VRX         MI_LMkDir_Click
*/
MI_LMkDir_Click:
    value = PromptDlg( "Make Local Directory", "Enter directory to create" )

    if ( value <> "" ) then do
        rc = VRMkDir( value )
        if (rc = 0) then
            call BasicErrMsg VRError()

        else do
            call RefreshLocal
            call Spawn_LocalDir
        end
    end /* end if */

    drop value
return

/*:VRX         MI_LPut_Click
*/
MI_LPut_Click:
    enabled = VRGet( "Put_Button", "Enabled" )
    if ( enabled = 1 ) then
        call Put_Button_Click
return

/*:VRX         MI_LRefreshLists_Click
*/
MI_LRefreshLists_Click: 
    call Clear_Local

    /* Disable the Local Directory fields while you're filling
       the local directory and file lists.
     */
    call DisableLocalLists
    call Spawn_LocalDir

return

/*:VRX         MI_LRen_Click
*/
MI_LRen_Click:
    /* Rename local file(s)
     */
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "renameFiles." )

    if (renameFiles.0 = 0) then do
        renameFiles.1 = PromptDlg( "Rename File", "Enter file to rename" )
        if ( renameFiles.1 = "" ) then
            return -1
        else
            renameFiles.0 = 1
    end

    DoRefresh = 'FALSE'
    do i = 1 to renameFiles.0
        RenamedFile = PromptDlg( "Rename Local File", ,
                                 "Rename" renameFiles.i, ,
                                 renameFiles.i )

        if ( RenamedFile = "") then
            iterate
        else
            DoRefresh = 'TRUE'

        rc = VRRenameFile( renameFiles.i, RenamedFile )
        if ( rc = 0 ) then do
            call BasicErrMsg  VRError()
            iterate
        end /* if */
    end /* do */

    if ( DoRefresh = 'TRUE' ) then do
        call RefreshLocal
        call Spawn_LocalDir
    end
return

/*:VRX         MI_LRmDir_Click
*/
MI_LRmDir_Click:
    value = VRGet( "Local_Dir_Combo", "Value" )

    if (value <> "") then do
        rc = VRRmDir( value )
        if (rc = 0) then
            call BasicErrMsg VRError()

        else do
            call RefreshLocal
            call Spawn_LocalDir
        end
    end
    else do
        value = PromptDlg( "Remove Local Directory", "Enter directory to delete" )

        if (value <> "") then do
            rc = VRRmDir( value )
            if (rc = 0) then
                call BasicErrMsg VRError()

            else do
                call RefreshLocal
                call Spawn_LocalDir
            end /* else */
        end /* if */
    end /* else */

    drop value

return

/*:VRX         MI_LUnzip_Click
*/
MI_LUnzip_Click:
return

/*:VRX         MI_LView_Click
*/
MI_LView_Click:
    /* Download the selected files for viewing.
     */
    selected = VRGet( "Local_Files_List", "Selected" )
    if (selected = 0 ) then do
        filesToView.1 = PromptDlg( "View File", "Enter name of file to view" )
        if ( filesToView.1 = "" ) then
            return -1
        else
            filesToView.0 = 1
    end
    else
        rc = VRMethod( "Local_Files_List", "GetSelectedStringList", filesToView. )

    do i = 1 to filesToView.0
        /* Check whether or not user wants to use the E system
         * editor to view files.
         */
        if ( VRGetIni( "VxFTP", "EEditor", IniFile, "NoClose" ) = 1 ) then do
            command = 'start /f e' '"'filesToView.i'"'
            address cmd command
        end
        else
            call Spawn_ViewTextFile filesToView.i, filesToView.i, "LOCAL"
    end


return

/*:VRX         MI_LWithoutParams_Click
*/
MI_LWithoutParams_Click:
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "selected_files." )

    if (selected_files.0 = 0) then do
        selected_files.1 = PromptDlg( "Execute File", "Enter name of file to execute" )
        if ( selected_files.1 = "" ) then
            return -1
        else
            selected_files.0 = 1
    end

    do i = 1 to selected_files.0
        if ( translate( right( selected_files.i, 4)) = ".EXE") | ,
           ( translate( right( selected_files.i, 4)) = ".CMD") | ,
           ( translate( right( selected_files.i, 4)) = ".COM") | ,
           ( translate( right( selected_files.i, 4)) = ".BAT") then

            'start /f /pgm' selected_files.i
        else
            call BasicErrMsg "The file" selected_files.i "is not executable"

    end /* do */

return

/*:VRX         MI_LWithParams_Click
*/
MI_LWithParams_Click:
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "selected_files." )

    if (selected_files.0 = 0) then do
        selected_files.1 = PromptDlg( "Execute with Parameters", "Enter name of file to execute" )
        if ( selected_files.1 = "" ) then
            return -1
        else
            selected_files.0 = 1
    end

    do i = 1 to selected_files.0
        if ( translate( right( selected_files.i, 4)) = ".EXE") | ,
           ( translate( right( selected_files.i, 4)) = ".CMD") | ,
           ( translate( right( selected_files.i, 4)) = ".COM") | ,
           ( translate( right( selected_files.i, 4)) = ".BAT") then do

            Buttons.1 = "OK"
            Buttons.2 = "Cancel"
            Buttons.0 = 2
            Param = ""
            id = VRPrompt( VRWindow(), "Enter your parameters", "Param", ,
                           "Parameters", "Buttons.", OK, Cancel )

      if ( id = 1 ) then
            'start /f /pgm' selected_files.i Param
        end /* if */
        else
            call BasicErrMsg "The file" selected_files.i "is not executable"

    end /* do */

return

/*:VRX         MI_New_Click
*/
MI_New_Click:
    rc = VRSet( "TM_Relogin", "Enabled", 0 )
    LoginAttemptCount = 0

    call GetLoginInfo
return

/*:VRX         MI_Notebook_Click
*/
MI_Notebook_Click:
    rc = VRLoadSecondary( "Notebook1" )

return

/*:VRX         MI_PopupGetWithoutRename_Click
*/
MI_PopupGetWithoutRename_Click: 
    call MI_GetWithoutRename_Click
return

/*:VRX         MI_PopupGetWithRename_Click
*/
MI_PopupGetWithRename_Click: 
    call MI_GetWithRename_Click
return

/*:VRX         MI_PopupLChDir_Click
*/
MI_PopupLChDir_Click: 
    call MI_LChDir_Click
return

/*:VRX         MI_PopUpLCopy_Click
*/
MI_PopUpLCopy_Click: 
    call MI_LCopy_Click
return

/*:VRX         MI_PopUpLDelete_Click
*/
MI_PopUpLDelete_Click: 
    call MI_LDel_Click
return

/*:VRX         MI_PopupLMkDir_Click
*/
MI_PopupLMkDir_Click: 
    call MI_LMkDir_Click
return

/*:VRX         MI_PopUpLRename_Click
*/
MI_PopUpLRename_Click: 
    call MI_LRen_Click
return

/*:VRX         MI_PopupLRmDir_Click
*/
MI_PopupLRmDir_Click: 
    call MI_LRmDir_Click
return

/*:VRX         MI_PopUpLView_Click
*/
MI_PopUpLView_Click: 
    call MI_LView_Click
return

/*:VRX         MI_PopUpLWithoutParams_Click
*/
MI_PopUpLWithoutParams_Click: 
    call MI_LWithoutParams_Click
return

/*:VRX         MI_PopUpLWithParams_Click
*/
MI_PopUpLWithParams_Click: 
    call MI_LWithParams_Click
return

/*:VRX         MI_PopUpPutWithoutRenaming_Click
*/
MI_PopUpPutWithoutRenaming_Click: 
    call MI_PutWithoutRename_Click
return

/*:VRX         MI_PopUpPutWithRenaming_Click
*/
MI_PopUpPutWithRenaming_Click: 
    call MI_PutWithRename_Click
return

/*:VRX         MI_PopupRChDir_Click
*/
MI_PopupRChDir_Click: 
    call MI_RChDir_Click
return

/*:VRX         MI_PopupRDel_Click
*/
MI_PopupRDel_Click: 
    call MI_RDel_Click
return

/*:VRX         MI_PopupRMkDir_Click
*/
MI_PopupRMkDir_Click: 
    call MI_RMkDir_Click
return

/*:VRX         MI_PopupRRen_Click
*/
MI_PopupRRen_Click: 
    call MI_RRen_Click
return

/*:VRX         MI_PopupRRmDir_Click
*/
MI_PopupRRmDir_Click: 
    call MI_RRmDir_Click
return

/*:VRX         MI_PopupRView_Click
*/
MI_PopupRView_Click: 
    call MI_RView_Click
return

/*:VRX         MI_PopUpUnzipCurrDir_Click
*/
MI_PopUpUnzipCurrDir_Click: 
    call MI_UnzipCurrDir_Click
return

/*:VRX         MI_PopUpUnzipNewDir_Click
*/
MI_PopUpUnzipNewDir_Click: 
    call MI_UnzipNewDir_Click
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    values = ProductInfo( VRWindow() )    
return

/*:VRX         MI_PutWithoutRename_Click
*/
MI_PutWithoutRename_Click:
    if ( ConnectedToHost \= 'TRUE' ) then do
        call BasicErrMsg "Can't Put. Not connected."
        return -1
    end

    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "putFiles." )

    if (putFiles.0 = 0) then do
        putFiles.1  = PromptDlg( "Put File", "Enter the local file name" )
        if ( putFiles.1 = "" ) then
            return -1
        else
            putFiles.0 = 1
    end

    rc = VRMethod( "Application", "PutVar", "putFiles." )

    call XferInProgress                   /* Disable interface objects */

    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call PutFilesNoRename" )

return

/*:VRX         MI_PutWithRename_Click
*/
MI_PutWithRename_Click:
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "putFiles." )

    if (putFiles.0 = 0) then do
        putFiles.1  = PromptDlg( "Put File", "Enter the local file name" )
        if ( putFiles.1 = "" ) then
            return -1
        else
            putFiles.0 = 1
    end

    if ( ConnectedToHost = 'TRUE' ) then do
        rc = VRMethod( "Application", "PutVar", "putFiles." )

        call XferInProgress                   /* Disable interface objects */

        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call PutFilesRenamed" )
    end
    else
        call BasicErrMsg "Can't Put. Not connected."

  
return

/*:VRX         MI_RChDir_Click
*/
MI_RChDir_Click:
    if ( VRGet( "Remote_Dir_Combo", "SelectedString" ) = "" ) then do
        value = PromptDlg( "Change Remote Directory", "Enter new directory" )

        if ( value <> "" ) then
            rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
                 "call FTPChangeDir", "newDir", value )
        end

    else
        call Remote_Dir_Combo_DoubleClick
    
return

/*:VRX         MI_RDel_Click
*/
MI_RDel_Click:
    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", ,
         "deleteFiles." )

    if (deleteFiles.0 = 0) then do
        deleteFiles.1 = PromptDlg( "Delete Remote File", "Enter name of file to delete" )
        if ( deleteFiles.1 = "" ) then
            return -1
        else
            deleteFiles.0 = 1
    end

    call DisableRemoteLists                   /* Disable interface objects */

    do i = 1 to deleteFiles.0
        parse value deleteFiles.i with deleteFiles.i "|" .
        deleteFiles.i = strip( deleteFiles.i )
    end

    call VRMethod "Application", "PutVar", "deleteFiles."
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call FTPDeleteFiles" )

return

/*:VRX         MI_RGet_Click
*/
MI_RGet_Click:
    call MI_GetWithoutRename_Click
return

/*:VRX         MI_RLongList_Click
*/
MI_RLongList_Click:
    call Spawn_ViewTextFile "junk", "Long Directory Listing", "VIEWER"
return

/*:VRX         MI_RMkDir_Click
*/
MI_RMkDir_Click:
    value = PromptDlg( "Make Remote Directory", "Enter directory to create" )

    if ( value <> "" ) then
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call FTPMakeDir", "newDir", value )  
return

/*:VRX         MI_RQuote_Click
*/
MI_RQuote_Click: 

    QuotedMsg = PromptDlg( "Quote", "Enter instruction to send to host" )

    if ( QuotedMsg <> "" ) then do
        rc = VRMethod( "Application", "PutVar", "QuotedMsg" )
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call SendQuotedMsg" )    
    end

return

/*:VRX         MI_RRefreshLists_Click
*/
MI_RRefreshLists_Click:
    call RefreshRemote
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call DownloadNParseList" )
return

/*:VRX         MI_RRen_Click
*/
MI_RRen_Click:
    /* Rename a remote file
     */
    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", ,
         "renameFiles." )

    if (renameFiles.0 = 0) then do
        renameFiles.1 = PromptDlg( "Rename Remote File", "Enter file to rename" )
        if ( renameFiles.1 = "" ) then
            return -1
        else
            renameFiles.0 = 1
    end

    call DisableRemoteLists                   /* Disable interface objects */

    do i = 1 to renameFiles.0
        parse value renameFiles.i with renameFiles.i "|" .
        renameFiles.i = strip( renameFiles.i )
    end


    call VRMethod "Application", "PutVar", "renameFiles."
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call FTPRenameFiles" )
return

/*:VRX         MI_RRmDir_Click
*/
MI_RRmDir_Click:
    value = VRGet( "Remote_Dir_Combo", "SelectedString" )

    if ( value <> "" ) then
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call FTPRemoveDir", "removeDir", value )
  
    else do
        value = PromptDlg( "Remove Remote Directory", "Enter directory to delete" )

        if ( value <> "" ) then
            rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
                 "call FTPRemoveDir", "removeDir", value )
 
        drop value
    end  /* else */

return

/*:VRX         MI_RSite_Click
*/
MI_RSite_Click: 

    SiteCmd = PromptDlg( "Site", "Enter command" )

    if ( SiteCmd <> "" ) then do
        rc = VRMethod( "Application", "PutVar", "SiteCmd" )
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call SendSiteCmd" )    
    end

return

/*:VRX         MI_RView_Click
*/
MI_RView_Click:
    /* Download the selected files for viewing.
     */
    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", filesToView. )
    if ( filesToView.0 = 0 ) then do
        filesToView.1 = PromptDlg( "View File", "Enter name of file to view" )
        if ( filesToView.1 = "" ) then
            return -1
        else
            filesToView.0 = 1
    end
    call VRMethod "Application", "PutVar", "filesToView."

    do i = 1 to filesToView.0
        parse value filesToView.i with filesToView.i "|" .
        filesToView.i = strip( filesToView.i )
    end

    rc = VRMethod( "Application", "PutVar", "filesToView." )

    /* Get the file size of the file(s) selected and send that to
     * the remote thread too.
     */
    rc = VRMethod( "Application", "GetVar", "remote_size." )

    do i = 1 to filesToView.0
        do j = 1 to remote_file.0
            if ( filesToView.i == remote_file.j ) then do
                filesToViewSize.i = remote_size.j
                leave
           end
        end
    end /* do */
    filesToViewSize.0 = filesToView.0
    rc = VRMethod( "Application", "PutVar", "filesToViewSize." )

    call XferInProgress                   /* Disable interface objects */
    
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call ViewFiles" )

return

/*:VRX         MI_SysMac_Click
*/
MI_SysMac_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "MAC" )
    rc = VRSet( "MI_SysMac",  "Checked", 1 )
    rc = VRSet( "MI_SysNW",   "Checked", 0 )
    rc = VRSet( "MI_SysOS2",  "Checked", 0 )
    rc = VRSet( "MI_SysNT",   "Checked", 0 )
    rc = VRSet( "MI_SysUNIX", "Checked", 0 )
    rc = VRSet( "MI_SysVMS",  "Checked", 0 )
    rc = VRSet( "MI_SysVM",   "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )

return

/*:VRX         MI_SysNT_Click
*/
MI_SysNT_Click: 
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "NT" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 1 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )

return

/*:VRX         MI_SysNW_Click
*/
MI_SysNW_Click: 
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "NW" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 1 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )

return

/*:VRX         MI_SysOS2_Click
*/
MI_SysOS2_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "PC" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 1 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )

return

/*:VRX         MI_SysUNIX_Click
*/
MI_SysUNIX_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "UNIX" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 1 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )
return

/*:VRX         MI_SysUnknown_Click
*/
MI_SysUnknown_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "UNIX" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 1 )
return

/*:VRX         MI_SysVM_Click
*/
MI_SysVM_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "VM" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 0 )
    rc = VRSet( "MI_SysVM",       "Checked", 1 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )
return

/*:VRX         MI_SysVMS_Click
*/
MI_SysVMS_Click:
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
         "call SetSysType", "systype", "VMS" )
    rc = VRSet( "MI_SysMac",      "Checked", 0 )
    rc = VRSet( "MI_SysNW",       "Checked", 0 )
    rc = VRSet( "MI_SysOS2",      "Checked", 0 )
    rc = VRSet( "MI_SysNT",       "Checked", 0 )
    rc = VRSet( "MI_SysUNIX",     "Checked", 0 )
    rc = VRSet( "MI_SysVMS",      "Checked", 1 )
    rc = VRSet( "MI_SysVM",       "Checked", 0 )
    rc = VRSet( "MI_SysUnknown",  "Checked", 0 )
return

/*:VRX         MI_UnzipCurrDir_Click
*/
MI_UnzipCurrDir_Click:
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "unzipFiles." )

    if (unzipFiles.0 = 0) then do
        unzipFiles.1 = PromptDlg( "Unzip File", "Enter name of file to unzip" )
        if ( unzipFiles.1 = "" ) then
            return -1
        else
            unzipFiles.0 = 1
    end

    if ( VRGetIni( "VxFTP", "ZipConsole", IniFile, "NoClose" ) = "1" ) then do
        rc = VRRedirectStdIO("On")
        Console = "ON"
    end
    do i = 1 to unzipFiles.0
        rc = VRSet( "MainWindow", "StatusText", "Unzipping" unzipFiles.i )
        if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = 'InfoZip' ) then
            "unzip -oq" unzipFiles.i
        else if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = 'PKUnzip' ) then
                "pkunzip -o" unzipFiles.i
            else
                call BasicErrMsg "Can't unzip. Check Notebook settings."
    end /* do */

    if ( Console = "ON" ) then do
        Console = "OFF"
        CCTID = VRMethod( "Application", "StartThread", "CConsole")
        if CCTID = 0 then
            call BasicErrMsg "Couldn't start Console thread."
    end

    rc = VRSet( "MainWindow", "StatusText", "" )

    call RefreshLocal
    call Spawn_LocalDir

return

/*:VRX         MI_UnzipNewDir_Click
*/
MI_UnzipNewDir_Click:
    rc = VRMethod( "Local_Files_List", "GetSelectedStringList", ,
         "unzipFiles." )

    if (unzipFiles.0 = 0) then do
        unzipFiles.1 = PromptDlg( "Unzip File", "Enter name of file to unzip" )
        if ( unzipFiles.1 = "" ) then
            signal ENDMI_UnzipNewDir_Click
        else
            unzipFiles.0 = 1
    end

    if ( VRGetIni( "VxFTP", "ZipConsole", IniFile, "NoClose" ) = "1" ) then do
        rc = VRRedirectStdIO("On")
        Console = "ON"
    end
    do i = 1 to unzipFiles.0
        if ( VRGetIni("VxFTP", "SubDir", IniFile, "NoClose" ) = 'Prompt' ) then do
            UnzipDir = PromptDlg( "Unzip File", "Enter name of subdirectory for" unzipFiles.i)
            if ( UnzipDir = "" ) then
                iterate
        end
        else
            UnzipDir = left( unzipFiles.i, length( unzipFiles.i) -4 )


        rc = VRMkDir( UnzipDir )
        if ( rc = 0 ) then do
            call BasicErrMsg "Couldn't make" UnzipDir
            iterate
        end
        rc = VRCopyFile( unzipFiles.i, UnzipDir )
        rc = VRChDir( UnzipDir )
        if ( rc = 0 ) then do
            call BasicErrMsg "Couldn't change to" UnzipDir
            iterate
        end

        rc = VRSet( "MainWindow", "StatusText", "Unzipping" unzipFiles.i )
        if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = 'InfoZip' ) then
            "unzip -oq" unzipFiles.i
        else if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = 'PKUnzip' ) then
                "pkunzip -o" unzipFiles.i
            else
                call BasicErrMsg "Can't Unzip. Use Notebook Settings."

        rc = VRDeleteFile( unzipFiles.i )
        rc = VRChDir( ".." )
    end /* do */
    if ( Console = "ON" ) then do
        Console = "OFF"
        CCTID = VRMethod( "Application", "StartThread", "CConsole")
        if CCTID = 0 then
            call BasicErrMsg "Couldn't start Console thread."
    end

    call RefreshLocal
    call Spawn_LocalDir

ENDMI_UnzipNewDir_Click:
    rc = VRSet( "MainWindow", "StatusText", " " )
    drop UnzipDir unzipFiles.
return

/*:VRX         MI_ViewCachedDirs_Click
*/
MI_ViewCachedDirs_Click: 
    rc = VRLoadSecondary( "CachedDirs" )

return

/*:VRX         MI_VxFTPHelp_Click
*/
MI_VxFTPHelp_Click: 
    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), "Press OK to launch Web Explorer", ,
                    "VxFTP Help", "Info", "Buttons.", OK, Cancel )

    if id = 1 then
        address cmd "start explore -q http://sheriff.law.utexas.edu"

return

/*:VRX         NB_Settings1_PageSelected
*/
NB_Settings1_PageSelected: 

return

/*:VRX         NewAliasBtn_Click
*/
NewAliasBtn_Click:
    values = AliasDE( VRWindow(), 'NEW' )

    if ( values <> "" ) then do
        i = GAliases.0 + 1
        GAliases.i = values
        Galiases.0 = i

        call UpdateAliases
    end /* if */
return

/*:VRX         Notebook1_Close
*/
Notebook1_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Options_Close
*/
Options_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Options_Create
*/
Options_Create:
    if ( VRGetIni( "VxFTP", "EEditor", IniFile, "NoClose") = 1 ) then 
        rc = VRSet( "CB_Viewer", "Set", 1 )
    else
        rc = VRSet( "CB_Viewer", "Set", 0 )

    if ( VRGetIni( "VxFTP", "Hints", IniFile, "NoClose") = 1 ) then 
        rc = VRSet( "CB_Hints", "Set", 1 )
    else
        rc = VRSet( "CB_Hints", "Set", 0 )

    if ( VRGetIni( "VxFTP", "ProgInd", IniFile, "NoClose") = 1 ) then 
        rc = VRSet( "CB_ProgInd", "Set", 1 )
    else
        rc = VRSet( "CB_ProgInd", "Set", 0 )
return

/*:VRX         PB_CacheChange_Click
*/
PB_CacheChange_Click: 
    newPath = VRGet( "DDCB_CachedDirs", "Value" )

    if ( newPath <> "" ) then do
        rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, ,
             "call PB_CacheChange_Click", "newPath", newPath )
        if (rc = 1) then
              call DisableRemoteLists
    end

return

/*:VRX         PB_CacheClose_Click
*/
PB_CacheClose_Click: 
    parent = VRGet( "PB_CacheClose", "Parent" )
    call VRDestroy parent
    drop parent

return

/*:VRX         PromptDlg
*/
PromptDlg: procedure
    Title = arg(1)
    Text  = arg(2)

    if ( arg() = 3 ) then
        value = arg(3)

    Buttons.1 = "OK"
    Buttons.2 = "Cancel"
    Buttons.0 = 2
    
    id = VRPrompt( VRWindow(), Text, "value", Title, "Buttons.", OK, Cancel )

    if ( ( id = 0 ) | ( id = 2 ) ) then
        return ""

return value

/*:VRX         Put_Button_Click
*/
Put_Button_Click:
    call MI_PutWithoutRename_Click

return

/*:VRX         PutComplete
*/
PutComplete:
    call XferComplete "Show"

    if ( VRGetIni( "VxFTP", "NoRemoteUpdate", IniFile, "NoClose") = 0 ) then
        call RefreshRemote

return

/*:VRX         Quit
*/
Quit:
    rc = VRSet( "MainWindow", "StatusText", "Shutting Down" )
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call Quit")

    windowstate = VRGet( "MainWindow", "WindowState" )
    if ( windowstate = "Maximized" ) then     
        rc = VRSetIni( "VxFTP", "WinState", "Maximized", IniFile, "NoClose" )
    else do
        rc = VRSetIni( "VxFTP", "WinState", "Normal", IniFile, "NoClose" )
        lastWidth = VRGet( "MainWindow", "Width" )
        lastHeight = VRGet( "MainWindow", "Height" )
        lastTop = VRGet( "MainWindow", "Top" )
        lastLeft = VRGet( "MainWindow", "Left" )
        rc = VRSetIni( "VxFTP", "Width", lastWidth, IniFile, "NoClose" )
        rc = VRSetIni( "VxFTP", "Height", lastHeight, IniFile, "NoClose" )
        rc = VRSetIni( "VxFTP", "Top", lastTop, IniFile, "NoClose" )
        rc = VRSetIni( "VxFTP", "Left", lastLeft, IniFile, "NoClose" )
    end /* else */

    /* Save the fonts the user might have changed.
     */
    font1 = VRGet( "Local_Files_List", "Font" )
    font2 = VRGet( "Local_Dir_Combo", "Font" )
    font3 = VRGet( "DDCB_Local_CWD", "Font" )
    font4 = VRGet( "Remote_Files_List", "Font" )
    font5 = VRGet( "Remote_Dir_Combo", "Font" )
    font6 = VRGet( "DDCB_Remote_CWD", "Font" )
    Fonts = font1"|"font2"|"font3"|"font4"|"font5"|"font6
    rc = VRSetIni( "VxFTP", "ListFonts", Fonts, IniFile )

    /* VxREXX is faster than you'd expect. Give the remote thread a little
     * time to Logoff if it is indeed alive.
     */
    if ( ConnectedToHost = 'TRUE' ) then
        call SysSleep 1

    /* Prepare to shut down the application. Find out the number of threads
     * still active. If it's greater than 1, kill the outstanding threads 
     * one by one. We try this process three times until either they all die 
     * or we've done it three time. How obvious.
     */
    do i = 1 to 3
        rc = VRMethod( "Application", "ListThreads", "T_IDs.")
        if ( T_IDs.0 > 1 ) then 
            do j = T_IDs.0 to 2 by -1
                rc = VRSet( "MainWindow", "StatusText", "Killing Thread" j ) 
                rc = VRMethod( "Application", "HaltThread", T_IDs.j )
                call SysSleep 1
            end
        else
            leave
    end /* do */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         RB_Dir_Click
*/
RB_Dir_Click: 
    /* Reset the remote directory cache and re-download file list
     */
    if ( ConnectedToHost = 'TRUE' ) then do
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call SetupDirCacheTable" )
        call MI_RRefreshLists_Click
    end

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    RemFileList = overlay( 'D', RemFileList, 1 )
    rc = VRSetIni("VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
    rc = VRSet( "CB_IncludeSize", "Enabled", 1 )
    rc = VRSet( "CB_IncludeDate", "Enabled", 1 )

    select
        when substr( RemFileList, 2, 2 ) = '00' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files" )
        when substr( RemFileList, 2, 2 ) = '10' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size" )
        when substr( RemFileList, 2, 2 ) = '01' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Date" )
        when substr( RemFileList, 2, 2 ) = '11' then
            rc = VRSet( "DT_RemoteFiles", "Caption", "Files | Size | Date" )
    end

    call FlushCacheList
return

/*:VRX         RB_Extract_Click
*/
RB_Extract_Click:
    rc = VRSetIni( "VxFTP", "SubDir", "Extract", IniFile, "NoClose" )
    
return

/*:VRX         RB_InfoZip_Click
*/
RB_InfoZip_Click:
    rc = VRSetIni( "VxFTP", "UnzipPgm", "InfoZip", IniFile, "NoClose" )

return

/*:VRX         RB_Ls_Click
*/
RB_Ls_Click: 
    /* Reset the remote directory cache and re-download file list
     */
    if ( ConnectedToHost = 'TRUE' ) then do
        rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
             "call SetupDirCacheTable" )
        call MI_RRefreshLists_Click
    end

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    RemFileList = overlay( 'L', RemFileList, 1 )
    rc = VRSetIni("VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )
    rc = VRSet( "CB_IncludeSize", "Enabled", 0 )
    rc = VRSet( "CB_IncludeDate", "Enabled", 0 )
    rc = VRSet( "DT_RemoteFiles", "Caption", "Files & Dirs" )

    call FlushCacheList
return

/*:VRX         RB_PKUnzip_Click
*/
RB_PKUnzip_Click:
    rc = VRSetIni( "VxFTP", "UnzipPgm", "PKUnzip", IniFile, "NoClose" )
return
/*:VRX         RB_Prompt_Click
*/
RB_Prompt_Click:
    rc = VRSetIni( "VxFTP", "SubDir", "Prompt", IniFile, "NoClose" )
return

/*:VRX         RB_SortAscending_Click
*/
RB_SortAscending_Click: 
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    RemFileList = overlay( 'A', RemFileList, 4 )
    rc = VRSetIni("VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )

    rc = VRSet( "Remote_Files_List", "Sort", "Ascending" ) 
    call RefreshRemote
    call SetRemoteDir
return

/*:VRX         RB_SortDescending_Click
*/
RB_SortDescending_Click: 
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    RemFileList = overlay( 'D', RemFileList, 4 )
    rc = VRSetIni("VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )

    rc = VRSet( "Remote_Files_List", "Sort", "Descending" )
    call RefreshRemote
    call SetRemoteDir

return

/*:VRX         RB_SortNone_Click
*/
RB_SortNone_Click: 
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    RemFileList = overlay( 'N', RemFileList, 4 )
    rc = VRSetIni("VxFTP", "RemFileList", RemFileList, IniFile, "NoClose" )

    rc = VRSet( "Remote_Files_List", "Sort", "None" )
    call RefreshRemote
    call SetRemoteDir

return

/*:VRX         Re_Logon_Close
*/
Re_Logon_Close: 
    call Re_Logon_Fini
return

/*:VRX         Re_Logon_Create
*/
Re_Logon_Create: 
    if ( VRGetIni( "VxFTP", "UseTimer", IniFile, "NoClose") = 1 ) then do
        rc = VRSet( "CB_ReattemptLogin", "Set", 1 )
        rc = VRSet( "GB_Relogon", "Enabled", 1 )
      end
    else do
        rc = VRSet( "CB_ReattemptLogin", "Set", 0 )
        rc = VRSet( "GB_Relogon", "Enabled", 1 )
    end

    ReLoginDelay = VRGetIni( "VxFTP", "ReLoginDelay", IniFile, "NoClose")
    rc = VRSet( "SPIN_RelogonSecs", "Value", ReLoginDelay )    

    call Re_Logon_Init

return

/*:VRX         Re_Logon_Fini
*/
Re_Logon_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Re_Logon_Init
*/
Re_Logon_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         RefreshCachedDirs
*/
RefreshCachedDirs: 
    rc = VRIsValidObject( "DDCB_CachedDirs" )
    if ( rc = 1 ) then do
        rc = VRMethod( "Application", "GetVar", "Table.Dir_Name." )
        rc = VRMethod( "DDCB_CachedDirs", "Reset" )
        rc = VRMethod( "DDCB_CachedDirs", "AddStringList", "Table.Dir_Name."  )
    end

return

/*:VRX         RefreshLocal
*/
RefreshLocal:
    /* To refreshen the directory and file lists once
       their contents have changed.
     */
    rc = VRMethod( "Local_Dir_Combo", "Reset" )
    rc = VRSet( "Local_Dir_Combo", "Value", "" )
    rc = VRMethod( "Local_Files_List", "Reset" )

return

/*:VRX         RefreshRemote
*/
RefreshRemote:
    /* To refreshen the directory & file lists once a change
       has occurred.
     */
    rc = VRSet( "DT_RFileInfo", "Caption", "" )
    rc = VRMethod( "Remote_Dir_Combo", "Reset" )
    rc = VRSet( "Remote_Dir_Combo", "Value", "" )
    rc = VRMethod( "Remote_Files_List", "Reset" )
return

/*:VRX         Remote_Dir_Combo_ContextMenu
*/
Remote_Dir_Combo_ContextMenu:

    rc = VRMethod("MI_PopupRDir", "Popup")
return

/*:VRX         Remote_Dir_Combo_DoubleClick
*/
Remote_Dir_Combo_DoubleClick:

    newDir = VRGet( "Remote_Dir_Combo", "Value" )
    rc = VRMethod("Application", "PostQueue", RemoteTID, 0, ,
         "call Remote_Dir_Combo_DoubleClick", "Dir_From_GUI", newDir)
    if (rc = 1) then
            call DisableRemoteLists

    drop newDir
return

/*:VRX         Remote_Files_List_Click
*/
Remote_Files_List_Click:
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    if ( left( RemFileList, 1 ) = 'L' ) then do
        rc = VRSet( "DT_RFileInfo", "Caption", "Use 'dir' option in Notebook for file info" )
        return
    end

    rc = VRMethod( "Remote_Files_List", "GetSelectedStringList", "infoFiles." )
    rc = VRMethod( "Application", "GetVar", "remote_size." )
    CR_LF = "0a"x

    if ( infoFiles.0 > 1 ) then do
    /*  If the user selected more than one item, add up the file sizes (in
        remote_size.) and show the TotalKB in DT_RFileInfo
     */ 
        TotalKB = 0
        do i = 1 to infoFiles.0
            do j = 1 to remote_file.0
                if ( infoFiles.i == remote_file.j ) then do
                    TotalKB = TotalKB + remote_size.j
                    leave
               end
            end
        end /* do */

        if TotalKB > 1000 then
            rc = VRSet( "DT_RFileInfo", "Caption", ,
                        "Files Selected:" CR_LF || trunc(TotalKB / 1000, 1) "KB" )
        else
            rc = VRSet( "DT_RFileInfo", "Caption", ,
                        "Files Selected:" CR_LF || TotalKB "bytes" )
    end
 
    else do
    /* If the user only selected one item, show the file's size and date/time stamp
       in DT_RFileInfo
     */
        rc = VRMethod( "Application", "GetVar", "remote_date." )
        rc = VRMethod( "Application", "GetVar", "remote_time." )

        if ( right( RemFileList, 1 ) = 'N' ) then
            j = VRGet( "Remote_Files_List", "Selected" )

        else   
            do j = 1 to remote_file.0
               if ( infoFiles.1 == remote_file.j ) then
                   leave          
            end /* do */

        rc = VRSet( "DT_RFileInfo", "Caption", "Size:" remote_size.j CR_LF"Date:" remote_date.j remote_time.j )
    end /* else */

return

/*:VRX         Remote_Files_List_ContextMenu
*/
Remote_Files_List_ContextMenu:
    rc = VRMethod("MI_PopupRFiles", "Popup")
    
return

/*:VRX         Remote_Files_List_DoubleClick
*/
Remote_Files_List_DoubleClick:
    call Get_Button_Click
return
/*:VRX         Set_DDCB_Local_CWD
*/
Set_DDCB_Local_CWD:
    /* Replace blanks in directory names (HPFS) with an asterick,
       which is illegal in HPFS. (We'll soon re-replace the astericks
       which the space once we've assigned the file to the directory
       stem variable.) Remove the backslashes in the path, replacing
       them with blanks so the REXX word functions will work.
     */
    directories = translate( VRCurrDir(), '*', ' ')
    directories = translate(directories, ' ', '\')
    directories = "\ " || directories
    numDirs = words(directories)
    localDirs.0 = numDirs 

    /* Add the "word"s within "directories" to localDirs. stem,
       replacing any astericks with the blank spaces that were
       originally there.
     */
    do i = 1 to numDirs
        localDirs.i = word(directories, numDirs-(i-1))
        localDirs.i = translate(localDirs.i, ' ', '*')
    end
    
    rc = VRSet("DDCB_Local_CWD", "Value", localDirs.1)
    rc = VRMethod( "DDCB_Local_CWD", "Clear" )
    rc = VRMethod( "DDCB_Local_CWD", "AddStringList", "localDirs."  )
    
    drop directories numDirs
return
/*:VRX         Set_DDCB_Remote_CWD
*/
Set_DDCB_Remote_CWD:
    call VRMethod "Application", "GetVar", "RemoteCWDDirs."
    rc = VRSet("DDCB_Remote_CWD", "Value", RemoteCWDDirs.1)
    rc = VRMethod( "DDCB_Remote_CWD", "Clear" )
    rc = VRMethod( "DDCB_Remote_CWD", "AddStringList", "RemoteCWDDirs."  )
        
    drop RemoteCWDDirs.
return
/*:VRX         SetDriveInfoDisplay
*/
SetDriveInfoDisplay: 
    DriveInfo = "Drive" VRCurrDrive() "     " VRDiskInfo( F ) % 1000 "KB Free"
    rc = VRSet( "DT_LocalDrive", "Caption", DriveInfo )

return

/*:VRX         SetLocalDir
*/
SetLocalDir:
    /* Fill the user interface items with the local directory
     * information gathered and parsed in separate thread.
     */
    call VRMethod "Application", "GetVar", "dirList."
    call VRMethod "Application", "GetVar", "fileList."

    rc = VRSet( "Local_Dir_Combo", "Value", "" )
    rc = VRMethod( "Local_Dir_Combo", "AddStringList", "dirList."  )
    rc = VRMethod( "Local_Dir_Combo", "AddStringList", "LocalDrives."  )
    rc = VRMethod( "Local_Files_List", "AddStringList", "fileList." )

    call SetDriveInfoDisplay
    call EnableLocalLists

    drop dirList. fileList.
return

/*:VRX         SetRemoteDir
*/
SetRemoteDir:
    /* Fill the user interface items with the remote directory
     * information gathered and parsed in remote thread.
     */
    call VRMethod "Application", "GetVar", "remote_file."
    call VRMethod "Application", "GetVar", "remote_dir."

    rc = VRSet( "Remote_Dir_Combo", "Value", "" )
    rc = VRMethod( "Remote_Dir_Combo", "AddStringList", "remote_dir."  )
    rc = VRMethod( "Remote_Files_List", "AddStringList", "remote_file." )
    rc = VRSet( "DT_RFileInfo", "Caption", "" )

    call EnableRemoteLists

return

/*:VRX         SetupRemote
*/
SetupRemote:
    /* Spawn Remote thread
     */
    RemoteTID = VRMethod( "Application", "StartThread", "Remote")
    if RemoteTID = 0 then do
        call BasicErrMsg "Couldn't start Remote Process thread."
        call Quit
    end

return

/*:VRX         Spawn_LocalDir
*/
Spawn_LocalDir:
    LocalDirTID = VRMethod("Application", "StartThread", "LocalDir")
    if LocalDirTID = 0 then
        call BasicErrMsg "Couldn't start Local Directory List thread."
return

/*:VRX         Spawn_ViewTextFile
*/
Spawn_ViewTextFile: procedure
    LocalFile      = arg(1)   /* Name of file locally              */
    FiletoDownload = arg(2)   /* Name to stick in the Title Frame  */
    Locale         = arg(3)   /* Will contain "VIEWER" when called from MI_RLongList */

    TextFileTID = VRMethod("Application", "StartThread", "TextFile", LocalFile"||"FiletoDownload"||"Locale )
    if TextFileTID = 0 then
        call BasicErrMsg "Couldn't start View Text File thread."

return

/*:VRX         SPIN_CacheSize_Change
*/
SPIN_CacheSize_Change: 
    value = VRGet( "SPIN_CacheSize", "Value" )
    rc = VRSetIni( "VxFTP", "CacheSize", value, IniFile, "NoClose" )
return

/*:VRX         SPIN_RefreshInterval_Change
*/
SPIN_RefreshInterval_Change: 
    value = VRGet( "SPIN_RefreshInterval", "Value" )
    rc = VRSetIni( "VxFTP", "RefreshInterval", value, IniFile, "NoClose" )
return

/*:VRX         SPIN_RelogonSecs_Change
*/
SPIN_RelogonSecs_Change: 
    ReLoginDelay = VRGet( "SPIN_RelogonSecs", "Value" )
    rc = VRSetIni( "VxFTP", "ReLoginDelay", ReLoginDelay, IniFile, "NoClose" )

    ReLoginDelay = ReLoginDelay * 1000
    rc = VRSet( "TM_Relogin", "Delay", ReLoginDelay )

return

/*:VRX         TM_Relogin_Trigger
*/
TM_Relogin_Trigger: 
    /* Re-attempt to log into host
     */
    rc = VRMethod( "Application", "PostQueue", RemoteTID, 0, "call LogonToHost" ,,
                   "Host", Host, "Login", Login, "Passwd", Passwd,,
                   "rCWD", rCWD, "Anon", Anon, "SysType", SysType )

    rc = VRSet( "MainWindow", "StatusText", "Re-attempting to logon to" Host )
    
return

/*:VRX         Unzip_Close
*/
Unzip_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Unzip_Create
*/
Unzip_Create:

    if ( VRGetIni( "VxFTP", "UnzipPgm", IniFile, "NoClose" ) = 'PKUnzip' ) then do
        rc = VRSet( "RB_InfoZip", "Set", 0 )
        rc = VRSet( "RB_PKUnzip", "Set", 1 )
      end
    else do
        rc = VRSet( "RB_InfoZip", "Set", 1 )
        rc = VRSet( "RB_PKUnzip", "Set", 0 )
    end

    if ( VRGetIni( "VxFTP", "SubDir", IniFile, "NoClose" ) = 'Extract' ) then do
        rc = VRSet( "RB_Extract", "Set", 1 )
        rc = VRSet( "RB_Prompt",  "Set", 0 )
      end
    else do
        rc = VRSet( "RB_Extract", "Set", 0 )
        rc = VRSet( "RB_Prompt",  "Set", 1 )
    end

    if ( VRGetIni( "VxFTP", "ZipConsole", IniFile, "NoClose" ) = '1' ) then
        rc = VRSet( "CB_ZipConsole", "Set", 1 )
    else
        rc = VRSet( "CB_ZipConsole", "Set", 0 )

return

/*:VRX         UpdateAliases
*/
UpdateAliases:
    rc = VRSet( "NewAliasBtn", "Enabled", 0 )
    rc = VRSet( "EditAliasBtn", "Enabled", 0 )
    rc = VRSet( "DelAliasBtn", "Enabled", 0 )
    
    /* Extract the Aliases from the GAlias stem and update
     * the Aliases in the IniFile.
     * Also, extract out the Aliases' names into AliasName.i
     * and redisplay the names in the list box
     */
    NewAliases = ""
    do i = 1 to GAliases.0
        NewAliases = NewAliases || GAliases.i || "}{"
        parse value GAliases.i with AliasName.i "|" rest
    end
    AliasName.0 = i - 1

    rc = VRSetIni( "VxFTP", "Aliases", NewAliases, IniFile, "NoClose" )

    rc = VRMethod( "LB_Aliases", "Reset" )    
    rc = VRMethod( "LB_Aliases", "AddStringList", "AliasName."  )

    if ( GAliases.0 = 1 ) then
        rc = VRSet( "DT_AliasNumber", "Caption", "1 Alias" )
    else
        rc = VRSet( "DT_AliasNumber", "Caption", GAliases.0 "Aliases" )

    rc = VRSet( "NewAliasBtn",  "Enabled", 1 )
    rc = VRSet( "EditAliasBtn", "Enabled", 1 )
    rc = VRSet( "DelAliasBtn",  "Enabled", 1 )

    drop NewAliases AliasName. rest
return

/*:VRX         XferComplete
*/
XferComplete:
    parse arg ShowStatus
    if ( ShowStatus = "Show" ) then
        rc = VRSet( "MainWindow", "StatusText", "File Transfer(s) Complete" )

    rc = VRSet( "MI_Kill",             "Enabled", 1 )
    rc = VRSet( "MI_ASCII",            "Enabled", 1 )
    rc = VRSet( "MI_Binary",           "Enabled", 1 )
    rc = VRSet( "MI_Close",            "Enabled", 1 )
    rc = VRSet( "MI_LChDir",           "Enabled", 1 )
    rc = VRSet( "MI_LMkDir",           "Enabled", 1 )
    rc = VRSet( "MI_LRmDir",           "Enabled", 1 )
    rc = VRSet( "MI_RChDir",           "Enabled", 1 )
    rc = VRSet( "MI_RMkDir",           "Enabled", 1 )
    rc = VRSet( "MI_RRmDir",           "Enabled", 1 )
    rc = VRSet( "MI_RRefreshLists",    "Enabled", 1 )
    rc = VRSet( "MI_LPut",             "Enabled", 1 )
    rc = VRSet( "MI_RGet",             "Enabled", 1 )
    rc = VRSet( "MI_RView",            "Enabled", 1 )
    rc = VRSet( "MI_RDel",             "Enabled", 1 )
    rc = VRSet( "MI_RRen",             "Enabled", 1 )
    rc = VRSet( "MI_ViewCachedDirs",   "Enabled", 1 )
    rc = VRSet( "MI_RQuote",           "Enabled", 1 )
    rc = VRSet( "MI_RSite",            "Enabled", 1 )
    rc = VRSet( "MI_PopupPut",         "Enabled", 1 )
    rc = VRSet( "Get_Button",          "Enabled", 1 )
    rc = VRSet( "Put_Button",          "Enabled", 1 )

    call EnableLocalLists            /* Re-enable lists    */
    call EnableRemoteLists

    /* If VxFTP is minimized, get the Handle of the window that
     * currently has the focus ("GetFocusWindow"), put up a dialog
     * box to indicate "File Transfer(s) complete", then give
     * focus back to the window that had it ("SetFocus").
     */
    windowstate = VRGet( "MainWindow", "WindowState" )
    if ( windowstate = "Minimized" ) then do
        WHandle = VRMethod( "Screen", "GetFocusWindow" )
        OK = 1
        Buttons.OK = "OK"
        Buttons.0 = 1
        id = VRMessage( VRWindow(), "File Transfer(s) complete", "VxFTP", ,
                        "Info", "Buttons.", OK )
        rc = VRMethod( WHandle, "SetFocus" )
    end /* if */

    if ( VRGetIni( "VxFTP", "Hints", IniFile, "NoClose" ) = "1" ) then
        rc = VRSet( "MainWindow", "ShowHints", 1 )
    else
        rc = VRSet( "MainWindow", "StatusText", "" )

return

/*:VRX         XferInProgress
*/
XferInProgress:
    /* Disable most of the user interface            */
    call VRSet "DDCB_Local_CWD", "Enabled", 0
    call VRSet "Local_Dir_Combo", "Enabled", 0

    call DisableRemoteLists
    rc = VRSet( "MainWindow", "ShowHints", 0 ) 
    
    rc = VRSet( "MI_New",              "Enabled", 0 )   
    rc = VRSet( "MI_Kill",             "Enabled", 1 )
    rc = VRSet( "MI_ASCII",            "Enabled", 0 )
    rc = VRSet( "MI_Binary",           "Enabled", 0 )
    rc = VRSet( "MI_Close",            "Enabled", 0 )
    rc = VRSet( "MI_LChDir",           "Enabled", 0 )
    rc = VRSet( "MI_LMkDir",           "Enabled", 0 )
    rc = VRSet( "MI_LRmDir",           "Enabled", 0 )
    rc = VRSet( "MI_RChDir",           "Enabled", 0 )
    rc = VRSet( "MI_RMkDir",           "Enabled", 0 )
    rc = VRSet( "MI_RRmDir",           "Enabled", 0 )
    rc = VRSet( "MI_RRefreshLists",    "Enabled", 0 )
    rc = VRSet( "MI_LPut",             "Enabled", 0 )
    rc = VRSet( "MI_RGet",             "Enabled", 0 )
    rc = VRSet( "MI_RView",            "Enabled", 0 )
    rc = VRSet( "MI_RDel",             "Enabled", 0 )
    rc = VRSet( "MI_RRen",             "Enabled", 0 )
    rc = VRSet( "MI_ViewCachedDirs",   "Enabled", 0 )
    rc = VRSet( "MI_RQuote",           "Enabled", 0 )
    rc = VRSet( "MI_RSite",            "Enabled", 0 )
    rc = VRSet( "MI_PopupPut",         "Enabled", 0 )
    rc = VRSet( "Get_Button",          "Enabled", 0 )
    rc = VRSet( "Put_Button",          "Enabled", 0 )

    rc = VRSet( "MainWindow", "StatusText", "File Transfer(s) in progress" ) 
return


