/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         BasicErrMsg
*/
BasicErrMsg:
    parse arg ErrMessage

    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), ErrMessage, "Error", ,
                     "Error", "Buttons.", OK, Cancel )
    drop ErrMessage

return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1

    parse value InitArgs.1 with LocalFile "||" DownloadFileName "||" Locale

    if ( Locale = "VIEWER" ) then
        call ShowText
    else
        call ShowFile

    call VRMethod window, "Activate"
    drop window
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ShowFile
*/
ShowFile:
    /* Get the file as the first Param of passed data and read into
     * what will become a very long string, TextFile. Set the
     * value of MLE_TextFile to the long string TextFile.
     */
    CR_LF = "0d0a"x
    TextFile = ""
    rc = VRSet( "Window1", "Caption", DownloadFileName )

    do while lines( LocalFile )
        TextFile = TextFile || linein( LocalFile ) || CR_LF
    end
    rc = lineout( LocalFile )

    rc = VRSet( "MLE_TextFile", "Value", TextFile )

    if ( Locale  = "REMOTE" ) then do
        rc = VRDeleteFile( LocalFile )
        if (rc = 0) then
            call BasicErrMsg "Couldn't delete" DownloadFileName "on local system."
    end

return

/*:VRX         ShowText
*/
ShowText:
    call VRMethod "Application", "GetVar", "remote_list."
    
    CR_LF = "0d0a"x
    ViewFile = ""

    if ( Datatype( remote_list.0, "N" ) ) then do
    
        do i = 1 to remote_list.0
            ViewFile = ViewFile || remote_list.i || CR_LF
        end

        rc = VRSet( "Window1", "Caption", DownloadFileName )
        rc = VRSet( "MLE_TextFile", "Value", ViewFile )
    end
    else
        call BasicErrMsg "Listing not downloaded yet"

return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_Resize
*/
Window1_Resize:
    window = VRWindow()
    width = VRGet( window, "InteriorWidth" )
    height = VRGet( window, "InteriorHeight" )

    rc = VRSet( "MLE_TextFile", "Height", height )
    rc = VRSet( "MLE_TextFile", "Width", width )

    drop window height width
return

