/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit

/*
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end
*/

/*  Process events
*/
    call Init
    signal on halt
    do forever
/*    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) ) */
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()

/*
    call VRDestroy _VREPrimaryWindow
*/

_VRELeaveMain:
    call VRFini
exit _VREReturnValue

/*
VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window
*/
/*:VRX         AddFileInfo
*/
AddFileInfo: 
    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )

    select
        /* Include Size, not Date                   */
        when substr( RemFileList, 2, 2 ) = '10' then
            do i = 1 to remote_file.0
                if length( remote_file.i) < 12 then
                    remote_file.i = remote_file.i || copies( ' ', 12-length(remote_file.i))
                remote_file.i = remote_file.i '|' remote_size.i
            end

        /* Include Date not Size                   */
        when substr( RemFileList, 2, 2 ) = '01' then
            if ( SysType = "UNIX" | SysType = "NW" ) then
                do i = 1 to remote_file.0
                    if length( remote_file.i) < 12 then
                        remote_file.i = remote_file.i || copies( ' ', 12-length(remote_file.i))
                    remote_file.i = remote_file.i '|' remote_date.i remote_time.i
                end
            else 
                do i = 1 to remote_file.0
                    if length( remote_file.i) < 12 then
                        remote_file.i = remote_file.i || copies( ' ', 12-length(remote_file.i))
                    remote_file.i = remote_file.i '|' remote_date.i
                end

        /* Include Size, include Date              */
        when substr( RemFileList, 2, 2 ) = '11' then
            if ( SysType = "UNIX" | SysType = "NW" ) then
                do i = 1 to remote_file.0
                    if length( remote_file.i) < 12 then
                        remote_file.i = remote_file.i || copies( ' ', 12-length(remote_file.i))
                    remote_file.i = remote_file.i '|' remote_size.i '|' remote_date.i remote_time.i
                end
            else
                do i = 1 to remote_file.0
                    if length( remote_file.i) < 12 then
                        remote_file.i = remote_file.i || copies( ' ', 12-length(remote_file.i))
                    remote_file.i = remote_file.i '|' remote_size.i '|' remote_date.i
                end

        otherwise
            nop
    end


return

/*:VRX         AddToDirCache
*/
AddToDirCache: 
    
    TableIndex = (TableIndex // MaxTableSize ) + 1
    if ( TableIndex > TableSize ) then
        TableSize = TableIndex

    Table.Dir_Name.TableIndex = GRemotePath
    Table.Freshness.TableIndex = 'FRESH'

    /* The user may want to view the names of the directories cached,
     * so publish the new one to the Local thread so it can be added
     * to the list.
     */
    Table.Dir_Name.0 = TableSize
    rc = VRMethod( "Application", "PutVar", "Table.Dir_Name." )
    rc = VRMethod( "Application", "PostQueue", 0, 1, "call RefreshCachedDirs" )

    Table.CreateTime.TableIndex = time(minutes)
    do i = 1 to remote_file.0
        Table.files.TableIndex.i = remote_file.i
        Table.dates.TableIndex.i = remote_date.i
        Table.sizes.TableIndex.i = remote_size.i
        Table.times.TableIndex.i = remote_time.i
    end
    Table.files.TableIndex.0 = remote_file.0
    Table.dates.TableIndex.0 = remote_file.0
    Table.sizes.TableIndex.0 = remote_file.0
    Table.times.TableIndex.0 = remote_file.0

    do i = 1 to remote_dir.0
        Table.dirs.TableIndex.i = remote_dir.i
    end
    Table.dirs.TableIndex.0 = remote_dir.0

    drop i
return

/*:VRX         BasicErrMsg
*/
BasicErrMsg:
    parse arg ErrMessage

    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), ErrMessage, "Error", ,
                     "Error", "Buttons.", OK, Cancel )
return

/*:VRX         ChangeToRemoteFSComplete
*/
ChangeToRemoteFSComplete: 
    /* Check how to update remote lists and update directory cache     */
    UseCache = VRGetIni( "VxFTP", "UseCache", IniFile, "NoClose" )
    NoRefresh = VRGetIni( "VxFTP", "NoRemoteUpdate", IniFile, "NoClose" )
    select
        when ( UseCache = 1 & NoRefresh = 0 ) then do
            rc = VRMethod( "Application", "PostQueue", 0, 1, "call RefreshRemote" )
            call RefreshRemoteLists
          end

        when ( UseCache = 1 & NoRefresh = 1 ) then
            call MarkCacheEntryStale

        when ( UseCache = 0 & NoRefresh = 0 ) then do
            rc = VRMethod( "Application", "PostQueue", 0, 1, "call RefreshRemote" )
            call DownloadNParseList
          end

        otherwise
            nop
    end /* select */

    drop UseCache NoRefresh
return

/*:VRX         DownloadNParseList
*/
DownloadNParseList: 
    /* Get the remote directory listing, parse it, and put
     * the remote directory and file listings in Global memory
     * for the GUI thread (main thread) to access.
     */
    TextToSend = 'call VRSet "MainWindow", "StatusText", "Downloading file list"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    RemFileList = VRGetIni( "VxFTP", "RemFileList", IniFile, "NoClose" )
    if ( left( RemFileList, 1 ) = 'L' ) then do
        if ( SysType = "VMS" ) then
            rc = FtpLs( " ", remote_list. )
        else
            rc = FtpLs( ".", remote_list. )

        if (rc = 1) then
            call FtpErrMsg
        else do
            do i = 1 to remote_list.0
                remote_file.i = remote_list.i
            end
            remote_file.0 = i-1
            remote_size.0 = 0
            remote_date.0 = 0
            remote_time.0 = 0
            remote_dir.0  = 0
            call PostRemoteFiles
        end
      end

    else do
        if ( SysType = "VMS" ) then
            rc = FtpDir( " ", remote_list. )
        else
            rc = FtpDir( ".", remote_list. )

        if (rc = 1) then
            call FtpErrMsg
        else do
            command = "call ParseRemoteFileList"SysType
            interpret command
            call AddFileInfo
            call PostRemoteFiles
        end
    end

    TextToSend = 'call VRSet "MainWindow", "StatusText", " "'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )


return

/*:VRX         Fini
*/
Fini:
/* This code is not needed since the Window is never made visible. */
/*
    window = VRWindow()
    call VRSet window, "Visible", 0 
    drop window
*/
return 0

/*:VRX         FTP_Logoff
*/
FTP_Logoff:
    rc = FtpLogoff()
    if (rc <> 0) then
        call FTPErrMsg

    else do
        drop SysType Host Login Passwd rCWD VMS_ListingType
        call VRMethod "Application", "PostQueue", 1, 0,,
             "call LogoffSuccessful"

        call VRMethod "Application", "PostQueue", 1, 0,,
             'call VRSet "MainWindow", "StatusText", "Logoff was successful"'

        remote_file.0 = 0
        remote_size.0 = 0
        remote_date.0 = 0
        remote_time.0 = 0
        remote_dir.0  = 0
        call VRMethod "Application", "PutVar", "remote_file."
        call VRMethod "Application", "PutVar", "remote_size."
        call VRMethod "Application", "PutVar", "remote_date."
        call VRMethod "Application", "PutVar", "remote_time."
        call VRMethod "Application", "PutVar", "remote_dir."

        call SetupDirCacheTable
    end /* end else */
return

/*:VRX         FTPChangeDir
*/
FTPChangeDir:
    /* Change directory on the remote host
     */
    newPath = VRInfo("newDir")

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Changing to' newPath'"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpChDir(newPath)
    if (rc <> 0) then do
        call FTPErrMsg
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        return -1
    end

    call SetRemotePath           /* Get value for GRemotePath       */
    call SetRemoteCWD            /* Determine & post Remote CWD     */
    call RemoteDirList           /* Get, parse, & post files & dirs */

    drop newPath
return

/*:VRX         FTPDeleteFiles
*/
FTPDeleteFiles:
    /* Get the list of files to delete, then delete them one at a time.
     */
    call VRMethod "Application", "GetVar", "deleteFiles."

    do i = 1 to deleteFiles.0
        TextToSend = 'call VRSet "MainWindow", "StatusText", "Deleting' deleteFiles.i'"'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

        rc = FtpDelete( deleteFiles.i )
        if (FTPERRNO <> 0) then  call FTPErrMsg
    end /* do */

    TextToSend = 'call VRSet "MainWindow", "StatusText", " "'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = VRMethod( "Application", "PostQueue", 0, 1, "call EnableRemoteLists" )

    call ChangeToRemoteFSComplete

    drop NoUpdate
return

/*:VRX         FTPErrMsg
*/
FTPErrMsg:
    call VRMethod "Application", "PostQueue", 0, 1, "call FTPErrMsg", ,
         "FTP_Errno", FTPERRNO

return

/*:VRX         FTPMakeDir
*/
FTPMakeDir:
    newPath = VRInfo("newDir")

    rc = FtpMkDir(newPath)
    if (rc <> 0) then do
        call FTPErrMsg
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        return -1
    end

    call ChangeToRemoteFSComplete

    drop newPath
return

/*:VRX         FTPRemoveDir
*/
FTPRemoveDir:
    removePath = VRInfo("removeDir")

    rc = FtpRmDir(removePath)
    if (rc <> 0) then do
        call FTPErrMsg
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        return -1
    end

    call ChangeToRemoteFSComplete

    drop removePath
return

/*:VRX         FTPRenameFiles
*/
FTPRenameFiles:
    /* Get the list of files to rename, then rename them one at a time.
     */
    call VRMethod "Application", "GetVar", "renameFiles."

    /* HOWARD, do not remove 'DoRefresh'. It's used below the DO-Loop
     */
    DoRefresh = 'FALSE'
    do i = 1 to renameFiles.0
        RenamedFile = PromptDlg( "Rename Local File", ,
                                 "Rename" renameFiles.i, ,
                                 renameFiles.i )

        if ( RenamedFile = "") then
            iterate
        else
            DoRefresh = 'TRUE'

        rc = FtpRename( renameFiles.i, RenamedFile )
        if ( FTPERRNO <> 0 ) then  call FTPErrMsg
    end /* do */

    rc = VRMethod( "Application", "PostQueue", 0, 1, "call EnableRemoteLists" )

    if ( DoRefresh = 'TRUE' ) then
        call ChangeToRemoteFSComplete

return

/*:VRX         GetFilesNoRename
*/
GetFilesNoRename:
    rc = VRMethod( "Application", "GetVar", "getFiles." )
    rc = VRMethod( "Application", "GetVar", "getFilesSize." )

    do i = 1 to getFiles.0
        local_file = getFiles.i

        /* If user has indicated to show download progress, then start thread
         * that monitors that; else, just download the file
         */
        if ( VRGetIni( "VxFTP", "ProgInd", IniFile, "NoClose" ) = "1" ) then do
            call SpawnXferProgress local_file getFilesSize.i
            rc = FtpGet( local_file, getFiles.i, XferType )
            rc = VRMethod( "Application", "HaltThread", XferProgTID )
            if (rc = 1) then
                call BasicErrMsg "Couldn't kill XferThread" XferProgTID
          end
        else do
            TextToSend = 'call VRSet "MainWindow", "StatusText", "Getting ""' || getFiles.i || '"" "'
            rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
            rc = FtpGet( local_file, getFiles.i, XferType )
        end

        if (FTPERRNO <> 0) then
            call FTPErrMsg
        else do
            comments = "Downloaded from" Host "from" GRemotePath "using VxFTP on" Date('L') "at" Time('Civil')
            comments = 'DFFF00000100FDFF'x || d2c( length(comments)) || '00'x || comments
            call SysPutEA local_file, ".COMMENTS", comments
        end 
    end /* do */

    rc = VRMethod( "Application", "PostQueue", 0, 1, ,
        'call GetComplete' )

return

/*:VRX         GetFilesRenamed
*/
GetFilesRenamed:
    rc = VRMethod( "Application", "GetVar", "getFiles." )
    rc = VRMethod( "Application", "GetVar", "getFilesSize." )

    do i = 1 to getFiles.0
        local_file = PromptDlg( "Get with Renaming", ,
                                "Get" getFiles.i "as..", getFiles.i )

        if ( local_file = "" ) then
            iterate

        /* If user has indicated to show download progress, then start thread
         * that monitors that; else, just download the file
         */
        if ( VRGetIni( "VxFTP", "ProgInd", IniFile, "NoClose" ) = "1" ) then do
            call SpawnXferProgress local_file getFilesSize.i
            rc = FtpGet( local_file, getFiles.i, XferType )
            rc = VRMethod( "Application", "HaltThread", XferProgTID )
            if (rc = 1) then
                call BasicErrMsg "Couldn't kill XferThread" XferProgTID
          end
        else do
            TextToSend = 'call VRSet "MainWindow", "StatusText", "Getting ""' || getFiles.i || '"" as ""' || local_file || '"" "'
            rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
            rc = FtpGet( local_file, getFiles.i, XferType )
        end

        if (FTPERRNO <> 0) then
            call FTPErrMsg
        else do
            comments = "Downloaded" getFiles.i "from" Host "from" GRemotePath "using VxFTP on" Date('L') "at" Time('Civil')
            comments = 'DFFF00000100FDFF'x || d2c( length(comments)) || '00'x || comments
            call SysPutEA local_file, ".COMMENTS", comments
        end 
    end /* do */

    rc = VRMethod( "Application", "PostQueue", 0, 1, ,
        'call GetComplete' )
    
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    signal on syntax name syntax_handler
    FTPFuncsLoaded = 'NO'
    if RxFuncQuery("FtpLoadFuncs") then
        do
        rc = RxFuncAdd("FtpLoadFuncs", "RxFtp", "FtpLoadFuncs")
        rc = FtpLoadFuncs()
    end
    FTPFuncsLoaded = 'YES'

    /* Get the path to the VxFTP .ini file                           */
    rc = VRMethod( "Application", "GetVar", "IniFile"  )

    /* Have the UserInterface side display the Login dialog box      */
    rc = VRMethod("Application", "PostQueue", 0, 1, "call GetLoginInfo")

    call SetupDirCacheTable
    XferType = VRGetIni( "VxFTP", "XferType", IniFile, "NoClose" )

    drop window
return

/*:VRX         LogonToHost
*/
LogonToHost:
    Host    = VRInfo( "Host" )
    Login   = VRInfo( "Login" )
    Passwd  = VRInfo( "Passwd" )
    rCWD    = VRInfo( "rCWD" )
    Anon    = VRInfo( "Anon" )
    SysType = VRInfo( "SysType" )

    /* Put firewall information here */
    rc = FtpSetUser(Host, Login, Passwd)
    if ( rc = 0 ) then
        call BasicErrMsg "Couldn't set User information."

    rc = FtpPwd( junk )     /* Verify connection & get remote host's current PWD */
    if (rc = -1) then do
        if ( FTPERRNO = "FTPLOGIN" ) then
            if ( VRGetIni( "VxFTP", "UseTimer", IniFile, "NoClose" ) = 1 ) then do
                rc = VRMethod( "Application", "PostQueue", 0, 1, ,
                     "call LoginAttemptFailed" )
                return -1
            end
        else do
            rc = VRMethod( "Application", "PostQueue", 0, 1, ,
                 "call LogoffSuccessful" )
            call FTPErrMsg
        end
        return -1
    end

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Successfully connected to' Host '"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    /* Find out the size of the cache table that the user specified  */
    MaxTableSize = VRGetIni( "VxFTP", "CacheSize", IniFile, "NoClose" )

    /* If user specified a directory, change to it          */
    if (rCWD <> "" ) then do
        rc = FtpChDir(rCWD)
        if (rc = -1) then
            call BasicErrMsg "Couldn't change to remote directory specified."
    end

    /* Find out system type                                */
    if ( SysType = 'auto detect' ) then do
        drop SysType     /*  Drop SysType so that call to FtpSys works properly  */
        rc = FtpSys( SysType )
        select
            when ( translate( left( SysType,4 ) = "UNIX" )) then do
                SysType = "UNIX"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysUNIX_Click" )
              end
            when ( translate( left( SysType,4 ) = "OS/2" )) then do
                SysType = "PC"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysOS2_Click" )
              end
            when ( translate( left( SysType,3 ) = "VMS" )) then do
                SysType = "VMS"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysVMS_Click" )
              end
            when ( SysType = "Windows_NT version 3.50" ) then do
                SysType = "NT"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysNT_Click" )
              end
            when ( translate( left( SysType,5 ) = "MACOS" )) then do
                SysType = "MAC"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysMac_Click" )
              end
            when ( translate( left( SysType,2 ) = "VM" )) then do
                SysType = "VM"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysVM_Click" )
              end
            otherwise
                SysType = "UNIX"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysUnknown_Click" )

        end /* select */

     end /* if */
    else 
        select
            when ( SysType = 'OS/2' )      then do
                SysType = "PC"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysOS2_Click" )
              end
            when ( SysType = 'UNIX' )      then
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysUNIX_Click" )

            when ( SysType = 'Windows NT' )      then do
                SysType = "NT"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysNT_Click" )
              end

            when ( SysType = 'NetWare' )   then do
                SysType = "NW" 
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysNW_Click" )
              end
            when ( SysType = 'VAX VMS' )   then do
                SysType = "VMS"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysVMS_Click" )
              end
            when ( SysType = 'IBM VM' )    then do
                SysType = "VM"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysVM_Click" )
              end
            when ( SysType = 'Macintosh' ) then do
                SysType = "MAC"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysMac_Click" )
              end
            otherwise
                SysType = "UNIX"
                rc = VRMethod( "Application", "PostQueue", 0, 1, "call MI_SysUnknown_Click" )
        end /* select */
    
    /* Enable buttons and menus appropriately     */
    rc = VRMethod( "Application", "PostQueue", 0, 1, "call LogonSuccessful" )

    call SetRemotePath           /* Get value for GRemotePath       */
    call SetRemoteCWD            /* Determine & post Remote CWD     */
    call RemoteDirList           /* Get, parse, & post files & dirs */

return
/*:VRX         MarkCacheEntryStale
*/
MarkCacheEntryStale: 
    do i = 1 to TableSize
        if Table.Dir_Name.i = GRemotePath then do
            Table.Freshness.i = 'STALE'
            leave
        end
    end
return

/*:VRX         ParseRemoteCWD_MAC
*/
ParseRemoteCWD_MAC:
    /* This routine extracts the directories from the RemotePath, placing
       them in a stem variable, RemoteCWDDirs.
     */
    remDirs = translate(GRemotePath, '*', ' ')
    remDirs = translate(remDirs, ' ', '/')
    remDirs = "/ " || remDirs
    numDirs = words(remDirs)
    RemoteCWDDirs.0 = numDirs 

return

/*:VRX         ParseRemoteCWD_NT
*/
ParseRemoteCWD_NT: 
    call ParseRemoteCWD_PC
return

/*:VRX         ParseRemoteCWD_NW
*/
ParseRemoteCWD_NW:
    /* This routine extracts the directories from the RemotePath, placing
       them in a stem variable, RemoteDirs.; It then places RemoteDirs. into
       global memory for the GUI (main) thread access.
     */
    remDirs = translate(GRemotePath, '*', ' ')
    remDirs = translate(remDirs, ' ', '\')
    remDirs = translate(remDirs, ' ', '/')
    remDirs = '/ ' || remDirs
    numDirs = words(remDirs)
    RemoteCWDDirs.0 = numDirs 

return

/*:VRX         ParseRemoteCWD_PC
*/
ParseRemoteCWD_PC:
    /* This routine extracts the directories from the RemotePath, placing
       them in a stem variable, RemoteDirs.; It then places RemoteDirs. into
       global memory for the GUI (main) thread access.
     */

    remDirs = translate(GRemotePath, '*', ' ')
    remDirs = translate(remDirs, ' ', '\')
    remDirs = translate(remDirs, ' ', '/')
    numDirs = words(remDirs)
    RemoteCWDDirs.0 = numDirs 

return

/*:VRX         ParseRemoteCWD_UNIX
*/
ParseRemoteCWD_UNIX:
    /* This routine extracts the directories from the RemotePath, placing
       them in a stem variable, RemoteCWDDirs.
     */
    remDirs = translate(GRemotePath, '*', ' ')
    remDirs = translate(remDirs, ' ', '/')
    remDirs = "/ " || remDirs
    numDirs = words(remDirs)
    RemoteCWDDirs.0 = numDirs 

return

/*:VRX         ParseRemoteCWD_VM
*/
ParseRemoteCWD_VM:
    remDirs = GRemotePath
    numDirs = 1
    RemoteCWDDirs.0 = 1    
return

/*:VRX         ParseRemoteCWD_VMS
*/
ParseRemoteCWD_VMS:
    /* This routine extracts the directories from the RemotePath, placing
     * them in a stem variable, RemoteCWDDirs.
     */
    remDirs = translate( GRemotePath, '.', ']' )
    remDirs = translate( remDirs, ' ', '[' )
    remDirs = translate( remDirs, ' ', '.' )
    numDirs = words( remDirs )
    RemoteCWDDirs.0 = numDirs 

return

/*:VRX         ParseRemoteFileListMAC
*/
ParseRemoteFileListMAC:
    k = 0
    j = 0
    do i = 1 to remote_list.0
        select 
            when (left(remote_list.i, 1) = "-") then
                do
                k = k+1
                parse value remote_list.i with type1 nbr remote_size.k resource month day remote_time.k remote_file.k
                remote_date.k = month day
                end

            when (left(remote_list.i, 1) = "d") then
                do
                j = j+1
                parse value remote_list.i with type1 folder resource month day time remote_dir.j 
                end

            otherwise
                iterate
        end /* end select */
    end /* end do */

    remote_file.0 = k
    remote_size.0 = k
    remote_date.0 = k
    remote_time.0 = k
    remote_dir.0 = j

return

/*:VRX         ParseRemoteFileListNT
*/
ParseRemoteFileListNT: 
    k = 0
    j = 0
    do i = 1 to remote_list.0
        parse value remote_list.i with junk1 junk2 size junk3

        if ( datatype( size, Number ) = 1 ) then do
            k = k+1
            parse value remote_list.i with remote_date.k remote_time.k remote_size.k remote_file.k
          end
        else do
            j = j+1
            parse value remote_list.i with junk1 junk2 junk3 directory
            remote_dir.j = strip( directory ) 
        end

    end /* end do */

    remote_file.0 = k
    remote_size.0 = k
    remote_date.0 = k
    remote_time.0 = k
    remote_dir.0 = j


return

/*:VRX         ParseRemoteFileListNW
*/
ParseRemoteFileListNW:
    k = 0
    j = 0
    do i = 1 to remote_list.0
        select 
            when (left(remote_list.i, 1) = "-") then
                do
                k = k+1
                parse value remote_list.i with type1 nbr poster remote_size.k month day remote_time.k remote_file.k
                remote_date.k = month day
                end
            when (left(remote_list.i, 1) = "d") then
                do
                j = j+1
                parse value remote_list.i with type1 nbr poster size month day time remote_dir.j 
                end
            when (left(remote_list.i, 1) = "l") then
                do
                j = j+1
                parse value remote_list.i with type1 nbr poster size month day time link arrow remote_dir.j 
                end
            otherwise
                iterate
        end /* end select */
    end /* end do */

    remote_file.0 = k
    remote_size.0 = k
    remote_date.0 = k
    remote_time.0 = k
    remote_dir.0 = j

return

/*:VRX         ParseRemoteFileListPC
*/
ParseRemoteFileListPC:
    k = 0
    j = 0
    do i = 1 to remote_list.0
	parse value remote_list.i with size pos2 rest
        select 
            when ( pos2 = "DIR") then
                do
                parse value remote_list.i with size dir date time dirname
                dirname = strip(dirname)
                if (dirname == ".") then
                    iterate
                k = k+1
                remote_dir.k = dirname
                end

            otherwise
                do
                parse value remote_list.i with size rest
                attrib = left( strip(rest), 1)
                if ( attrib = "A" ) | ( attrib = "R" ) then
                    parse value rest with attrib date time filename
                else
                    parse value rest with date time filename

                j = j+1
                remote_file.j = strip( filename )
                remote_size.j = strip( size )
                remote_date.j = strip( date )
                remote_time.j = strip( time )
                end

        end /* end select */
    end /* end do */

    remote_file.0 = j
    remote_size.0 = j
    remote_date.0 = j
    remote_time.0 = j
    remote_dir.0 = k

return

/*:VRX         ParseRemoteFileListUNIX
*/
ParseRemoteFileListUNIX:
    k = 0
    j = 0
    do i = 1 to remote_list.0
        select 
            when (left(remote_list.i, 1) = "-") then
                do
                k = k+1
                parse value remote_list.i with type1 nbr poster stuff remote_size.k month day remote_time.k remote_file.k
                remote_file.k = strip( remote_file.k )
                remote_date.k = month day
                end
            when (left(remote_list.i, 1) = "d") then
                do
                j = j+1
                parse value remote_list.i with type1 nbr poster stuff size month day time remote_dir.j 
                remote_dir.j = strip( remote_dir.j )
                end
            when (left(remote_list.i, 1) = "l") then
                do
                j = j+1
                parse value remote_list.i with type1 nbr poster stuff size month day time link arrow remote_dir.j 
                remote_dir.j = strip( remote_dir.j )
                end
            otherwise
                iterate
        end /* end select */
    end /* end do */

    remote_file.0 = k
    remote_size.0 = k
    remote_date.0 = k
    remote_time.0 = k
    remote_dir.0 = j
return

/*:VRX         ParseRemoteFileListVM
*/
ParseRemoteFileListVM:
    do i = 1 to remote_list.0
        parse value remote_list.i with filename type format lrecl remote_size.i blocks remote_date.i remote_time.i
        remote_file.i = strip( filename ) || "." || strip( type )
    end

    remote_file.0 = i - 1
    remote_size.0 = i - 1
    remote_date.0 = i - 1
    remote_time.0 = i - 1
return

/*:VRX         ParseRemoteFileListVMS
*/
ParseRemoteFileListVMS:
j = 0
k = 0
if ( VMS_ListingType = "VMS_LISTINGTYPE" ) then do
    do i = 1 to remote_list.0
        remote_list.i = strip( remote_list.i )

        if ( remote_list.i <> "" ) then do
            /* The key here is the semicolon in this parse command. All (let's hope)
             * VMS listings have a semi-colon in the filename to denote the version of
             * that file. If the line in remote_list isn't a real file or directory
             * the subsequent variables will be NULL, so we can iterate up.
             */
            parse value remote_list.i with filename ";" num pos1 pos2 pos3 pos4 pos5
            if ( pos1 = "" ) then
                iterate
            select 
                when pos( 'JAN', pos1 ) > 0 then pos1 = 'date'
                when pos( 'FEB', pos1 ) > 0 then pos1 = 'date'
                when pos( 'MA',  pos1 ) > 0 then pos1 = 'date'    
                when pos( 'APR', pos1 ) > 0 then pos1 = 'date'
                when pos( 'JU',  pos1 ) > 0 then pos1 = 'date'
                when pos( 'AUG', pos1 ) > 0 then pos1 = 'date'
                when pos( 'SEP', pos1 ) > 0 then pos1 = 'date'    
                when pos( 'OCT', pos1 ) > 0 then pos1 = 'date'
                when pos( 'NOV', pos1 ) > 0 then pos1 = 'date'
                when pos( 'DEC', pos1 ) > 0 then pos1 = 'date'    
                when pos( 'JAN', pos3 ) > 0 then pos3 = 'date'
                when pos( 'FEB', pos3 ) > 0 then pos3 = 'date'
                when pos( 'MA',  pos3 ) > 0 then pos3 = 'date'    
                when pos( 'APR', pos3 ) > 0 then pos3 = 'date'
                when pos( 'JU',  pos3 ) > 0 then pos3 = 'date'
                when pos( 'AUG', pos3 ) > 0 then pos3 = 'date'
                when pos( 'SEP', pos3 ) > 0 then pos3 = 'date'    
                when pos( 'OCT', pos3 ) > 0 then pos3 = 'date'
                when pos( 'NOV', pos3 ) > 0 then pos3 = 'date'
                when pos( 'DEC', pos3 ) > 0 then pos3 = 'date'    
                otherwise nop   
            end /* select */
            select
                when pos( ':', pos1 ) > 0 then pos1 = 'time'
                when pos( ':', pos2 ) > 0 then pos2 = 'time'
                when pos( ':', pos3 ) > 0 then pos3 = 'time'
                when pos( ':', pos4 ) > 0 then pos4 = 'time'
                otherwise nop
            end /* select */
        leave      /* exit the do-loop once we've got a legit file list entry */
        end /* if */
    end /* do */

    select
        when ( pos1 = 'date' ) & ( pos2 = 'time' ) then
            VMS_ListingType = 1
        when ( pos3 = 'date' ) & ( pos4 = 'time' ) then
            VMS_ListingType = 2
        otherwise
            VMS_ListingType = 2
    end /* select */
end /* if */

do i = 1 to remote_list.0
    if ( remote_list.i = "" ) then 
        iterate

    /* The key here is the semicolon in this parse command. All (let's hope)
     * VMS listings have a semi-colon in the filename to denote the version of
     * that file. If the line in remote_list isn't a real file or directory
     * the subsequent variables will be NULL, so we can iterate up.
     */
    remote_list.i = strip( remote_list.i )
    select
        when VMS_ListingType = 1 then
            parse value remote_list.i with filename ";" num date time size "/" blocks attribs
        when VMS_ListingType = 2 then
            parse value remote_list.i with filename ";" num size date time owner attribs
        otherwise
            parse value remote_list.i with filename ";" num size date time owner attribs
    end /* select */

    if ( num = "" ) then 
        iterate
    if ( right( translate( filename ), 4) = '.DIR' ) then do
        j = j + 1
        length1 = length( strip( filename) )
        remote_dir.j = left( filename, length1 - 4 )
    end
    else do 
        k = k + 1
        remote_file.k = strip( filename )
        remote_size.k = strip( size )
        remote_date.k = strip( date )
        remote_time.k = strip( time )
    end /* else */
end /* do */

remote_dir.0  = j
remote_file.0 = k
remote_size.0 = k
remote_date.0 = k
remote_time.0 = k

return

/*:VRX         PB_CacheChange_Click
*/
PB_CacheChange_Click: 
    /* This function is called if user chooses a directory from the Cached 
     * Directories dialog box. 
     */
    newPath = VRInfo("newPath")

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Changing to' newPath'"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpChDir(newPath)
    if (rc <> 0) then do
        call FTPErrMsg
        TextToSend = 'call VRSet "MainWindow", "StatusText", " "'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        return -1
    end

    call SetRemotePath
    call SetRemoteCWD
    call RemoteDirList

    drop newPath

return

/*:VRX         PostRemoteFiles
*/
PostRemoteFiles: 
    /* Post the variables to the main, UI thread       */
    call VRMethod "Application", "PutVar", "remote_file."
    call VRMethod "Application", "PutVar", "remote_size."
    call VRMethod "Application", "PutVar", "remote_date."
    call VRMethod "Application", "PutVar", "remote_time."
    call VRMethod "Application", "PutVar", "remote_dir."
    call VRMethod "Application", "PutVar", "remote_list."

    /* Make main, UI thread act on data just sent      */
    rc = VRMethod( "Application", "PostQueue", 0, 1, "call SetRemoteDir" )

return

/*:VRX         PromptDlg
*/
PromptDlg: procedure
    Title = arg(1)
    Text  = arg(2)

    if ( arg() = 3 ) then
        value = arg(3)

    Buttons.1 = "OK"
    Buttons.2 = "Cancel"
    Buttons.0 = 2
    
    id = VRPrompt( VRWindow(), Text, "value", Title, "Buttons.", OK, Cancel )
    if ( id = 2 ) | ( id = 0 ) then
        return ""

return value
/*:VRX         PutFilesNoRename
*/
PutFilesNoRename:
    rc = VRMethod( "Application", "GetVar", "putFiles." )

    do i = 1 to putFiles.0
        TextToSend = 'call VRSet "MainWindow", "StatusText", "Putting' putFiles.i'"'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

        rc = FtpPut(putFiles.i, putFiles.i, XferType )
        if (FTPERRNO <> 0) then  call FTPErrMsg
    end /* do */

    rc = VRMethod( "Application", "PostQueue", 0, 1, 'call PutComplete' )

    call ChangeToRemoteFSComplete
return

/*:VRX         PutFilesRenamed
*/
PutFilesRenamed:
    rc = VRMethod( "Application", "GetVar", "putFiles." )

    do i = 1 to putFiles.0
        remote_file = PromptDlg( "Put with Renaming", ,
                                 "Put" putFiles.i "as..", putFiles.i )

        TextToSend = 'call VRSet "MainWindow", "StatusText", "Putting ""' || putFiles.i || '"" as ""' || remote_file'"""'
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

        rc = FtpPut( putFiles.i, remote_file, XferType )
        if (FTPERRNO <> 0) then  call FTPErrMsg
    end /* do */

    rc = VRMethod( "Application", "PostQueue", 0, 1, 'call PutComplete' )

    call ChangeToRemoteFSComplete

return

/*:VRX         Quit
*/
Quit:
    rc = FtpLogoff()
    rc = FtpDropFuncs()
    signal _VREHalt

 /*   window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
 */
return

/*:VRX         RefreshCacheEntry
*/
RefreshCacheEntry: 
    /* Refresh the cache's entry because the Refresh
     * Interval has expired or because the directory
     * contents have changed due to user's actions. 
     */

    j = arg(1)

    /* Refresh cached directory entry                 */
    Table.Freshness.j  = 'FRESH'
    Table.CreateTime.j = time(minutes)
    do i = 1 to remote_file.0
        Table.files.j.i = remote_file.i
        Table.dates.j.i = remote_date.i
        Table.sizes.j.i = remote_size.i
        Table.times.j.i = remote_time.i
    end
    Table.files.j.0 = remote_file.0
    Table.dates.j.0 = remote_file.0
    Table.sizes.j.0 = remote_file.0
    Table.times.j.0 = remote_file.0

    do i = 1 to remote_dir.0
        Table.dirs.j.i = remote_dir.i
    end
    Table.dirs.j.0 = remote_dir.0

    drop i j

return

/*:VRX         RefreshRemoteLists
*/
RefreshRemoteLists: 

    do CachedEntryIndex = 1 to TableSize
        if ( GRemotePath = Table.Dir_Name.CachedEntryIndex ) then do
            call DownloadNParseList
            call RefreshCacheEntry CachedEntryIndex
            leave
        end
    end

return

/*:VRX         Remote_CWD_Click
*/
Remote_CWD_Click:
    selected = VRInfo("selectedDir")

    /* The stem variable RemoteCWDDirs. is not dropped in SetRemoteCWD,
     * so we know RemoteCWDDirs.'s values and number of elements.
     */
    select
        when ( SysType = 'VMS' ) then do
        /* Dios mio! Que esta mierda de VMS me arrecha!! 
         */
            last1 = RemoteCWDDirs.0
            last2 = last1 - 1
            newPath = RemoteCWDDirs.last1 || "[" || RemoteCWDDirs.last2

            if ( selected = last1 ) | ( selected = last2) then
                newPath = newPath || "]"
            else do
                do i = RemoteCWDDirs.0-2 to selected by -1
                    newPath = newPath || "." || RemoteCWDDirs.i
                end
                newPath = newPath || "]"
            end
        end /* when VMS */

        /* Processing for DOS and UNIX machines */
        Otherwise
            if selected = RemoteCWDDirs.0 then
                newPath = "/"
            else do
                newPath = ""
                do i = RemoteCWDDirs.0-1 to selected by -1
                    newPath = newPath || "/" || RemoteCWDDirs.i
                end
            end
    end /* select */

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Changing to' newPath'"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpChDir(newPath)
    if (rc <> 0) then do
        call FTPErrMsg
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        TextToSend = 'call VRSet "MainWindow", "StatusText", "" '
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

        return -1
    end

    call SetRemotePath
    call SetRemoteCWD
    call RemoteDirList

return

/*:VRX         Remote_Dir_Combo_DoubleClick
*/
Remote_Dir_Combo_DoubleClick:
    newDir = VRInfo("Dir_from_GUI")

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Changing to' newDir'"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpChDir(newDir)
    if (rc <> 0) then do
        call FTPErrMsg
        call VRMethod "Application", "PostQueue", 0, 1, ,
             "call EnableRemoteLists"
        TextToSend = 'call VRSet "MainWindow", "StatusText", "" '
        rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

        return -1
    end

    call SetRemotePath
    call SetRemoteCWD
    call RemoteDirList

    drop newDir
return

/*:VRX         RemoteDirList
*/
RemoteDirList:
    CachedEntryFound = 'FALSE'

    if ( VRGetIni( "VxFTP", "UseCache", IniFile, "NoClose" ) = 0 ) then 
        /* If we don't use the Directory Cache, just download & parse */
        call DownloadNParseList
    else do
        do CachedEntryIndex = 1 to TableSize
            if translate( Table.Dir_Name.CachedEntryIndex ) = translate( GRemotePath ) then do
                CachedEntryFound = 'TRUE'

                if ( Table.Freshness.CachedEntryIndex = 'STALE' ) then do
                    call DownloadNParseList
                    call RefreshCacheEntry CachedEntryIndex
                    leave   /* leave the DO Loop */
                end

                RefreshInterval = VRGetIni( "VxFTP", "RefreshInterval", IniFile, "NoClose")
                if ( time(minutes) - Table.CreateTime.CachedEntryIndex <= RefreshInterval ) then do
                    call UseCachedDirectory
                    leave   /* leave the DO Loop */
                  end
                else do
                    call DownloadNParseList
                    call RefreshCacheEntry CachedEntryIndex
                    leave   /* leave the DO Loop */
                end /* else */
            end /* if */
        end /* do */
        if ( CachedEntryFound = 'FALSE' ) then do
            call DownloadNParseList
            call AddToDirCache
        end
    end /* end else */

return

/*:VRX         ResetFileList
*/
ResetFileList: 
    command = "call ParseRemoteFileList"SysType
    interpret command
return

/*:VRX         SendQuotedMsg
*/
SendQuotedMsg: 
    rc = VRMethod( "Application", "GetVar", "QuotedMsg" )

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Sending message <<'QuotedMsg'>>"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpQuote( QuotedMsg )
    if (FTPERRNO <> 0) then  call FTPErrMsg

    TextToSend = 'call VRSet "MainWindow", "StatusText", ""'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

return

/*:VRX         SendSiteCmd
*/
SendSiteCmd: 
    rc = VRMethod( "Application", "GetVar", "SiteCmd" )

    TextToSend = 'call VRSet "MainWindow", "StatusText", "Sending command <<'SiteCmd'>>"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    rc = FtpSite( SiteCmd )
    if (FTPERRNO <> 0) then  call FTPErrMsg

    TextToSend = 'call VRSet "MainWindow", "StatusText", ""'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

return

/*:VRX         SetAscii
*/
SetAscii: 
    XferType = 'Ascii'
return

/*:VRX         SetBinary
*/
SetBinary: 
    XferType = 'Binary'
return

/*:VRX         SetRemoteCWD
*/
SetRemoteCWD:
    rc = VRMethod("Application", "PostQueue", 0, 1, "call Clear_Remote")

    command = "call ParseRemoteCWD_"SysType
    interpret command

    /* Add the "word"s within "remDirs" to RemoteCWDDirs. stem,
       replacing any astericks with the blank spaces that were
       originally there.
     */
    do i = 1 to numDirs
        RemoteCWDDirs.i = word(remDirs, numDirs-(i-1))
        RemoteCWDDirs.i = translate(RemoteCWDDirs.i, ' ', '*')
    end

    call VRMethod "Application", "PutVar", "RemoteCWDDirs."
    call VRMethod "Application", "PostQueue", 0, 1, "call Set_DDCB_Remote_CWD"

    drop remDirs numDirs
return

/*:VRX         SetRemotePath
*/
SetRemotePath:
    rc = FtpPwd( RemotePWD )
    parse var RemotePWD '"' GRemotePath '"' rest    /* GRemotePath gets 
                                                       RemotePWD cleaned up      */
    drop RemotePWD 
return
/*:VRX         SetSysType
*/
SetSysType:
    SysType = VRInfo( "systype" )

return

/*:VRX         SetupDirCacheTable
*/
SetupDirCacheTable:

    Table.Dir_Name.0 = 0
    Table.Freshness.0 = 0
    Table.CreateTime.0 = 0
    Table.dirs.0.0 = 0
    Table.files.0.0 = 0
    Table.dates.0.0 = 0
    Table.times.0.0 = 0
    Table.sizes.0.0 = 0
    TableIndex = 0
    TableSize = 0
return

/*:VRX         SpawnXferProgress
*/
SpawnXferProgress: procedure expose SysType XferProgTID
    parse arg getFile getFileSize remoteFile

    XferProgTID = VRMethod( "Application", "StartThread", "XferProg", SysType getFile getFileSize remoteFile )

    if ( XferProgTID = -1 ) then
        call BasicErrMsg "Couldn't start 'XferProgress' thread for" getFile
return

/*:VRX         syntax_handler
*/
syntax_handler: 
    if ( FTPFuncsLoaded = 'NO' ) then do
        call VRMethod "Application", "PostQueue", 0, 1, ,
            "Call BasicErrMsg 'Could not load FTP functions.'"
        call VRMethod "Application", "PostQueue", 0, 1, ,
            "Call Quit"
     end
    else
        call VRMethod "Application", "PostQueue", 0, 1, ,
            "Call BasicErrMsg 'Remote Function call failed.'"
        
return

/*:VRX         UseCachedDirectory
*/
UseCachedDirectory: 
    /* Given the index "CachedEntryIndex" into the Cache table
     * assign the Table values to the remote_* stems. Then post
     * to the GUI thread.
     */
    TextToSend = 'call VRSet "MainWindow", "StatusText", "Extracting file list from cache"'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    do j = 1 to Table.files.CachedEntryIndex.0
        remote_file.j = Table.files.CachedEntryIndex.j
        remote_size.j = Table.sizes.CachedEntryIndex.j
        remote_date.j = Table.dates.CachedEntryIndex.j
        remote_time.j = Table.sizes.CachedEntryIndex.j
    end
    remote_file.0 = j - 1
    remote_size.0 = j - 1
    remote_date.0 = j - 1
    remote_time.0 = j - 1

    do j = 1 to Table.dirs.CachedEntryIndex.0
        remote_dir.j = Table.dirs.CachedEntryIndex.j
    end
    remote_dir.0 = j - 1

    call PostRemoteFiles

    TextToSend = 'call VRSet "MainWindow", "StatusText", " "'
    rc = VRMethod( "Application", "PostQueue", 0, 1, TextToSend )

    drop j
return

/*:VRX         ViewFiles
*/
ViewFiles:
    call VRMethod "Application", "GetVar", "filesToView."
    call VRMethod "Application", "GetVar", "filesToViewSize."

    /* Check whether or not user wants to use the E system
     * editor to view files.
     */
    EEditor = VRGetIni( "VxFTP", "EEditor", IniFile, "NoClose" )

    do i = 1 to filesToView.0
        if ( EEditor = 1 ) then
            localfile = filesToView.i
        else
            localfile = SysTempFileName('ViewTemp.???')

/*        call SpawnXferProgress localfile filesToViewSize.i
 */
        if ( SysType = "UNIX" | SysType = "VM" ) then
            rc = FtpGet( localfile, filesToView.i, "ASCII" )
        else
            rc = FtpGet( localfile, filesToView.i, "BINARY" )
        if (FTPERRNO <> 0) then call FTPErrMsg

        if ( EEditor = 1 ) then do
            command = 'start /f e "' || localfile || '"'
            address cmd command
        end
        else do
            /* Must indicate that we're Viewing a text from a remote site, so that
             * we can delete it once we've brought it down. (When viewing local
             * files, we don't delete the file!! )
             */
            TextFileTID = VRMethod("Application", "StartThread", "TextFile", localfile"||"filesToView.i"||REMOTE" )
            if TextFileTID = 0 then
                call BasicErrMsg "Couldn't start View Text File thread."
        end /* else */
    end /* do */
    
    rc = VRMethod( "Application", "PostQueue", 0, 1, "call XferComplete 'NoShow'" )

    drop EEditor command
return

