/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         BasicErrMsg
*/
BasicErrMsg:
    /* Easy way of showing simple error messages, thanks to VX-REXX's
     * ability to expand the dialog box to fit the message.
     */
    ErrMessage = arg(1)

    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), ErrMessage, "Error", ,
                     "Error", "Buttons.", OK, Cancel )
    drop ErrMessage
return

/*:VRX         BuildAliasList
*/
BuildAliasList:
    rc = VRMethod( "Application", "GetVar", "IniFile" )
    Aliases = VRGetIni( "VxFTP", "Aliases", IniFile )

    if ( Aliases = "" ) then 
        LAliases.0 = 0
    else do
       /* Create the LAliases. variable for holding the Aliases
        */
        i = 0
        do until Aliases = ""
            i = i + 1
            parse value Aliases with LAliases.i "}{" Aliases
        end
        LAliases.0 = i

       /* Build the Alias list in AliasName. for displaying the 
        * Aliases' names in the list box
        */
        do i = 1 to LAliases.0
            parse value LAliases.i with AliasName.i "|" junk
        end
        AliasName.0 = i - 1

        rc = VRMethod( "DDCB_Aliases", "AddStringList", "AliasName.",  )

        drop junk
    end

return

/*:VRX         BuildHostOSList
*/
BuildHostOSList:
    HostOS.1 = "auto detect"
    HostOS.2 = "OS/2"
    HostOS.3 = "UNIX"
    HostOS.4 = "Windows NT"
    HostOS.5 = "NetWare"
    HostOS.6 = "IBM VM"
    HostOS.7 = "VAX VMS"
    HostOS.8 = "Macintosh"
    HostOS.0 = 8
    rc = VRMethod( "DDCB_HostOS", "AddStringList", "HostOS.",  )
    rc = VRSet( "DDCB_HostOS", "Value", HostOS.1 )

return

/*:VRX         CB_AnonFtp_Click
*/
CB_AnonFtp_Click:
    AnonFTP = VRGet( "CB_AnonFtp", "Set" )
    if ( AnonFTP = 1 ) then do
        rc = VRSet( "EF_Login", "Value", "anonymous" )
        rc = VRMethod( "Application", "GetVar", "IniFile" )
        anonPasswd = VRGetIni( "VxFTP", "Email", IniFile )
        
        if ( rc = 1 ) then
            rc = VRSet( "EF_Password", "Value", anonPasswd )
        else
            rc = VRSet( "EF_Password", "Value", "os2user@here.org" )
    end
    else do
        rc = VRSet( "EF_Login", "Value", "" )
        rc = VRSet( "EF_Password", "Value", "" )
    end /* else */
return

/*:VRX         DDCB_Aliases_Click
*/
DDCB_Aliases_Click:
    /* Get all the data associated with the Alias that the User 
     * selected and stick it in the entry fields
     */
    aliasSelected = VRGet( "DDCB_Aliases", "SelectedString" )

    if ( aliasSelected = "" ) | ( LAliases.0 = 0 ) then
        return
    else do
        do i = 1 to AliasName.0 
            if (AliasName.i \= aliasSelected) then 
                iterate

            else do
                parse value LAliases.i with junk "|" AliasHost "|" AliasLogin "|" AliasPasswd "|" AliasCWD "|" AliasHostOS
                call VRSet "EF_Host",     "Value", AliasHost
                call VRSet "DDCB_HostOS", "Value", AliasHostOS
                call VRSet "EF_Login",    "Value", AliasLogin
                call VRSet "EF_Password", "Value", AliasPasswd
                call VRSet "EF_CWD",      "Value", AliasCWD

                if ( translate( AliasLogin ) = "ANONYMOUS" ) | ,
                   ( translate( AliasLogin ) = "FTP" ) then
                    rc = VRSet( "CB_AnonFtp", "Set", 1 )
                else
                    rc = VRSet( "CB_AnonFtp", "Set", 0 )

            end /* end else */

        end /* end do */
    end /* end else */

    drop junk
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

/* return the stuff we packaged in PB_OK (in retCode) */

return retCode

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Initialize the Login() function's return code (retCode)
     * to null.
     */
    retCode = ""
    call BuildAliasList
    call BuildHostOSList

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    call VRMethod "EF_Host", "SetFocus"
    drop window
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call Quit
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click:

    host = VRGet("EF_Host", "Value")
    login = VRGet("EF_Login", "Value")
    passwd = VRGet("EF_Password", "Value")
    cwd = VRGet("EF_CWD", "Value")
    systype = VRGet( "DDCB_HostOS", "Value" )

    if ( host = "" ) | ( login = "" ) then do
        call BasicErrMsg "You must specify a Host and Login"
        return -1
    end

    /* Strip away leading or trailing blanks        */
    host = strip(host)
    login = strip(login)
    passwd = strip(passwd)
    cwd = strip(cwd)

    /* If user sets the "Add to Alias" checkbox, then add 
     * values in all the fields and call UpdateAliases to
     * save it in the IniFile.
     */
    AddAlias = VRGet( "CB_AddToAlias", "Set" )
    if ( AddAlias = 1 ) then do
        NewAlias = VRGet( "DDCB_Aliases", "Value" )
        if ( NewAlias = "" ) then do
            call BasicErrMsg "You must specify an Alias Name"
            return -1
        end

        do i = 1 to LAliases.0
            if ( NewAlias = AliasName.i ) then do
                leave /* leave the do-loop */
            end /* if */        
        end /* do */

        /* Going all the way through a DO-loop sequence has the side
         * effect of leaving your index variable (i) incremented by
         * one above the upper bound (LAliases.0). So to add on, we
         * just use the index, i, as the new upper bound.
         */
        if ( i > LAliases.0 ) then
            LAliases.0 = i
        LAliases.i = NewAlias || "|" || host || "|" || login || "|" || passwd || "|" || cwd || "|" || systype
 
        call UpdateAliases
    end

    Anon = VRGet( "CB_AnonFtp", "Set" )
    if ( Anon = 1 ) then
        Anon = "TRUE"
    else
        Anon = "FALSE"

    retCode = host || "|" || login || "|" || passwd || "|" || cwd || "|" || Anon || "|" || systype
    call Quit

return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         UpdateAliases
*/
UpdateAliases:
    /* Extract the Aliases from the LAlias stem and update
     * the Aliases in the IniFile.
     */
    NewAliases = ""
    do i = 1 to LAliases.0
        NewAliases = NewAliases || LAliases.i || "}{"
    end

    rc = VRSetIni( "VxFTP", "Aliases", NewAliases, IniFile )

    drop NewAliases

return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

