/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         AliasDEWindow_Close
*/
AliasDEWindow_Close:
    /* call Quit */
return

/*:VRX         AliasDEWindow_Create
*/
AliasDEWindow_Create:
    if ( word( InitArgs.1, 1) = 'EDIT' ) then do
        rc = VRSet( "EF_AliasName",   "Value", InitArgs.2 )
        rc = VRSet( "EF_AliasHost",   "Value", InitArgs.3 )
        rc = VRSet( "EF_AliasLogin",  "Value", InitArgs.4 )
        rc = VRSet( "EF_AliasPasswd", "Value", InitArgs.5 )
        rc = VRSet( "EF_AliasCWD",    "Value", InitArgs.6 )
        rc = VRSet( "DDCB_HostOS",    "Value", InitArgs.7 )

        if ( translate( InitArgs.4 ) = "ANONYMOUS" ) | ,
           ( translate( InitArgs.4 ) = "FTP" ) then
            rc = VRSet( "CB_AnonFtp", "Set", 1 )            
    end 
return

/*:VRX         BasicErrMsg
*/
BasicErrMsg: 
    /* Easy way of showing simple error messages, thanks to VX-REXX's
     * ability to expand the dialog box to fit the message.
     */
    ErrMessage = arg(1)

    OK = 1
    Buttons.OK = "OK"
    Cancel = 2
    Buttons.Cancel = "Cancel"
    Buttons.0 = 2
    
    id = VRMessage( VRWindow(), ErrMessage, "Error", ,
                     "Error", "Buttons.", OK, Cancel )
    drop ErrMessage

return

/*:VRX         BuildHostOSList
*/
BuildHostOSList:
    HostOS.1 = "auto detect"
    HostOS.2 = "OS/2"
    HostOS.3 = "UNIX"
    HostOS.4 = "NetWare"
    HostOS.5 = "Windows NT"
    HostOS.6 = "IBM VM"
    HostOS.7 = "VAX VMS"
    HostOS.8 = "Macintosh"
    HostOS.0 = 8
    rc = VRMethod( "DDCB_HostOS", "AddStringList", "HostOS.",  )
    if ( word( InitArgs.1, 1) = 'NEW' ) then
        rc = VRSet( "DDCB_HostOS", "Value", "auto detect" )


return

/*:VRX         CB_AnonFtp_Click
*/
CB_AnonFtp_Click:
    AnonFTP = VRGet( "CB_AnonFtp", "Set" )
    if ( AnonFTP = 1 ) then do
        rc = VRSet( "EF_AliasLogin", "Value", "anonymous" )
        rc = VRMethod( "Application", "GetVar", "IniFile" )
        AnonPasswd = VRGetIni( "VxFTP", "Email", IniFile )

        if ( rc = 1 ) then
            rc = VRSet( "EF_AliasPasswd", "Value", AnonPasswd )
        else
            rc = VRSet( "EF_AliasPasswd", "Value", "os2user@here.org" )
    end
    else do
        rc = VRSet( "EF_AliasLogin",  "Value", "" )
        rc = VRSet( "EF_AliasPasswd", "Value", "" )
    end /* else */
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

return retCode

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    call BuildHostOSList

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    retCode = ""
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call Quit
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click:

    alias = VRGet( "EF_AliasName", "Value" )
    if ( alias = "" ) then do
        call BasicErrMsg "Alias must have a name"
        return
    end

    host = VRGet("EF_AliasHost", "Value")
    if ( host = "" ) then do
        call BasicErrMsg "Alias must have a host"
        return
    end

    hostOS = VRGet( "DDCB_HostOS", "Value" )
    login = VRGet("EF_AliasLogin", "Value")
    if ( login = "" ) then do
        call BasicErrMsg "Alias must have a Login name"
        return
    end

    passwd = VRGet("EF_AliasPasswd", "Value")
    cwd = VRGet("EF_AliasCWD", "Value")

    /* Strip away leading or trailing blanks        */
    alias  = strip(alias)
    host   = strip(host)
    login  = strip(login)
    passwd = strip(passwd)
    cwd    = strip(cwd)


    retCode = alias || "|" || host || "|" || login || "|" || passwd || "|" || cwd || "|" || hostOS
    call Quit

return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

