/* TESTREXX.CMD */
/* An example test script for the vanilla version of TESTREXX.DLL. This tests some of
    the TestDummy functions that actually return something. It's just to get you started
    writing your own test script.
*/

/* The TestLoadFuncs loads all the rest of the REXX functions in the TESTREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call TestLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'TestLoadFuncs', 'TESTREXX', 'TestLoadFuncs'
CALL TestLoadFuncs

/* ========================= TestDummy1 ========================== */
SAY "Calling...TestDummy1('my string'). Should be 'my string'"
str = TestDummy1('my string')
SAY str

/* ========================= TestDummy2 ========================== */
SAY "Calling...TestDummy2('my string'). Should be null"
str = TestDummy2('my string')
SAY str

SAY "Calling...TestDummy2(346). Should be 346"
str = TestDummy2(346)
SAY str

val=-46
SAY "Calling...TestDummy2(-46). Should be -46"
str = TestDummy2(val)
SAY str

/* ========================= TestDummy3 ========================== */
SAY "Calling...TestDummy3('my string', 45). Should be null"
str = TestDummy3('my string', 45)
SAY str

SAY "Calling...TestDummy3(45, 45). Should be 90."
str = TestDummy3(45, 45)
SAY str

val=-45
SAY "Calling...TestDummy3(-45, 45). Should be 0."
str = TestDummy3(val, 45)
SAY str

/* ========================= TestDummy4 ========================== */
SAY "Calling...TestDummy4('my name is ', 'Jeff'). Should be 'my name is Jeff'"
str = TestDummy4('my name is ', 'Jeff')
SAY str

/* ========================= TestDummy5 ========================== */
SAY "Calling...TestDummy5('my string', 45). Should produce an error."
str = TestDummy5('my string', 45)
IF str = "" THEN SAY "ERROR"
IF str <> "" THEN SAY TestSum

SAY "Calling...TestDummy5(45, 45). Should be 90"
str = TestDummy5(45, 45)
IF str = "" THEN SAY "ERROR"
IF str <> "" THEN SAY TestSum

/* ========================= TestDummy6 ========================== */
SAY "Calling...TestDummy6(2, 45). Should be 47 and 90."
str = TestDummy6(2, 45)
IF str = "" THEN SAY "ERROR"
IF str <> "" THEN SAY TestResult.0  TestResult.1

/* ========================= TestDummy7 ========================== */
SAY "Calling...TestDummy7('hello', 'HELLO'). Should be positive number."
str = TestDummy7('hello', 'HELLO')
SAY str

SAY "Calling...TestDummy7('hello', 'HELLO', 'i'). Should be 0."
str = TestDummy7('hello', 'HELLO', 'i')
SAY str

SAY "Calling...TestDummy7('hello', 'HELLO', 's'). Should be positive number."
str = TestDummy7('hello', 'HELLO', 's')
SAY str

SAY "Calling...TestDummy7('hello', 'hillo'). Should be negative number."
str = TestDummy7('hello', 'hillo')
SAY str

/* ========================= TestDummy8 ========================== */
SAY "Calling...TestDummy8(''). Should be TESTVAL."
str = TestDummy8('')
SAY str

TestVal = 'This is a test'
SAY "Calling...TestDummy8(''). Should be 'This is a test'."
str = TestDummy8('')
SAY str

/* =============================================================================== */
/* TestDropFuncs: This unloads all of the functions in the TESTREXX DLL. */
/* We could otherwise leave them registered for some other REXX script */
CALL TestDropFuncs
