/* TEST80A.CMD - Parent calling TEST80B child with Queue data */ /* 0001 */
trace_type = VALUE( 'TRACE',, 'OS2ENVIRONMENT' )                 /* 0002 */
trace value trace_type; nop                                      /* 0003 */
                                                                 /* 0004 */
/* setup queue structure */                                      /* 0005 */
queue_name     = 'TEST80'                                        /* 0006 */
new_queue_name = RxQueue( 'CREATE', queue_name )  /* create queue    */
old_queue      = RxQueue( 'SET', new_queue_name ) /* name new active */
                                                                 /* 0009 */
/* put lines into queue */                                       /* 0010 */
do i = 1 to 2                                                    /* 0011 */
   output_line = 'TEST80 - Line number' i                        /* 0012 */
   queue output_line                                             /* 0013 */
end                                                              /* 0014 */
                                                                 /* 0015 */
/* Start TEST80B.CMD (child) to read queue & wait for it to finish */
'start "Test80B Child" /MIN TEST80B.CMD' new_queue_name,         /* 0017 */
                                         i - 1,                  /* 0018 */
                                         trace_type              /* 0019 */
do forever                                                       /* 0020 */
   call SysSleep 2                                               /* 0021 */
   if QUEUED() = 0 then leave                                    /* 0022 */
end                                                              /* 0023 */
                                                                 /* 0024 */
/* Kill new queue */                                             /* 0025 */
call RxQueue 'DELETE', new_queue_name                            /* 0026 */
if result <> 0 then                                              /* 0027 */
   do                                                            /* 0028 */
      say 'Delete unsuccessful, return code =' RESULT            /* 0029 */
   end                                                           /* 0030 */
call RxQueue 'SET', old_queue                                    /* 0031 */
exit                                                             /* 0032 */
