/*------------------------------------------------------------------
 * SNPP Client. Autor unknown, modified by Igor Vaskov 2:5020/207.27.
 * Usage: SNPP.CMD <IP_SNPPSERVER> <USERID> <PASSWORD> <PAGERID> <MESSAGE>
 * Example:
 * SNPP.CMD 127.0.0.1 userid password 12 Hello World.
--------------------------------------------------------------------*/
/*pull*/
TimeOut=60
port = 444
userid = "userid"
password = "password"
Cove = "128"
debug=0
log_file="snpp_out.log"
dt=DATE('S')
tm=TIME('N')

koi_itable=' !""#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_``abcdefghijklmnopqrstuvwxyz{|}~H                椥娩p㦢ꞀH'
koi_otable=' !""#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_``abcdefghijklmnopqrstuvwxyz{|}~'
endl='0D'x'0A'x

parse arg server userid password pager mess

log_buf=dt tm server pager length(mess) mess
mess=TRANSLATE(mess,koi_otable,koi_itable) /*     -8 */

/*------------------------------------------------------------------
 * initialize socket package
 *------------------------------------------------------------------*/
   if RxFuncQuery("SockLoadFuncs") then
      do
      rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
      rc = SockLoadFuncs()
      end
/*------------------------------------------------------------------
 * get server name
 *------------------------------------------------------------------*/
   rc = SockGetHostByName(server,"host.!")
   if (rc = 0) then
        do
        say "Error" h_errno "calling SockGetHostByName("server")"
        call log_store 'Error 'h_errno
        exit
        end

   server = host.!addr;

/*---------------------------------------------------------------
 * open socket
 *---------------------------------------------------------------*/
socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (socket = -1) then
        do
        say "Error on SockSocket:" errno
        call log_store errno
        exit
        end

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*---------------------------------------------------------------
 * connect socket
 *---------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = server
if debug=1 then say 'Connect ------>>'
rc = SockConnect(socket,"server.!")
if (rc = -1) then
   do
   call log_store errno h_errno
   say "Error on SockConnect:" errno h_errno
   exit
   end

/*------------------------------------------------------------------
 * receive the result from the server
 *------------------------------------------------------------------*/
rc = snpp_get("newData")
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockRecv:" errno
   exit
   end
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)
if debug=1 then say '<<----'newData
if substr(newData,1,3)<>220 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end

/*------------------------------------------------------------------
 * send the login/password
 *------------------------------------------------------------------*/
if debug=1 then say 'Userid/password ------->>'
rc = SockSend(socket,'LOGI 'userid' 'password''endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end
rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end

/*------------------------------------------------------------------
 * send the coverage
 *------------------------------------------------------------------*/
if debug=1 then say 'COVERAGE ------->>'
rc = SockSend(socket,'COVE 'cove''endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end
rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end

/*------------------------------------------------------------------
 * send the pagerid
 *------------------------------------------------------------------*/
if debug=1 then say 'Pager ID ------->>'
rc = SockSend(socket,'PAGE 'pager''endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end
rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end


/*------------------------------------------------------------------
 * send mess
 *------------------------------------------------------------------*/
if debug=1 then say 'Mess ------->>'
rc = SockSend(socket,'MESS 'mess''endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end

rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end

/*------------------------------------------------------------------
* send SEND
 *------------------------------------------------------------------*/
if debug=1 then say 'Send ------->>'
rc = SockSend(socket,'SEND 'endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end

rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end
/*------------------------------------------------------------------
* send QUIT
 *------------------------------------------------------------------*/
if debug=1 then say 'Quit ------->>'
rc = SockSend(socket,'QUIT 'endl)
if (rc = -1) then
   do
        call log_store errno
   say "Error on SockSend:" errno
   exit
   end

rc = snpp_get("newData")
newData=STRIP(newData,L,'0d'x)
newData=STRIP(newData,L,'0a'x)
newData=STRIP(newData,L,'0d'x)

if debug=1 then say '<<----'newData
if substr(newData,1,3)<>250 then
        do
        call log_store newData
        rc=snpp_close()
        exit
        end

call log_store 'OK'
rc = SockSoClose(socket)
exit
/*------------------------------------------------------------------
 * close socket (and catch signals)
 *------------------------------------------------------------------*/

halt:

rc = SockSoClose(socket)
if (rc = -1) then
   do
   say "Error on SockSoClose:" errno
   exit
   end

exit

snpp_get:
arg rcbuf
rc=0
elapsed=0
tm=time('r')
DO WHILE rc<3 | elapsed > TimeOut
if debug=1 then say recieved loop
rc = SockRecv(socket,rcbuf,256)
if (rc = -1) then
   do
   say "Error on SockRecv:" errno
   rc = SockSoClose(socket)
   exit
   end
elapsed=time('e')
END
if (rc = 0) then
   do
   say "TimeOut on SockRecv"
   rc = SockSoClose(socket)
   exit
   end

return rc
snpp_close:
rc = SockSend(socket,'QUIT 'endl)
rc = SockSoClose(socket)
return 0

log_store:
arg note
call lineout log_file, log_buf note
call lineout log_file
return 0