/*****************************************************************************\
| Places the result of an OS/2 command in the program stack.                  |
|                                                                             |
| $Revision:   1.0  $
|     $Date:   03 Aug 1995 20:10:22  $                                        |
| Libraries:   REXXSAA, REXXUTIL                                              |
|  Category:   Utility                                                        |
|     Class:   Program                                                        |
|      Type:   Queue                                                          |
|    Author:   Bob Rice - CompuServe: 72421,3016                              |
|                                                                             |
| Copyright (c) 1995 Empirical Heuristics                                     |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse arg cmd, opts
  if wordpos('/LIFO', translate(opts)) > 0 then lifo = 1
                                           else lifo = 0
  onque = queued()                              /* Lines already on queue    */
  if lifo then do                               /* Just add command results  */
    '@'cmd '| RxQueue /LIFO'
    queued = queued() - onque
  end
  else do
    do i = 1 to onque                           /* Save queue contents       */
      parse pull oldline.i
    end
    '@'cmd '| RxQueue /FIFO'                    /* Put cmd results on queue  */
    queued = queued()
    do i = 1 to onque                           /* Restore saved contents    */
      queue oldline.i
    end
  end
  exit queued                                   /* Number of lines in result */
/*--Begin Help-----------------------------------------------------------------
This routine executes the specified OS/2 command and places the output, which
is normally written to the console, into the program stack.  It returns the
number of lines it has placed in the stack.  If /LIFO is specified, the lines
are queued in the stack in reverse order.  If there already are lines on the
stack before this program is called, then using /LIFO is faster than not using
it, since no special handling of the existing lines is required.

Params: command [, /LIFO ]

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

___________________
Development History

$Log:   Q:/rxdv/skeleton/vcs/quecmd.cm!  $
  
     Rev 1.0   03 Aug 1995 20:10:22
  Initial revision.
--End Help-------------------------------------------------------------------*/
