/*****************************************************************************\
| Register all RexxUtil and RexxLib external function libraries.              |
|                                                                             |
| $Revision:   1.0  $
|     $Date:   03 Aug 1995 20:10:20  $                                        |
| Libraries:   REXXSAA, [REXXLIB]                                             |
|  Category:   Utility                                                        |
|     Class:   General                                                        |
|      Type:   System                                                         |
|    Author:   Bob Rice - CompuServe: 72421,3016                              |
|                                                                             |
| Copyright (c) 1995 Empirical Heuristics                                     |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse version EH.REXX .
  parse source . . pgm
  parse value filespec('N',pgm) with EH.pgm_fn '.'
  if translate(arg(1)) = '/VOCAL' then vocal = 1; else vocal = 0

  /*=========================================================================*\
  | Register external function routines.                                      |
  \*=========================================================================*/

  /*----------------------------------------*\
  |  Load RexxUtil External Function Module  |
  \*----------------------------------------*/
  if RxFuncQuery('SysLoadFuncs') \= 0 then do
    ok = RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs')
    if ok = 0 then do                           /* Registration okay         */
      if vocal then say EH.pgm_fn': SysLoadFuncs now registered.'
      call SysLoadFuncs
      if result \= '' then do
        say EH.pgm_fn 'ERROR: SysLoadFuncs returned' result,
            'instead of the expected null.'
        exit 1
      end
      else if vocal then say EH.pgm_fn': SysLoadFuncs executed.'
    end
    else do                                     /* Registration error        */
      say EH.pgm_fn 'ERROR: RxFuncAdd returned' ok,
          'when registering SysLoadFuncs.'
      exit 1
    end
  end
  else if vocal then say EH.pgm_fn': SysLoadFuncs already registered.'

  /*-----------------------------------*\
  |  Load the RexxLib Function Package  |
  \*-----------------------------------*/
  if EH.REXX = 'REXX/Personal' then module = 'qrexxlib'
                               else module = 'rexxlib'
  if RxFuncQuery('RexxLibRegister') \= 0 then do
    ok = RxFuncAdd('RexxLibRegister',module,'rexxlibregister')
    if ok = 0 then do                           /* Registration okay         */
      if vocal then say EH.pgm_fn': RexxLibRegister now registered.'
      call RexxLibRegister
      if result \= 1 then do
        say EH.pgm_fn 'ERROR: RexxLibRegister returned' result,
            'instead of the expected 1.'
        exit 1
      end
      else do
        if vocal then say EH.pgm_fn': RexxLibRegister executed.'
        exit 0
      end
    end
    else do                                     /* Registration error        */
      say EH.pgm_fn 'ERROR: RxFuncAdd returned' ok,
          'when registering' module'.'
      exit 1
    end
  end
  else do
    if vocal then say EH.pgm_fn': RexxLibRegister already registered.'
    exit 0
  end
/*--Begin Help-----------------------------------------------------------------
Register all RexxUtil and RexxLib external function libraries.

Params: [ /VOCAL ]

where:

  /VOCAL       reports the progress of the program.

Routine returns 0 if successful, 1 otherwise.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

___________________
Development History

$Log:   Q:/rxdv/skeleton/vcs/funcreg.cm!  $
  
     Rev 1.0   03 Aug 1995 20:10:20
  Initial revision.
--End Help-------------------------------------------------------------------*/
