/*****************************************************************************\
| Error trap subprocessor for standard REXX Skeleton.                         |
|                                                                             |
| $Revision:   1.0  $
|     $Date:   03 Aug 1995 20:10:12  $                                        |
| Libraries:   REXXSAA, [REXXLIB]                                             |
|  Category:   Error Handler                                                  |
|     Class:   Programming                                                    |
|      Type:   Trap                                                           |
|    Author:   Bob Rice - CompuServe: 72421,3016                              |
|                                                                             |
| Copyright (c) 1995 Empirical Heuristics                                     |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  if arg(1) = 'FINISH_UP' then signal Finish_up
  parse arg ., ., ., pgmpath, line

  parse value filespec('N', pgmpath) with TRAP.fn '.' TRAP.fe
  dump_file_name = filespec('D', pgmpath) || filespec('P', pgmpath) ||,
                   TRAP.fn'.DMP'
  /*----------------------------------------*\
  | Check for reason not to create .DMP file |
  \*----------------------------------------*/
  if RxFuncQuery('VARDUMP')  \= 0 then dump_file_name = ''
  if pos(':', dump_file_name) = 0 then dump_file_name = ''
  /*----------------------*\
  | Build trap message box |
  \*----------------------*/
  say ' '
  TRAP.error_description = arg(2) 'error in line' arg(1)'.'
  if arg(3) \= '' then do
    TRAP.error_description = TRAP.error_description ' Error code =' arg(3)'.'
    TRAP.error_message = errortext(arg(3))
  end
  else TRAP.error_message = ''
  if dump_file_name \= '' then TRAP.file_message = 'See:' dump_file_name
                          else TRAP.file_message = ''
  TRAP.msg_width = max(length(TRAP.error_description),,
                   length(TRAP.error_message),,
                   length(TRAP.file_message) )
  say   '' || copies('', TRAP.msg_width + 2) ||          ''
  say   '' center(TRAP.fn'.CMD', TRAP.msg_width)          ''
  say   '' copies(' ', TRAP.msg_width)                    ''
  say   '' center(TRAP.error_description, TRAP.msg_width) ''
  if arg(3) \= '' then
    say '' center(TRAP.error_message, TRAP.msg_width)     ''
  if dump_file_name <> '' then do
    say '' copies(' ',   TRAP.msg_width)                  ''
    say '' center('See:' dump_file_name, TRAP.msg_width)  ''
  end
  say   '' copies(' ', TRAP.msg_width)                    ''
  say   '' || copies('', TRAP.msg_width + 2) ||          ''
  say 'Source line at time of trap:'
  say ' ' line; say
  if arg(3) \= '' then
    if AskUser('Ny', 'Would you like elaboration?') = 'Y' then
      '@HELPMSG REX' || right('000'arg(3), 4)
  return dump_file_name

Finish_up:
  parse arg ., dump_file_name, pgmpath, errorline
  /*-----------------------------------------*\
  |  Offer to view the DMP file if it exists  |
  \*-----------------------------------------*/
  if dump_file_name \= '' then do
    ans = AskUser('Svn', 'Sort and/or View .DMP file?')
    if ans = 'S' then do                        /* Sort dump file            */
      call fileread  dump_file_name, 'stem.',, 'E', 'CRANDLF'
      call arraysort 'stem.'
      call filewrite dump_file_name, 'stem.','R'
      call QueDump dump_file_name, '/FLUSH /OVERWRITE'
      call ErhView dump_file_name
    end
    if ans = 'V' then do
      call QueDump dump_file_name, '/FLUSH /OVERWRITE'
      call ErhView dump_file_name
    end
  end
  /*----------------------------*\
  |  Offer to edit the CMD file  |
  \*----------------------------*/
  ans = AskUser('Yn', 'Edit .CMD file?')
  if ans = 'Y' then call ErhEdit pgmpath errorline
  exit 254
/*--Begin Help-----------------------------------------------------------------
Error trap subprocessor for standard REXX Skeleton.

Params: SIGL, errortype, rc, pgm-path-and-name, source-line
  or
Params: 'FINISH_UP', dump-file-name, pgm-path-and-name

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

This program is not intended to be a general utility.  It is designed to
support the standard REXX Skeleton as part of its error and event trap
processor.

___________________
Development History

$Log:   Q:/rxdv/skeleton/vcs/erhtrap.cm!  $
  
     Rev 1.0   03 Aug 1995 20:10:12
  Initial revision.
--End Help-------------------------------------------------------------------*/
