/*****************************************************************************\
| Query user with a prompt asking for a single keystroke response.            |
|                                                                             |
| $Revision:   1.0  $
|     $Date:   03 Aug 1995 20:10:06  $                                        |
| Libraries:   REXXSAA, REXXUTIL                                              |
|  Category:   Utility                                                        |
|     Class:   General                                                        |
|      Type:   UI-cmd                                                         |
|    Author:   Bob Rice - CompuServe: 72421,3016                              |
|                                                                             |
| Copyright (c) 1995 Empirical Heuristics                                     |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse arg keys, prompt
  exit AskUser(keys,prompt)

  /*=========================================================================*\
  | Query user with a prompt asking for a single keystroke response which is  |
  | not echoed to the screen.                                                 |
  \*=========================================================================*/
AskUser: procedure
  parse arg keys, prompt
  /*---------------------------------------------*\
  | Build list of acceptable response characters. |
  \*---------------------------------------------*/
  caps = xrange('A','Z')
  default = ''
  keystr  = ''
  do i = 1 to length(keys)
    key = substr(keys,i,1)
    if pos(key,caps) > 0 then default = key
    keystr = keystr || key || '/'
  end
  keystr = left(keystr,length(keystr)-1)        /* Remove trailing /         */
  /*---------------*\
  | Query the user. |
  \*---------------*/
  say '['keystr']' prompt
  ans = translate(SysGetKey('NOECHO'))
  if c2d(ans) = 13 then ans = default
  if pos(ans,translate(keys)) = 0 then ans = default
  return ans
/*--Begin Help-----------------------------------------------------------------
Query user with a prompt asking for a single keystroke response.
The keystroke is not echoed to the screen.

Params: keys, prompt

  keys        is a string of characters, one of which may be upper cased,
              to tell the user which keystrokes are acceptable.  The upper
              case character denotes the default should the user press
              <Enter> or <Esc> or a character not in the list.

  prompt      is a character string that will be presented to the user on
              the next available screen line.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

___________________
Development History
$Log:   Q:/rxdv/skeleton/vcs/askuser.cm!  $
  
     Rev 1.0   03 Aug 1995 20:10:06
  Initial revision.
--End Help-------------------------------------------------------------------*/
