/* ShdFld.CMD */
/*
 by Louis McKinley  72162,1465
 1996 10 06
 Limited support available.
 Use and/or distribute freely.  It has been tested on my system and believed
 to be trouble free, but ...
  *****************************
  **  Use at your own risk.  **
  *****************************

 DESCRIPTION:
 This REXX program creates a folder on the desktop and populates it with 
 shadows of files of your choice.  The files that you want to shadow can be
 specified individually or can fit a file name pattern like that used at
 the command line (e.g., *.TXT, THESEFILES*, ThisFile.ABC).  Each time this
 REXX program is executed the folder will be updated to match the list of
 files of interest.  The folder can be dragged from the desktop after it has
 been created.

 The "parameters" are hard coded within, so follow the set of INSTRUCTIONS
 that are shown at various places below.

 After running this program and it has created the folder and shadows:
 If you desire to invoke this program from the popup menu of the folder
 containing the shadows, then this is done by manually changing the
 settings notebook for the folder.  Open the settings notebook and go to the
 Menu page.  Under Actions on menu, click Create another....  In the Menu 
 Items Settings dialog box enter something like "Refresh My Files" or "Update 
 folder" in the Menu item name field; and in the Name field enter the path 
 name of this REXX program.  Click OK and close the notebook.

 This program puts ObjectID data in the OS2.INI file, so it is recommended to
 use a utility like UniMaint to regularly clean out data that becomes
 obsolete.

 This REXX program opens up an annoying OS/2 window while it is running.
 */
/*'mode co1,1'*/

IF RxFuncQuery('SysLoadFuncs')THEN DO
 	IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN DO
		SAY 'Could not load RexxUtil library'
		EXIT
	END
	CALL SysLoadFuncs
END

RMDFolderID='<RMD_FOLDER>'

/* INSTRUCTIONS:
 Enter the title of the folder that will contain
 the shadows of the files that you want to shadow.
 N.B. quotes.
 */
folderTitle='RMD Data'		/* title goes between the quotes */

/*
 The folder will be created on the Desktop, if it
 does not already exist.
 */
location='<WP_DESKTOP>'
settings='OBJECTID=' || RMDFolderID || ';'

res=SysCreateObject('WPFolder',,
		folderTitle,,
		location,,
		settings,,
		'FAIL')

/*ARG control
IF control = 'OPEN_FOLDER' THEN DO
	IF \SysOpenObject(RMDFolderID, 'DEFAULT', '1') THEN DO
		CALL Beep('100', '2000')
	END
END*/

n = 0
/* INSTRUCTIONS:
 Carefully enter the list of files to create the shadows of, using full
 paths and a command line file pattern.  N.B. quotes.

 Each file specification should be on its own line in the following format:
   n = n + 1; filesToShadow.n='path in quotes'
 The only part of the line that is different for each file specification is
 the information in the quotes.

 If you only need one file specification, then the list will look something like,

 n = n + 1; filesToShadow.n='C:\MEMOS\*.TXT'

 This will create shadows of all *.TXT files on C: drive in the \MEMOS\
 directory, and put them in the target folder.

 End of comment.
 */

/* Enter the list of file specifications here,
 (delete or comment the example given here).
 */
n = n + 1; filesToShadow.n='C:\MEMOS\*.TXT'
n = n + 1; filesToShadow.n='D:\DATALIST\DAY1\THESE?.*'
n = n + 1; filesToShadow.n='D:\MOREDATA\*'
n = n + 1; filesToShadow.n='D:\CONFIG.SYS'


filesToShadow.0 = n

DO j = 1 TO filesToShadow.0
	CALL SysFileTree filesToShadow.j, 'files.' , 'FO'

/* Try to create a shadow of every "filesToShadow.j" file.
 */
	DO i=1 TO files.0
		file=FileSpec('NAME', files.i)
		shadowID='SHADOWID=' || files.i || ';'
		objectID='OBJECTID=<RMD' || j || file || '>;'
		settings=shadowID || objectID
		res=SysCreateObject('WPShadow',,
			'DummyText',,
			RMDFolderID,,
			settings,,
			'FAIL')
	END
END

EXIT
