/*********************************************************************\
**  SEC_TEST.CMD :                                                   **
**        (C) 1994 Thomas Christinck, Braunschweig   CIS 100031,41   **
***********************************************************************
**  This REXX-script is just testing the SECTOR.DLL                  **
***********************************************************************
**  Without parameters a statistic of all drives is listet           **
**  With the parameter drive and sectornumber, one sector is listed  **
**                                                                   **
\*********************************************************************/
ARG drive sect
SIGNAL ON HALT NAME END

if drive = "?" then call help
if drive = "help" then call help

call rxfuncadd sysloadfuncs,rexxutil,sysloadfuncs
call sysloadfuncs

call RxFuncAdd 'QDrive',   'sector', 'QDrive'
call RxFuncAdd 'ReadSect', 'sector', 'ReadSect'
call RxFuncAdd 'WritSect', 'sector', 'WritSect'

if drive = '' then signal driveinfo
if sect \= '' then signal readsector

call help
return

/**********************************************************************/

driveinfo:
disks= sysdrivemap(,'local')
say "drive sectors cylinders heads sec/track byte/sec       MB"
do i= 1 to words(disks)
  lw=word(disks,i)
  di=QDrive(lw)
  say  lw right(word(di,1),10)  right(word(di,2),9) right(word(di,3),5) right(word(di,4),9) right(word(di,5),8) format(word(di,1)*word(di,5)/1024/1024,6,1)
  end
return

/**********************************************************************/

readsector:
sect = readsect(drive, sect)

do i=0 to 511 by 16
     call charout , d2x(i,4)"  "
     do j=1 to 16
        call charout , c2x(substr(sect,i+j,1))" "
        end
     do j=1 to 16
        c = substr(sect,i+j,1)
        if c<" " then call charout ," "
                 else call charout ,c
        end
     say
     end

return

/********************************************************************/

End:
say "^C"
say " Break ...."
exit

Help:
parse value SysTextScreenSize() with rows cols
rows=rows-2
do i=1 to 99
  if (i//rows) = 0 then call More
  if pos("**",sourceline(i))==0 then leave
  say sourceline(i)
  end
exit

More:
say "Press any key ..."
call SysGetKey("NOECHO")
return

