/* Dispatcher for calling internet programs from within REXX Tips & Tricks   */
/*                                                                           */
/* Usage:                                                                    */
/*                                                                           */
/*    www http www_address                                                   */
/*    www news newsgroup                                                     */
/*    www ftp ftp_address                                                    */
/*    www mail mailAddress                                                   */
/*    www cis  CISAdress                                                     */
/*    www fido FidoAdress                                                    */
/*                                                                           */
/* Note:                                                                     */
/*                                                                           */
/*                                                                           */
/*    This sample file uses the program NETSCDDE.EXE from the XWorkplace     */
/*    package.                                                               */
/*                                                                           */

  parse arg action iAdress

  progDesc = 'www - Dispatcher for REXX Tips & Tricks'

  select

    when action = 'http' then
    do
                    /* call Netscape using NETSCDDE.EXE from the            */
                    /* XWorkplace package                                   */
      '@netscdde.exe -Xn http://' || iAdress
    end /* when */

    when action = 'ftp' then
    do
                    /* call Netscape using NETSCDDE.EXE from the            */
                    /* XWorkplace package                                   */
      '@netscdde.exe -Xn ftp://' || iAdress
    end /* when */

    when action = 'news' then
    do
                    /* call Netscape using NETSCDDE.EXE from the            */
                    /* XWorkplace package                                   */
      '@netscdde.exe -Xn news://' || iAdress
    end /* when */

    when action = 'mail' then
    do
                    /* call Netscape using NETSCDDE.EXE from the            */
                    /* XWorkplace package                                   */
      '@netscdde.exe -Xn mailto:' || iAdress
    end /* when */

    when action = 'cis' then
    do
                    /* convert the CIS address to an internet address       */
       parse var iAdress part1 ',' part2
       iAdress = strip( part1 ) || '.' || strip( part2 ) || '@compuserve.com'

                    /* call Netscape using NETSCDDE.EXE from the            */
                    /* XWorkplace package                                   */
      '@netscdde.exe -Xn mailto:' || iAdress
    end /* when */

    when action = 'fido' then
    do
      say progDesc
      say
      say 'Error: I do not know how to handle FIDO addresses!'
      say
      say 'Press ENTER to exit'
      parse pull     
    end /* when */

    otherwise
    do
      say progDesc
      say
      say 'Error: Invalid arguments: "' || action iAdress || '"'
      say
      say 'Press ENTER to exit'
      parse pull
    end /* otherwise */

  end /* select */

'@exit'

