#
# WMAKE-compatible MAKE file for building REXX/SQL with Watcom C++ 10.6
#
# will generate:
#
#      rexxsql.dll
#      rexxsql.exe
#      rexx<db>.dll
#      rexx<db>.exe
# 
# Usage: nmake [DEBUG=1] 
#              [INT=REGINA|OREXX|WINREXX|QUERCUS]
#              [DB=SAW|ODBC|UDBC|ORA|MIN|DB2|SYB|MIN2|SOL]
#              [rexxsql.dll|rexxsql.exe|rexx<db>.dll|rexx<db>.exe]
#

SRC = \mhes\rexxsql
#---------------------------------------------------------------------
# You should not have to change anything below here...
#---------------------------------------------------------------------

TARGET=NT
#
# Database specific defines
#
!ifeq DB ORA
db = ora
DBDIR=$(SRC)\$(DB)
CLIDIR=$(DBDIR)
CLI=ora
DBLIBS = e:\mhes\rexxsql\ora\win32\orantv7.lib
EXTRAINC =

!else
! ifeq DB DB2
db = db2
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = d:\sqllib\lib\db2cli.lib
EXTRAINC = /I=d:\sqllib\include

! else
!  ifeq DB SAW
db = saw
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = e:\mhes\odbcsdk.30\odbc32.lib
EXTRAINC = /I=e:\mhes\sqlany50\h

!  else
!   ifeq DB MIN

!   else
!    ifeq DB MIN2
db = min2
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\$(DB)
CLI=min
#DBLIBS = e:\public\msql2\lib\msql_dll.lib wsock32.lib advapi32.lib
DBLIBS = wsock32.lib,advapi32.lib
EXTRAINC = /I=e:\public\msql2\include

!    else
!     ifeq DB ODBC
db = odbc
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = e:\mhes\odbcsdk.30\odbc32.lib
EXTRAINC = /I=e:\mhes\odbcsdk.30

!     else
!      ifeq DB UDBC
db = udbc
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = e:\mhes\udbc\lib\librpc.lib,e:\mhes\udbc\lib\opludb32.lib,wsock32.lib #e:\mhes\udbc\lib\libudbc.lib
EXTRAINC = /I=e:\mhes\udbc\include

!      else
!       ifeq DB SOL
db = sol
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = e:\mhes\solid\lib\SCLW3222.LIB
EXTRAINC = /Ie:\mhes\solid\include /DSS_NT

!       else
!        ifeq DB SYB
!        else
!         error Target Database NOT specified via DB macro. Valid values are: ORA SAW ODBC MIN MIN2 DB2 SYB SOL
!        endif
!       endif
!      endif
!     endif
!    endif
!   endif
!  endif
! endif
!endif

#
# Interpreter specific defines
#
!ifeq INT REGINA
REXXLIBS = e:\mhes\regina\vc\reginaw.lib
REXXINC = /I=e:\mhes\regina /DUSE_REGINA
!else
! ifeq INT OREXX
REXXLIBS = e:\mhes\orexx\api\rexx.lib,e:\mhes\orexx\api\rexxapi.lib
REXXINC = /I=e:\mhes\orexx\api /DUSE_OREXX
! else
!  ifeq INT WINREXX
REXXLIBS = e:\mhes\winrexx\api\rxrexx.lib
REXXINC = /I=e:\mhes\winrexx\api /DUSE_WINREXX
!  else
!   error Rexx Interpreter NOT specified via INT macro. Valid values are: REGINA OREXX WINREXX
!  endif
! endif
!endif

EXTRALINK =
DBDEFINE = /D$(DB)_PREFIX
CCLIBS = user32.lib
DISTDIR=$(SRC)\dist

comcopts = /zz /4s /zp4 /ei /zq /mf /DWIN32 /DHAVE_PROTO /i=$(DBDIR) /i=$(SRC)\common $(REXXINC) $(EXTRAINC)
comlopts = 

!ifdef DEBUG Y
copts  = $(comcopts) /d2
lopts  = $(comlopts) DEBUG WATCOM ALL
!else
copts  = $(comcopts) /oneatx
lopts  = $(comlopts) 
!endif

cflagsdll = $(copts) /bd
cflagsexe = $(copts) 
lflagsdll = $(lopts) 
lflagsexe = $(lopts) 

objssqldll = hashdll.obj utsqldll.obj rxsqldll.obj
objssqlexe = getopt.obj hashexe.obj utsqlexe.obj rxsqlexe.obj rxsql.obj
objsdbdll = hashdll.obj ut$(db)dll.obj rx$(db)dll.obj
objsdbexe = getopt.obj hashexe.obj ut$(db)exe.obj rx$(db)exe.obj rx$(db).obj

ccsqldll = wcc386 $(cflagsdll) $(listopt)
ccsqlexe = wcc386 $(cflagsexe) $(listopt)
ccdbdll = wcc386 $(cflagsdll) $(listopt) $(DBDEFINE)
ccdbexe = wcc386 $(cflagsexe) $(listopt) $(DBDEFINE)

H1=$(SRC)\common\rexxsql.h
H2=$(DBDIR)\dbdefine.h
H3=$(DBDIR)\dbheader.h
H4=$(DBDIR)\dbtypes.h $(SRC)\common\common.h
H5=$(SRC)\common\hash.h

all: rexxsql.dll rexxsql.exe rexx$(db).dll rexx$(db).exe dist

#
# These function only required for EXE
#
getopt.obj: $(SRC)\common\getopt.c
    $(ccsqlexe) /fo=getopt.obj $(SRC)\common\getopt.c

rxsql.obj: $(SRC)\common\rexxsql.c $(H1) $(H2)
    $(ccsqlexe) /fo=rxsql.obj $(SRC)\common\rexxsql.c

rx$(db).obj: $(SRC)\common\rexxsql.c $(H1) $(H2)
    $(ccdbexe) /fo=rx$(db).obj $(SRC)\common\rexxsql.c
#
# These functions required for both EXE and DLL
# Same file used for standard and DB-specific binary
#
hashdll.obj: $(SRC)\common\hash.c $(H5)
    $(ccsqldll) /fo=hashdll.obj $(SRC)\common\hash.c

hashexe.obj: $(SRC)\common\hash.c $(H5)
    $(ccsqlexe) /fo=hashexe.obj $(SRC)\common\hash.c
#
# These functions required for both EXE and DLL
# Different file used for standard and DB-specific binary
#

rxsqldll.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccsqldll) /fo=rxsqldll.obj $(CLIDIR)\$(CLI).c

rxsqlexe.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccsqlexe) /fo=rxsqlexe.obj $(CLIDIR)\$(CLI).c

rx$(db)dll.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccdbdll) /fo=rx$(db)dll.obj $(CLIDIR)\$(CLI).c

rx$(db)exe.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccdbexe) /fo=rx$(db)exe.obj $(CLIDIR)\$(CLI).c

utsqldll.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccsqldll) /fo=utsqldll.obj $(SRC)\common\util.c

utsqlexe.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccsqlexe) /fo=utsqlexe.obj $(SRC)\common\util.c

ut$(db)dll.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccdbdll) /fo=ut$(db)dll.obj $(SRC)\common\util.c

ut$(db)exe.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccdbexe) /fo=ut$(db)exe.obj $(SRC)\common\util.c


rexxsql.exe: $(objssqlexe)
	@%create rexxsql.lnk
	@%append rexxsql.lnk option quiet
	@%append rexxsql.lnk system $(TARGET)
	@%append rexxsql.lnk name rexxsql.exe
	@%append rexxsql.lnk file utsqlexe.obj
	@%append rexxsql.lnk file rxsql.obj
	@%append rexxsql.lnk file hashexe.obj
	@%append rexxsql.lnk file rxsqlexe.obj
	@%append rexxsql.lnk file getopt.obj
	@%append rexxsql.lnk library $(DBLIBS)
	@%append rexxsql.lnk library $(REXXLIBS)
	@%append rexxsql.lnk alias _RexxStart=RexxStart
	@%append rexxsql.lnk alias _RexxVariablePool=RexxVariablePool
	@%append rexxsql.lnk alias _RexxRegisterFunctionExe=RexxRegisterFunctionExe
	@%append rexxsql.lnk alias _RexxDeregisterFunction=RexxDeregisterFunction
	@%append rexxsql.lnk alias _ocan=ocan
	wlink $(lflagsexe) @rexxsql.lnk
	del rexxsql.lnk

rexx$(DB).exe: $(objsdbexe)
	echo option quiet          > rexxsql.lnk
	echo system $(TARGET)     >> rexxsql.lnk
	echo name rexx$(DB).exe   >> rexxsql.lnk
	echo file ut$(DB)exe.obj  >> rexxsql.lnk
	echo file rx$(DB).obj     >> rexxsql.lnk
	echo file hashexe.obj     >> rexxsql.lnk
	echo file rx$(DB)exe.obj  >> rexxsql.lnk
	echo file getopt.obj      >> rexxsql.lnk
	echo library $(REXXLIBS)  >> rexxsql.lnk
	echo library $(DBLIBS)    >> rexxsql.lnk
	wlink $(lflagsexe) @rexxsql.lnk
	del rexxsql.lnk

rexxsql.dll: $(objssqldll)
	echo option quiet          > rexxsql.lnk
	echo system $(TARGET) dll >> rexxsql.lnk
	echo name rexxsql.dll     >> rexxsql.lnk
	echo file utsqldll.obj    >> rexxsql.lnk
	echo file rxsqldll.obj    >> rexxsql.lnk
	echo file hashdll.obj     >> rexxsql.lnk
	echo library $(REXXLIBS)  >> rexxsql.lnk
	echo library $(DBLIBS)    >> rexxsql.lnk
	echo export     SQLLoadFuncs   >> rexxsql.lnk
	echo export RexxSQLDropFuncs   >> rexxsql.lnk
	echo export RexxSQLConnect     >> rexxsql.lnk
	echo export RexxSQLDisconnect  >> rexxsql.lnk
	echo export RexxSQLCommand     >> rexxsql.lnk
	echo export RexxSQLVariable    >> rexxsql.lnk
	echo export RexxSQLDefault     >> rexxsql.lnk
	echo export RexxSQLCommit      >> rexxsql.lnk
	echo export RexxSQLRollback    >> rexxsql.lnk
	echo export RexxSQLPrepare     >> rexxsql.lnk
	echo export RexxSQLDispose     >> rexxsql.lnk
	echo export RexxSQLOpen        >> rexxsql.lnk
	echo export RexxSQLExecute     >> rexxsql.lnk
	echo export RexxSQLClose       >> rexxsql.lnk
	echo export RexxSQLFetch       >> rexxsql.lnk
	echo export RexxSQLGetInfo     >> rexxsql.lnk
	echo export RexxSQLGetData     >> rexxsql.lnk
	echo export RexxSQLDescribe    >> rexxsql.lnk
	wlink $(lflagsdll) @rexxsql.lnk
	del rexxsql.lnk

rexx$(DB).dll: $(objsdbdll)
	echo option quiet          > rexxsql.lnk
	echo system $(TARGET) dll >> rexxsql.lnk
	echo name rexx$(DB).dll   >> rexxsql.lnk
	echo file ut$(DB)dll.obj  >> rexxsql.lnk
	echo file rx$(DB)dll.obj  >> rexxsql.lnk
	echo file hashdll.obj     >> rexxsql.lnk
	echo library $(REXXLIBS)  >> rexxsql.lnk
	echo library $(DBLIBS)    >> rexxsql.lnk
	echo export $(DB)LoadFuncs   >> rexxsql.lnk
	echo export Rexx$(DB)DropFuncs   >> rexxsql.lnk
	echo export Rexx$(DB)Connect     >> rexxsql.lnk
	echo export Rexx$(DB)Disconnect  >> rexxsql.lnk
	echo export Rexx$(DB)Command     >> rexxsql.lnk
	echo export Rexx$(DB)Variable    >> rexxsql.lnk
	echo export Rexx$(DB)Default     >> rexxsql.lnk
	echo export Rexx$(DB)Commit      >> rexxsql.lnk
	echo export Rexx$(DB)Rollback    >> rexxsql.lnk
	echo export Rexx$(DB)Prepare     >> rexxsql.lnk
	echo export Rexx$(DB)Dispose     >> rexxsql.lnk
	echo export Rexx$(DB)Open        >> rexxsql.lnk
	echo export Rexx$(DB)Execute     >> rexxsql.lnk
	echo export Rexx$(DB)Close       >> rexxsql.lnk
	echo export Rexx$(DB)Fetch       >> rexxsql.lnk
	echo export Rexx$(DB)GetInfo     >> rexxsql.lnk
	echo export Rexx$(DB)GetData     >> rexxsql.lnk
	echo export Rexx$(DB)Describe    >> rexxsql.lnk
	wlink $(lflagsdll) @rexxsql.lnk
	del rexxsql.lnk

dist: rexxsql.exe rexxsql.dll rexx$(db).exe rexx$(db).dll
	copy *.exe $(DISTDIR)\$(DB)\$(INT)
	copy *.dll $(DISTDIR)\$(DB)\$(INT)
	copy rexx$(db).exe $(DISTDIR)\$(DB)\$(INT)
	copy rexx$(db).dll $(DISTDIR)\$(DB)\$(INT)
