#
# NMAKE-compatible MAKE file for building REXX/SQL with VC++
#
# will generate:
#
#      rexxsql.dll
#      rexxsql.exe
#      rexx<db>.dll
#      rexx<db>.exe
# 
# Usage: nmake [DEBUG=1] 
#              [INT=REGINA|OREXX|WINREXX|QUERCUS]
#              [DB=SAW|ODBC|UDBC|ORA|MIN|DB2|SYB|MIN2|SOL]
#              [rexxsql.dll|rexxsql.exe|rexx<db>.dll|rexx<db>.exe]
#

!if "$(COMPUTERNAME)" == "SNARK"
SRC = \rexxsql
DISTDIR=e:\rexxsql\dist
ORA_DBLIBS = e:\orant\oci73\lib\msvc\ociw32.lib
ORA_DBINC =
DB2_DBLIBS = c:\sqllib\lib\db2cli.lib
DB2_DBINC = /Ic:\sqllib\include
SAW_DBLIBS = c:\odbcsdk.25\odbc32.lib
SAW_DBINC = /Ic:\sqlany50\h
MIN2_DBLIBS = e:\public\msql2\lib\msql_dll.lib wsock32.lib advapi32.lib
MIN2_DBINC = /Ie:\public\msql2\include
ODBC_DBLIBS = c:\odbcsdk.25\odbc32.lib
ODBC_DBINC = /Ic:\odbcsdk.25
UDBC_DBLIBS = e:\udbc\lib\librpc.lib e:\udbc\lib\opludb32.lib wsock32.lib #c:\udbc\lib\libudbc.lib
UDBC_DBINC = /Ie:\udbc\include /MT
SOL_DBLIBS = e:\solid\lib\SCLW3222.LIB
SOL_DBINC = /Ie:\solid\include /DSS_NT /DSOLID_SERVER

REGINA_REXXLIBS = c:\regina-0.08e\vc\regina.lib
REGINA_REXXINC = -Ic:\regina-0.08e -DUSE_REGINA
OREXX_REXXLIBS = c:\objrexx\api\rexx.lib c:\objrexx\api\rexxapi.lib
OREXX_REXXINC = -Ic:\objrexx\api -DUSE_OREXX
WINREXX_REXXLIBS = e:\winrexx\api\rxrexx.lib
WINREXX_REXXINC = -Ie:\winrexx\api -DUSE_WINREXX
QUERCUS_REXXLIBS = e:\quercus\api\wrexx32.lib
QUERCUS_REXXINC = -Ie:\quercus\api -DUSE_QUERCUS
!else
SRC = \mhes\rexxsql
DISTDIR=$(SRC)
ORA_DBLIBS = d:\mhes\oracle\oci73\lib\msvc\ociw32.lib
ORA_DBINC =
DB2_DBLIBS = e:\mhes\sqllib\lib\db2cli.lib
DB2_DBINC = /Ie:\mhes\sqllib\include
SAW_DBLIBS = e:\mhes\odbcsdk.30\odbc32.lib
SAW_DBINC = /Ie:\mhes\sqlany50\h
MIN2_DBLIBS = e:\mhes\public\msql2\lib\msql_dll.lib wsock32.lib advapi32.lib
MIN2_DBINC = /Ie:\mhes\public\msql2\include
ODBC_DBLIBS = e:\mhes\odbcsdk.30\odbc32.lib
ODBC_DBINC = /Ie:\mhes\odbcsdk.30
UDBC_DBLIBS = e:\mhes\udbc\lib\librpc.lib e:\mhes\udbc\lib\opludb32.lib wsock32.lib #c:\udbc\lib\libudbc.lib
UDBC_DBINC = /Ie:\mhes\udbc\include /MT
SOL_DBLIBS = e:\mhes\solid\lib\SCLW3222.LIB
SOL_DBINC = /Ie:\mhes\solid\include /DSS_NT /DSOLID_SERVER

REGINA_REXXLIBS = e:\mhes\regina-0.08e\vc\regina.lib
REGINA_REXXINC = -Ie:\mhes\regina-0.08e -DUSE_REGINA
OREXX_REXXLIBS = c:\objrexx\api\rexx.lib c:\objrexx\api\rexxapi.lib
OREXX_REXXINC = -Ic:\objrexx\api -DUSE_OREXX
WINREXX_REXXLIBS = e:\mhes\winrexx\api\rxrexx.lib
WINREXX_REXXINC = -Ie:\mhes\winrexx\api -DUSE_WINREXX
QUERCUS_REXXLIBS = e:\mhes\quercus\wrexx32.lib
QUERCUS_REXXINC = -Ie:\mhes\quercus -DUSE_QUERCUS
!endif
#---------------------------------------------------------------------
# You should not have to change anything below here...
#---------------------------------------------------------------------

#
# Database specific defines
#
!if "$(DB)" == "ORA"
db = ora
DBDIR=$(SRC)\$(DB)
CLIDIR=$(DBDIR)
CLI=ora
DBLIBS = $(ORA_DBLIBS)
DBINC = $(ORA_DBINC)
DBDEFINE = /DORA_PREFIX

!elseif "$(DB)" == "DB2"
db = db2
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = $(DB2_DBLIBS)
DBINC = $(DB2_DBINC)
DBDEFINE = /DDB2_PREFIX

!elseif "$(DB)" == "SAW"
db = saw
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = $(SAW_DBLIBS)
DBINC = $(SAW_DBINC)
DBDEFINE = /DSAW_PREFIX

!elseif "$(DB)" == "MIN"
DBDEFINE = /DMIN_PREFIX

!elseif "$(DB)" == "MIN2"
db = min
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\$(DB)
CLI=min
DBLIBS = $(MIN2_DBLIBS)
DBINC =  $(MIN2_DBINC)
DBDEFINE = /DMIN_PREFIX

!elseif "$(DB)" == "ODBC"
db = odbc
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = $(ODBC_DBLIBS)
DBINC =  $(ODBC_DBINC)
DBDEFINE = /DODBC_PREFIX

!elseif "$(DB)" == "UDBC"
db = udbc
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = $(UDBC_DBLIBS)
DBINC =  $(UDBC_DBINC)
DBDEFINE = /DUDBC_PREFIX

!elseif "$(DB)" == "SOL"
db = sol
DBDIR=$(SRC)\$(DB)
CLIDIR=$(SRC)\cli-odbc
CLI=rexxcli
DBLIBS = $(SOL_DBLIBS)
DBINC =  $(SOL_DBINC)
DBDEFINE = /DSOL_PREFIX

!elseif "$(DB)" == "SYB"
DBDEFINE = /DSYB_PREFIX
!else
!message Target Database NOT specified via DB macro
!message Valid values are: ORA SAW ODBC MIN DB2 SYB SOL
!error Make aborted!
!endif

#
# Interpreter specific defines
#
!if "$(INT)" == "REGINA"
REXXLIBS = $(REGINA_REXXLIBS)
REXXINC =  $(REGINA_REXXINC)
!elseif "$(INT)" == "OREXX"
REXXLIBS = $(OREXX_REXXLIBS)
REXXINC =  $(OREXX_REXXINC)
!elseif "$(INT)" == "WINREXX"
REXXLIBS = $(WINREXX_REXXLIBS)
REXXINC =  $(WINREXX_REXXINC)
!elseif "$(INT)" == "QUERCUS"
REXXLIBS = $(QUERCUS_REXXLIBS)
REXXINC =  $(QUERCUS_REXXINC)
!else
!message Rexx Interpreter NOT specified via INT macro
!message Valid values are: REGINA OREXX WINREXX QUERCUS
!error Make aborted!
!endif

EXTRALINK =
CCLIBS = user32.lib

comcopts = -nologo -W3 -c -DWIN32 -DHAVE_PROTO  -I$(DBDIR) -I$(SRC)\common $(DBINC) $(REXXINC) #/C /Ms /Gm- /Q /Sm /J+
comlopts = -nologo -machine:I386 $(EXTRALINK) #/NOI /NOE /NOLOGO /EXEPACK:2 /ALIGN:4 $(EXTRALINK)

!ifdef DEBUG
copts  = $(comcopts) -Od -Zi -FR
lopts  = $(comlopts) -debug #-debugtype:coff -fixed:no #-pdb:none
!else
copts  = $(comcopts) -O2gityb1
lopts  = $(comlopts) -release
!endif

cflagsdll = $(copts) -DDYNAMIC
cflagsexe = $(copts) 
lflagsdll = $(lopts) -dll -implib:$(*B).lib
lflagsexe = $(lopts) 

objssqldll = hashdll.obj utsqldll.obj rxsqldll.obj dll_res.obj
objssqlexe = getopt.obj hashexe.obj utsqlexe.obj rxsqlexe.obj rxsql.obj exe_res.obj
objsdbdll = hashdll.obj ut$(db)dll.obj rx$(db)dll.obj dll_res.obj
objsdbexe = getopt.obj hashexe.obj ut$(db)exe.obj rx$(db)exe.obj rx$(db).obj exe_res.obj

ccsqldll = cl $(cflagsdll) $(listopt)
ccsqlexe = cl $(cflagsexe) $(listopt)
ccdbdll = cl $(cflagsdll) $(listopt) $(DBDEFINE)
ccdbexe = cl $(cflagsexe) $(listopt) $(DBDEFINE)

H1=$(SRC)\common\rexxsql.h
H2=$(DBDIR)\dbdefine.h
H3=$(DBDIR)\dbheader.h
H4=$(DBDIR)\dbtypes.h $(SRC)\common\common.h
H5=$(SRC)\common\hash.h

all: rexxsql.dll rexxsql.exe rexx$(db).dll dist #rexx$(db).exe

#
# These function only required for EXE
#
getopt.obj: $(SRC)\common\getopt.c
    $(ccsqlexe) /Fogetopt.obj $(SRC)\common\getopt.c

rxsql.obj: $(SRC)\common\rexxsql.c $(H1) $(H2)
    $(ccsqlexe) /Forxsql.obj $(SRC)\common\rexxsql.c

rx$(db).obj: $(SRC)\common\rexxsql.c $(H1) $(H2)
    $(ccdbexe) /Forx$(db).obj $(SRC)\common\rexxsql.c
#
# These functions required for both EXE and DLL
# Same file used for standard and DB-specific binary
#
hashdll.obj: $(SRC)\common\hash.c $(H5)
    $(ccsqldll) /Fohashdll.obj $(SRC)\common\hash.c

hashexe.obj: $(SRC)\common\hash.c $(H5)
    $(ccsqlexe) /Fohashexe.obj $(SRC)\common\hash.c
#
# These functions required for both EXE and DLL
# Different file used for standard and DB-specific binary
#

rxsqldll.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccsqldll) /Forxsqldll.obj $(CLIDIR)\$(CLI).c

rxsqlexe.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccsqlexe) /Forxsqlexe.obj $(CLIDIR)\$(CLI).c

rx$(db)dll.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccdbdll) /Forx$(db)dll.obj $(CLIDIR)\$(CLI).c

rx$(db)exe.obj: $(CLIDIR)\$(CLI).c $(H1) $(H2) $(H3) $(H4) $(H5)
    $(ccdbexe) /Forx$(db)exe.obj $(CLIDIR)\$(CLI).c

utsqldll.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccsqldll) /Foutsqldll.obj $(SRC)\common\util.c

utsqlexe.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccsqlexe) /Foutsqlexe.obj $(SRC)\common\util.c

ut$(db)dll.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccdbdll) /Fout$(db)dll.obj $(SRC)\common\util.c

ut$(db)exe.obj: $(SRC)\common\util.c $(H1) $(H2) $(H5)
    $(ccdbexe) /Fout$(db)exe.obj $(SRC)\common\util.c

#
# Rules for resources
#
exe_res.obj exe_res.res: $(SRC)\rexxsql_w32.rc
	copy $(SRC)\rexxsql_w32.ico .
	rc /r /foexe_res.res /D$(INT) /D$(DB) /i$(SRC) $(SRC)\rexxsql_w32.rc
	cvtres /MACHINE:IX86 /NOLOGO /OUT:exe_res.obj exe_res.res

dll_res.obj dll_res.res: $(SRC)\rexxsql_w32.rc
	copy $(SRC)\rexxsql_w32.ico .
	rc /r /fodll_res.res /DDYNAMIC /D$(INT) /D$(DB) /i$(SRC) $(SRC)\rexxsql_w32.rc
	cvtres /MACHINE:IX86 /NOLOGO /OUT:dll_res.obj dll_res.res

#
# Rules for executables and DLLs
#
rexxsql.dll: $(objssqldll)
	link $(lflagsdll) $(objssqldll) -out:rexxsql.dll $(DBLIBS) $(CCLIBS) $(REXXLIBS) -def:$(SRC)\rexxsql_w32_dll.def

rexxsql.exe: $(objssqlexe)
	link $(lflagsexe) $(objssqlexe) -out:rexxsql.exe $(DBLIBS) $(CCLIBS) $(REXXLIBS)

rexx$(db).dll: $(objsdbdll)
	link $(lflagsdll) $(objsdbdll) -out:rexx$(db).dll $(DBLIBS) $(CCLIBS) $(REXXLIBS) -def:$(SRC)\rexx$(db)_w32_dll.def

rexx$(db).exe: $(objsdbexe)
	link $(lflagsexe) $(objsdbexe) -out:rexx$(db).exe $(DBLIBS) $(CCLIBS) $(REXXLIBS)

#
# Rules for distribution
#
dist: $(DISTDIR)\$(DB)\$(INT)\rexxsql.exe $(DISTDIR)\$(DB)\$(INT)\rexxsql.dll $(DISTDIR)\$(DB)\$(INT)\rexx$(db).dll

$(DISTDIR)\$(DB)\$(INT)\rexxsql.exe: rexxsql.exe
	copy rexxsql.exe $(DISTDIR)\$(DB)\$(INT)

$(DISTDIR)\$(DB)\$(INT)\rexxsql.dll: rexxsql.dll
	copy rexxsql.dll $(DISTDIR)\$(DB)\$(INT)

$(DISTDIR)\$(DB)\$(INT)\rexx$(db).dll: rexx$(db).dll
	copy rexx$(db).dll $(DISTDIR)\$(DB)\$(INT)
