/* Small Test program for my REXX Regular Expression Code */

/*--- Load up functions we will use -----------------------------------------*/
call RxFuncAdd   'RegExpVersion', 'RxRegExp', 'RegExpVersion';
call RxFuncAdd   'RegExpCompile', 'RxRegExp', 'RegExpCompile';
call RxFuncAdd   'RegExpMatch',   'RxRegExp', 'RegExpMatch';
call RxFuncAdd   'RegExpReplace', 'RxRegExp', 'RegExpReplace';

/*--- Make sure Regular Expression DLL is available for use -----------------*/
say 'RxRegExp.DLL';
say '~~~~~~~~~~~~';
if RegExpOk() = 'N' then
do
   say "Regular Expressions can't be used (DLL probably unavailable)!";
   exit(GetLineNumber());
end;
say "Available";

/*--- Display Version Info --------------------------------------------------*/
say '';
say 'RegExpVersion';
say '~~~~~~~~~~~~~';
VerRc = RegExpVersion('ReVersion');
if VerRc <> 'OK' then
do
   say '    COULD NOT GET RXREGEXP.DLL VERSION INFO'
   say '    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
   say '    ' || VerRc;
   exit(GetLineNumber());
end;
parse var ReVersion DllVersion WebPage EmailAddress AuthorName;
say 'Version  = ' || DllVersion;
say 'Author   = ' || AuthorName;
say 'Email    = ' || EmailAddress;
say 'Web Page = ' || WebPage;

/*--- Define/Compile regular expression -------------------------------------*/
say ''
say 'RegExpCompile';
say '~~~~~~~~~~~~~';
Re = arg(1);
if Re = '' then
   Re = "1[12]";
CompileRc = RegExpCompile(Re);
say CompileRc;
if CompileRc <> 'OK' then
   exit(GetLineNumber());

/*--- Look for a match ------------------------------------------------------*/
LookIn = "AAA112BBB";
say ''
say 'RegExpMatch';
say '~~~~~~~~~~~';
say 'Looking for ' || Re || ' in "' || LookIn || '"';
Answer  = '?';
MatchRc = RegExpMatch(LookIn, "Answer");
if MatchRc <> 'OK' then
do
   /*--- An error occurred --------------------------------------------------*/
   say '    ERROR'
   say '    ~~~~~'
   say '    ' || MatchRc;
   exit(GetLineNumber());
end
else
do
   /*--- Did we have any matches? -------------------------------------------*/
   if  Answer = '' then
   do
       say '   * No Matches';
       exit(GetLineNumber());
   end;

   /*--- List all matches and submatches ------------------------------------*/
   say '   * MatchList = ' || Answer;

   /*--- Extract the overall match information ------------------------------*/
   parse var Answer MatchStart MatchLength SubMatch;
   say '   * Match starts at posn ' || MatchStart || ' and is ' || MatchLength || ' bytes long.';

   /*--- Extract the submatch information -----------------------------------*/
   Index = 0;
   do  forever
       /*--- Extract info ---------------------------------------------------*/
       parse var SubMatch SubMatchStart SubMatchLength SubMatch;

       /*--- Make sure we have the information ------------------------------*/
       if  SubMatchLength = '' then
           leave;

       /*--- Report the information -----------------------------------------*/
       Index = Index + 1;
       say '   * Match (' || Index || ') starts at posn ' || SubMatchStart || ' and is ' || SubMatchLength || ' bytes long.';
   end;
end;

/*--- Make change -----------------------------------------------------------*/
say ''
say 'RegExpReplace';
say '~~~~~~~~~~~~~';
Before = "xxx\0yyy"
say 'Replacing: ' || Before
Answer = '?';
MatchRc = RegExpReplace(Before, "Answer");
say 'ReplaceRc = ' || MatchRc;
say 'Answer    = ' || Answer;

/*--- Close Regular expression ----------------------------------------------*/
say '';
say 'RegExpCompile(ReClose)';
say '~~~~~~~~~~~~~~~~~~~~~~';
say RegExpCompile("ReClose");
exit(0);


/*===========================================================================*/
RegExpOk:
/*                                                                           */
/* None of the rexx 'Rx' functions (add/drop/query) work correctly.  The     */
/* return code can't be trusted.                                             */
/*                                                                           */
/* This routine will return 'Y' if the DLL can be accessed.  It calls one    */
/* of the known functions.  We have already registered it so if we fail then */
/* the registration failed.                                                  */
/*                                                                           */
/* Note that as this code is within a subroutine the trap handler we set up  */
/* does not override and set up in the calling code once this routine        */
/* returns.                                                                  */
/*===========================================================================*/
   /*--- Get up trap handler and execute the command ------------------------*/
   signal on SYNTAX  name RegExpNotOk;
   interpret "DummyReRc = RegExpVersion('ReVersion')";

   /*--- We did not die so the function must be available -------------------*/
   return('Y');

   /*--- We must have died so the function is unavailable -------------------*/
   RegExpNotOk:
   return('N');



/*===========================================================================*/
GetLineNumber:
/*===========================================================================*/
   return( SIGL );


