/******************************| Install.Cmd |*******************************
 |                                                                          |
 | RexxPhone Installation program.                                          |
 |                                                                          |
 |                                                                          |
 | Copyright 1994 Silver Bullet Software, Inc.                              |
 |                                                                          |
 ****************************************************************************/
'@echo off'

  signal on halt
  Say "Installation Program for REXXPHONE."
  Say "Copyright 1994, Silver Bullet Software, Inc."
  Say " "

  rc = RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs')
  rc = SysLoadFuncs()

  rxphone = Value( 'RXPHONE',, 'OS2ENVIRONMENT' )
  if rxphone = "" then do
    map = SysDriveMap()
    say "Enter the drive to install RexxPhone ("||map||")."
    Pull drive
    destdir = drive||"\RxPhone"
    End
  else do
    drive = FileSpec( "drive", rxphone )
    destdir = rxphone
    End

  say " "
  say "Installing RexxPhone to" destdir


  /* If we can create a RxPhone directory on the drive, continue. */

  rc = SysMkDir( destdir )
  if rc = 5 then do
    say "Directory" destdir "already exists."
    say "OK to continue installation of RexxPhone (y/n)?"
    Pull answer
    if answer \= 'Y' then signal Halt
    End
  else if rc \= 0 then do
    say "Could not create directory" destdir
    say "Check if" drive "is a valid drive."
    signal Halt
    End

  /* Create RexxPhone directory structure. */
  rc = SysMkDir( destdir||"\Samples" )
  rc = SysMkDir( destdir||"\Samples\Rexx" )
  rc = SysMkDir( destdir||"\Samples\VXRexx" )
  rc = SysMkDir( destdir||"\Samples\VXRexx\Machine" )
  rc = SysMkDir( destdir||"\Samples\VXRexx\Machine\Project" )
  rc = SysMkDir( destdir||"\Samples\VXRexx\Monitor" )
  rc = SysMkDir( destdir||"\Samples\VXRexx\Monitor\Project" )
  rc = SysMkDir( destdir||"\Samples\VXRexx\Recorder" )
  rc = SysMkDir( destdir||"\Extras" )

  Parse Source . . thisfile
  packfile = FileSpec( "drive", thisfile )||"\RxPhone.pak"
  destfile = drive||"\RxPhone\RxPhone.pak"

  say "Copying compressed RexxPhone from" packfile "to" destfile||"."
  Address CMD "Copy" packfile destfile      /* Copy over packed file. */
  rc = Directory( destdir )
  say "Unpacking..."
  Address CMD "UnPack" destfile             /* Unpack the file. */
  Address CMD "Erase" destfile              /* Erase it. */

  /* Now copy .dll's to \os2\dll */
  bootpath = Value( 'Path',, 'OS2ENVIRONMENT' )
  Parse Upper Var bootpath bootpath
  bootdrive = Substr( bootpath, Pos('\OS2\SYSTEM', bootpath)-2, 2 )

  dlldir = bootdrive||"\OS2\DLL"

  fromdll = destdir||"\DlgPhone.dll"
  todll = dlldir||"\DlgPhone.dll"
  say "Copying DlgPhone.dll to" todll
  Address CMD "Copy" fromdll todll

  vxrexx = Value( 'VXREXX',, 'OS2ENVIRONMENT' )
  if vxrexx = "" then do
    fromdll = destdir||"\VRObj.dll"
    todll = dlldir||"\VRObj.dll"
    say "Copying VRObj.dll to" todll
    Address CMD "Copy" fromdll todll
    End
  else do
    say " "
    say "VX-REXX is already installed."
    say "VRObj.dll will not be installed."
    say "See the Read.Me file on the install disk."
    say " "
    End

  if rxphone = "" then do
    config = bootdrive||"\config.sys"
    configbak = bootdrive||"\config.bak"
    say "Copying config.sys to" configbak
    Address CMD "Copy" config configbak
    rc = LineOut( config, "Set RXPHONE="||destdir )
    say "Config.sys updated."
    say "Reboot to effectuate changes."
    End

  rc = SysDropFuncs()

  /* Build folder on desktop. */
  Call Build.cmd

  say
  say "See the Read.Me file in" destdir "for the latest information."
  say "Installation of RexxPhone ended normally."
  Exit


Halt:
  rc = SysDropFuncs()
  say "Installation of RexxPhone halted."
  Exit

